/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import io.scanbot.barcodescanner.BarCodeScanner;
import io.scanbot.barcodescanner.model.BarCodeItem;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.util.PreviewImageUtil;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J2\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J*\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J*\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J4\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J*\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020(H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00132\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e00H\u0002J\u0010\u0010\u000f\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020&H\u0016J\u0016\u00101\u001a\u00020%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020(03H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020&H\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/scanbot/sdk/barcode/DefaultScanbotBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "barcodeFormatsFilter", "Ljava/util/ArrayList;", "Lio/scanbot/barcodescanner/model/BarCodeType;", "Lkotlin/collections/ArrayList;", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "sapManager", "Lio/scanbot/sap/SapManager;", "saveCameraPreviewFrame", "scanner", "Lio/scanbot/barcodescanner/BarCodeScanner;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "nv21", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "detectFromBitmap", "bitmap", "Landroid/graphics/Bitmap;", "detectFromJpeg", "jpeg", "detectFromNv21", "detectFromRgba", "img", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "getCoreFormat", "barcodeFormat", "processResult", "codeScannerResult", "Lio/scanbot/barcodescanner/model/BarCodeScannerResult;", "createPreview", "Lkotlin/Function0;", "setBarcodeFormatsFilter", "barcodeFormats", "", "setupHighSensitivityMode", "highSensitivityModeEnabled", "sdk-barcode_release"})
public final class DefaultScanbotBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private BarCodeScanner scanner;
    private final SapManager sapManager;
    private final ArrayList<BarCodeType> barcodeFormatsFilter;
    private final AtomicBoolean barcodeScanEnabled;
    private AtomicBoolean saveCameraPreviewFrame;

    @Override
    public void saveCameraPreviewFrame(boolean saveCameraPreviewFrame) {
        this.saveCameraPreviewFrame.set(saveCameraPreviewFrame);
    }

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public void setupHighSensitivityMode(boolean highSensitivityModeEnabled) {
        this.scanner.setHighSensitivityMode(highSensitivityModeEnabled);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Collection<BarCodeType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(barcodeFormats, (String)"barcodeFormats");
        this.barcodeFormatsFilter.clear();
        Iterable iterable = barcodeFormats;
        ArrayList<BarCodeType> arrayList = this.barcodeFormatsFilter;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            BarCodeType barCodeType = this.getCoreFormat((BarcodeFormat)it);
            collection.add(barCodeType);
        }
        collection = (List)destination$iv$iv;
        arrayList.addAll(collection);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] nv21, int width, int height, int frameOrientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        return this.detectFromNv21(nv21, width, height, frameOrientation);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] nv21, int width, int height, int frameOrientation, @NotNull Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        Intrinsics.checkNotNullParameter((Object)finderRect, (String)"finderRect");
        return this.detectFromNv21(nv21, width, height, frameOrientation, finderRect);
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromNv21(@NotNull byte[] nv21, int width, int height, int frameOrientation) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        return this.detectFromNv21(nv21, width, height, frameOrientation, null);
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromNv21(@NotNull byte[] nv21, int width, int height, int frameOrientation, @Nullable Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        BarCodeScannerResult codeScannerResult = finderRect != null ? this.scanner.detectAndDecodeInArea(nv21, (List)this.barcodeFormatsFilter, finderRect, width, height, frameOrientation) : this.scanner.detectAndDecode(nv21, (List)this.barcodeFormatsFilter, width, height, frameOrientation);
        return this.processResult(codeScannerResult, (Function0<Bitmap>)((Function0)new Function0<Bitmap>(nv21, width, height, frameOrientation){
            final /* synthetic */ byte[] $nv21;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ int $frameOrientation;

            @NotNull
            public final Bitmap invoke() {
                return PreviewImageUtil.convertNV21ToBitmap((byte[])this.$nv21, (int)this.$width, (int)this.$height, (int)this.$frameOrientation);
            }
            {
                this.$nv21 = byArray;
                this.$width = n;
                this.$height = n2;
                this.$frameOrientation = n3;
                super(0);
            }
        }));
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromJpeg(@NotNull byte[] jpeg, int width, int height, int frameOrientation) {
        Intrinsics.checkNotNullParameter((Object)jpeg, (String)"jpeg");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        BarCodeScannerResult codeScannerResult = this.scanner.detectAndDecodeJPEG(jpeg, (List)this.barcodeFormatsFilter, width, height, frameOrientation);
        return this.processResult(codeScannerResult, (Function0<Bitmap>)((Function0)new Function0<Bitmap>(jpeg){
            final /* synthetic */ byte[] $jpeg;

            @NotNull
            public final Bitmap invoke() {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])this.$jpeg, (int)0, (int)this.$jpeg.length);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeByteArray(jpeg, 0, jpeg.size)");
                return bitmap;
            }
            {
                this.$jpeg = byArray;
                super(0);
            }
        }));
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromRgba(@NotNull byte[] img, int width, int height, int frameOrientation) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        BarCodeScannerResult codeScannerResult = this.scanner.detectAndDecodeRgba(img, (List)this.barcodeFormatsFilter, width, height, frameOrientation);
        return this.processResult(codeScannerResult, (Function0<Bitmap>)((Function0)new Function0<Bitmap>(width, height, img){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ byte[] $img;

            @NotNull
            public final Bitmap invoke() {
                Bitmap bitmap = Bitmap.createBitmap((int)this.$width, (int)this.$height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                ByteBuffer buffer = ByteBuffer.wrap(this.$img);
                bitmap.copyPixelsFromBuffer((Buffer)buffer);
                Bitmap bitmap2 = bitmap;
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                return bitmap2;
            }
            {
                this.$width = n;
                this.$height = n2;
                this.$img = byArray;
                super(0);
            }
        }));
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromBitmap(@NotNull Bitmap bitmap, int frameOrientation) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        BarCodeScannerResult codeScannerResult = this.scanner.detectAndDecodeBitmap(bitmap, (List)this.barcodeFormatsFilter, frameOrientation);
        return this.processResult(codeScannerResult, (Function0<Bitmap>)((Function0)new Function0<Bitmap>(bitmap){
            final /* synthetic */ Bitmap $bitmap;

            @NotNull
            public final Bitmap invoke() {
                return this.$bitmap;
            }
            {
                this.$bitmap = bitmap;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final BarcodeScanningResult processResult(BarCodeScannerResult codeScannerResult, Function0<Bitmap> createPreview) {
        BarcodeScanningResult barcodeScanningResult;
        void $this$mapTo$iv$iv;
        BarCodeScannerResult barCodeScannerResult = codeScannerResult;
        if (barCodeScannerResult == null) return null;
        if (!barCodeScannerResult.getSuccess()) {
            return null;
        }
        Iterable $this$map$iv = codeScannerResult.getDetectedBarCodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BarCodeItem barCodeItem = (BarCodeItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getRawString();
            if (string == null) {
                string = "";
            }
            BarcodeItem barcodeItem = new BarcodeItem(string, it.getRawBytes(), null, this.getAppFormat(it.getType()), it.getFormattedResult(), null, it.getImage());
            collection.add(barcodeItem);
        }
        List detectedBarcodes = (List)destination$iv$iv;
        if (this.saveCameraPreviewFrame.get()) {
            Collection collection = detectedBarcodes;
            boolean bl = false;
            if (!collection.isEmpty()) {
                barcodeScanningResult = new BarcodeScanningResult(detectedBarcodes, 0L, (Bitmap)createPreview.invoke(), 2, null);
                return barcodeScanningResult;
            }
        }
        barcodeScanningResult = new BarcodeScanningResult(detectedBarcodes, 0L, 2, null);
        return barcodeScanningResult;
    }

    private final BarcodeFormat getAppFormat(BarCodeType zxingBarcodeFormat) {
        if (zxingBarcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[zxingBarcodeFormat.ordinal()]) {
            case 1: {
                return BarcodeFormat.AZTEC;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 10: {
                return BarcodeFormat.PDF_417;
            }
            case 11: {
                return BarcodeFormat.QR_CODE;
            }
            case 12: {
                return BarcodeFormat.RSS_14;
            }
            case 13: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 14: {
                return BarcodeFormat.UPC_A;
            }
            case 15: {
                return BarcodeFormat.UPC_E;
            }
            case 16: {
                return BarcodeFormat.MSI_PLESSEY;
            }
        }
        return BarcodeFormat.UNKNOWN;
    }

    private final BarCodeType getCoreFormat(BarcodeFormat barcodeFormat) {
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[barcodeFormat.ordinal()]) {
            case 1: {
                return BarCodeType.AZTEC;
            }
            case 2: {
                return BarCodeType.CODABAR;
            }
            case 3: {
                return BarCodeType.CODE_39;
            }
            case 4: {
                return BarCodeType.CODE_93;
            }
            case 5: {
                return BarCodeType.CODE_128;
            }
            case 6: {
                return BarCodeType.DATA_MATRIX;
            }
            case 7: {
                return BarCodeType.EAN_8;
            }
            case 8: {
                return BarCodeType.EAN_13;
            }
            case 9: {
                return BarCodeType.ITF;
            }
            case 10: {
                return BarCodeType.PDF_417;
            }
            case 11: {
                return BarCodeType.QR_CODE;
            }
            case 12: {
                return BarCodeType.RSS_14;
            }
            case 13: {
                return BarCodeType.RSS_EXPANDED;
            }
            case 14: {
                return BarCodeType.UPC_A;
            }
            case 15: {
                return BarCodeType.UPC_E;
            }
            case 16: {
                return BarCodeType.MSI_PLESSEY;
            }
        }
        return BarCodeType.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultScanbotBarcodeDetector(@NotNull BlobManager blobManager) {
        Collection<BarCodeType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        this.logger = LoggerProvider.getLogger();
        this.barcodeFormatsFilter = new ArrayList();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.saveCameraPreviewFrame = new AtomicBoolean(false);
        String barcodeDetectionModelPath = null;
        String barcodeBinarizationModelPath = null;
        try {
            barcodeDetectionModelPath = blobManager.getBarcodeDetectionModelFile().getPath();
            barcodeBinarizationModelPath = blobManager.getBarcodeBinarizationModelFile().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Barcode scanner model blob is not available.");
        }
        String string = barcodeDetectionModelPath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"barcodeDetectionModelPath");
        String string2 = barcodeBinarizationModelPath;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"barcodeBinarizationModelPath");
        this.scanner = new BarCodeScanner(string, string2);
        this.sapManager = SapSingleton.getInstance();
        Iterable e = BarcodeFormat.COMMON_CODES;
        ArrayList<BarCodeType> arrayList = this.barcodeFormatsFilter;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BarcodeFormat barcodeFormat = (BarcodeFormat)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            BarCodeType barCodeType = this.getCoreFormat((BarcodeFormat)it);
            collection.add(barCodeType);
        }
        collection = (List)destination$iv$iv;
        arrayList.addAll(collection);
    }
}

