/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import io.scanbot.barcodescanner.BarCodeScanner;
import io.scanbot.barcodescanner.model.BarCodeFormattedResult;
import io.scanbot.barcodescanner.model.BarCodeItem;
import io.scanbot.barcodescanner.model.BarCodeScannerResult;
import io.scanbot.barcodescanner.model.BarCodeType;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.util.PreviewImageUtil;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010D\u001a\u00020C\u00a2\u0006\u0004\bE\u0010FJ)\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\b\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\b\u0010\rJ\u0017\u0010\b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u001d\u0010\u001a\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\"\u0010#J9\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b\"\u0010&J1\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b'\u0010#J;\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0004\b'\u0010&J1\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b)\u0010#J1\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b+\u0010#J!\u0010-\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b-\u0010.R\u0016\u00101\u001a\u00020/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00100R\u0016\u00105\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00109\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R&\u0010>\u001a\u0012\u0012\u0004\u0012\u00020\n0:j\b\u0012\u0004\u0012\u00020\n`;8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010\u0011\u001a\u00020?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010\u0014\u001a\u00020?8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010A\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/barcode/DefaultScanbotBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "Lio/scanbot/barcodescanner/model/BarCodeScannerResult;", "codeScannerResult", "Lkotlin/Function0;", "Landroid/graphics/Bitmap;", "createPreview", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "a", "(Lio/scanbot/barcodescanner/model/BarCodeScannerResult;Lkotlin/jvm/functions/Function0;)Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/barcodescanner/model/BarCodeType;", "zxingBarcodeFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "(Lio/scanbot/barcodescanner/model/BarCodeType;)Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "barcodeFormat", "(Lio/scanbot/sdk/barcode/entity/BarcodeFormat;)Lio/scanbot/barcodescanner/model/BarCodeType;", "", "saveCameraPreviewFrame", "", "(Z)V", "barcodeScanEnabled", "enableBarcodeScan", "highSensitivityModeEnabled", "setupHighSensitivityMode", "", "barcodeFormats", "setBarcodeFormatsFilter", "(Ljava/util/List;)V", "", "nv21", "", "width", "height", "frameOrientation", "decodeWithState", "([BIII)Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Landroid/graphics/Rect;", "finderRect", "([BIIILandroid/graphics/Rect;)Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "detectFromNv21", "jpeg", "detectFromJpeg", "img", "detectFromRgba", "bitmap", "detectFromBitmap", "(Landroid/graphics/Bitmap;I)Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/barcodescanner/BarCodeScanner;", "b", "Lio/scanbot/barcodescanner/BarCodeScanner;", "scanner", "Lio/scanbot/sap/SapManager;", "c", "Lio/scanbot/sap/SapManager;", "sapManager", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "d", "Ljava/util/ArrayList;", "barcodeFormatsFilter", "Ljava/util/concurrent/atomic/AtomicBoolean;", "f", "Ljava/util/concurrent/atomic/AtomicBoolean;", "e", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;)V", "sdk-barcode_release"})
public final class DefaultScanbotBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger a;
    private BarCodeScanner b;
    private final SapManager c;
    private final ArrayList<BarCodeType> d;
    private final AtomicBoolean e;
    private AtomicBoolean f;

    private final BarcodeScanningResult a(BarCodeScannerResult object, Function0<Bitmap> function0) {
        if (object != null && object.getSuccess()) {
            Object object2;
            ArrayList<BarcodeItem> arrayList;
            object = object.getDetectedBarCodes();
            ArrayList<BarcodeItem> arrayList2 = arrayList;
            arrayList = new ArrayList<BarcodeItem>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                Object object3;
                Object object4 = (BarCodeItem)object.next();
                String string = object4.getRawString();
                if (string == null) {
                    string = "";
                }
                BarcodeItem barcodeItem = object3;
                String string2 = string;
                BarCodeItem barCodeItem = object4;
                BarCodeItem barCodeItem2 = object4;
                object4 = barCodeItem2.getRawBytes();
                object3 = super.a(barCodeItem2.getType());
                string = barCodeItem.getFormattedResult();
                Bitmap bitmap = barCodeItem.getImage();
                barcodeItem(string2, (byte[])object4, null, (BarcodeFormat)((Object)object3), (BarCodeFormattedResult)string, null, bitmap);
                arrayList2.add(barcodeItem);
            }
            if (((DefaultScanbotBarcodeDetector)object2).f.get() && arrayList2.isEmpty() ^ true) {
                BarcodeScanningResult barcodeScanningResult;
                object2 = barcodeScanningResult;
                object = (Bitmap)function0.invoke();
                barcodeScanningResult = new BarcodeScanningResult(arrayList2, 0L, (Bitmap)object, 2, null);
            } else {
                BarcodeScanningResult barcodeScanningResult;
                object2 = barcodeScanningResult;
                barcodeScanningResult = new BarcodeScanningResult(arrayList2, 0L, 2, null);
            }
            return object2;
        }
        return null;
    }

    private final BarcodeFormat a(BarCodeType barCodeType) {
        if (barCodeType == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (DefaultScanbotBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barCodeType.ordinal()]) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 16: {
                return BarcodeFormat.MSI_PLESSEY;
            }
            case 15: {
                return BarcodeFormat.UPC_E;
            }
            case 14: {
                return BarcodeFormat.UPC_A;
            }
            case 13: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 12: {
                return BarcodeFormat.RSS_14;
            }
            case 11: {
                return BarcodeFormat.QR_CODE;
            }
            case 10: {
                return BarcodeFormat.PDF_417;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return BarcodeFormat.AZTEC;
    }

    private final BarCodeType a(BarcodeFormat barcodeFormat) {
        switch (barcodeFormat.ordinal()) {
            default: {
                return BarCodeType.UNKNOWN;
            }
            case 15: {
                return BarCodeType.MSI_PLESSEY;
            }
            case 14: {
                return BarCodeType.UPC_E;
            }
            case 13: {
                return BarCodeType.UPC_A;
            }
            case 12: {
                return BarCodeType.RSS_EXPANDED;
            }
            case 11: {
                return BarCodeType.RSS_14;
            }
            case 10: {
                return BarCodeType.QR_CODE;
            }
            case 9: {
                return BarCodeType.PDF_417;
            }
            case 8: {
                return BarCodeType.ITF;
            }
            case 7: {
                return BarCodeType.EAN_13;
            }
            case 6: {
                return BarCodeType.EAN_8;
            }
            case 5: {
                return BarCodeType.DATA_MATRIX;
            }
            case 4: {
                return BarCodeType.CODE_128;
            }
            case 3: {
                return BarCodeType.CODE_93;
            }
            case 2: {
                return BarCodeType.CODE_39;
            }
            case 1: {
                return BarCodeType.CODABAR;
            }
            case 0: 
        }
        return BarCodeType.AZTEC;
    }

    public DefaultScanbotBarcodeDetector(@NotNull BlobManager object) {
        ArrayList arrayList;
        Object object2;
        ArrayList arrayList2;
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        BlobManager blobManager = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"blobManager");
        this.a = LoggerProvider.getLogger();
        object = arrayList2;
        this.d = new ArrayList();
        this.e = new AtomicBoolean(true);
        this.f = new AtomicBoolean(false);
        Iterator iterator = blobManager.getBarcodeDetectionModelFile().getPath();
        try {
            object2 = blobManager.getBarcodeBinarizationModelFile().getPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Barcode scanner model blob is not available.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"barcodeDetectionModelPath");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"barcodeBinarizationModelPath");
        defaultScanbotBarcodeDetector.b = new BarCodeScanner((String)((Object)iterator), (String)object2);
        defaultScanbotBarcodeDetector.c = SapSingleton.getInstance();
        iterator = BarcodeFormat.COMMON_CODES;
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object2.add(this.a((BarcodeFormat)((Object)iterator.next())));
        }
        ((ArrayList)object).addAll(object2);
        return;
    }

    @Override
    public void saveCameraPreviewFrame(boolean bl) {
        this.f.set(bl);
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.e.set(bl);
    }

    @Override
    public void setupHighSensitivityMode(boolean bl) {
        this.b.setHighSensitivityMode(bl);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> object) {
        ArrayList<BarCodeType> arrayList;
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        Intrinsics.checkNotNullParameter(object, (String)"barcodeFormats");
        defaultScanbotBarcodeDetector.d.clear();
        ArrayList<BarCodeType> arrayList2 = defaultScanbotBarcodeDetector.d;
        ArrayList<BarCodeType> arrayList3 = arrayList;
        arrayList = new ArrayList<BarCodeType>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList3.add(this.a((BarcodeFormat)((Object)object.next())));
        }
        arrayList2.addAll(arrayList3);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        return this.detectFromNv21(byArray, n, n2, n3);
    }

    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] byArray, int n, int n2, int n3, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"finderRect");
        return this.detectFromNv21(byArray, n, n2, n3, rect);
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromNv21(@NotNull byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        return this.detectFromNv21(byArray, n, n2, n3, null);
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromNv21(final @NotNull byte[] byArray, final int n, final int n2, final int n3, @Nullable Rect rect) {
        Function0<Bitmap> function0;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        if (defaultScanbotBarcodeDetector2.e.compareAndSet(false, false)) {
            return null;
        }
        if (!defaultScanbotBarcodeDetector2.c.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        rect = rect != null ? defaultScanbotBarcodeDetector2.b.detectAndDecodeInArea(byArray, defaultScanbotBarcodeDetector2.d, rect, n, n2, n3) : defaultScanbotBarcodeDetector2.b.detectAndDecode(byArray, defaultScanbotBarcodeDetector2.d, n, n2, n3);
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = defaultScanbotBarcodeDetector2;
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector2 = function0;
        function0 = new Function0<Bitmap>(){

            @NotNull
            public final Bitmap a() {
                c c2 = this;
                int n4 = c2.n;
                int n22 = c2.n2;
                int n32 = c2.n3;
                return PreviewImageUtil.convertNV21ToBitmap((byte[])byArray, (int)n4, (int)n22, (int)n32);
            }
        };
        return defaultScanbotBarcodeDetector.a((BarCodeScannerResult)rect, (Function0<Bitmap>)defaultScanbotBarcodeDetector2);
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromJpeg(final @NotNull byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"jpeg");
        if (this.e.compareAndSet(false, false)) {
            return null;
        }
        if (!this.c.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        return defaultScanbotBarcodeDetector.a(defaultScanbotBarcodeDetector.b.detectAndDecodeJPEG(byArray, this.d, n, n2, n3), new Function0<Bitmap>(){

            @NotNull
            public final Bitmap a() {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeByteArray(jpeg, 0, jpeg.size)");
                return bitmap;
            }
        });
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromRgba(final @NotNull byte[] byArray, final int n, final int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"img");
        if (this.e.compareAndSet(false, false)) {
            return null;
        }
        if (!this.c.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        return defaultScanbotBarcodeDetector.a(defaultScanbotBarcodeDetector.b.detectAndDecodeRgba(byArray, this.d, n, n2, n3), new Function0<Bitmap>(){

            @NotNull
            public final Bitmap a() {
                Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(byArray));
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                return bitmap;
            }
        });
    }

    @Override
    @Nullable
    public BarcodeScanningResult detectFromBitmap(final @NotNull Bitmap bitmap, int n) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.e.compareAndSet(false, false)) {
            return null;
        }
        if (!this.c.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
            return null;
        }
        DefaultScanbotBarcodeDetector defaultScanbotBarcodeDetector = this;
        return defaultScanbotBarcodeDetector.a(defaultScanbotBarcodeDetector.b.detectAndDecodeBitmap(bitmap, this.d, n), new Function0<Bitmap>(){

            @NotNull
            public final Bitmap a() {
                return bitmap;
            }
        });
    }
}

