/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.util.log.Logger;

public final class DebugLog
implements Logger {
    public static final String LOG_DIRECTORY = "debug_logs";
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared = false;
    private static boolean savingEnabled = true;
    private static boolean echoEnabled = true;
    private static Logger.Level savingLevel = Logger.Level.Verbose;
    private static Logger.Level echoLevel = Logger.Level.Verbose;
    private static String packageName = "default";

    public DebugLog(Context context) {
        prepared = true;
        if (context != null) {
            packageName = context.getPackageName();
            this.printVersionInfo(context);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    private void printVersionInfo(Context context) {
        String message;
        PackageManager packageMgr = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageMgr.getPackageInfo(packageName, 0);
            int appLabelId = packageInfo.applicationInfo.labelRes;
            message = (appLabelId != 0 ? context.getString(appLabelId) : UNKNOWN_SIGNATURE) + " v" + packageInfo.versionName + " #" + packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logException(e);
            message = NO_APPLICATION_INFO_MESSAGE;
        }
        this.i("APP_INFO", message);
    }

    @Override
    public void d(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Debug);
    }

    @Override
    public void w(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Warning);
    }

    @Override
    public void e(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Error);
    }

    @Override
    public void i(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Information);
    }

    public void e(String tag, String where, Throwable e) {
        String message = "Exception in " + where + ": " + e.getClass().getName() + LOG_FIELD_SEPARATOR + e.getMessage();
        this.e(tag, message);
    }

    public void d(String message) {
        String tag = this.getCallerClassName();
        this.d(tag, message);
    }

    public void i(String message) {
        String tag = this.getCallerClassName();
        this.i(tag, message);
    }

    public void w(String message) {
        String tag = this.getCallerClassName();
        this.w(tag, message);
    }

    public void e(String message) {
        String tag = this.getCallerClassName();
        this.e(tag, message);
    }

    @Override
    public void logException(Throwable e) {
        if (!prepared) {
            return;
        }
        String tag = this.getCallerClassName();
        String where = this.getCallerMethodName();
        if (e != null) {
            this.e(tag, where, e);
        } else {
            this.e(tag, where, new Exception("Unknown exception"));
        }
    }

    @Override
    public void logMethod() {
        if (!prepared) {
            return;
        }
        String tag = this.getCallerClassName();
        String where = this.getCallerMethodName();
        this.i(tag, where);
    }

    private void logMessage(String tag, String message, Logger.Level level) {
        if (!prepared) {
            return;
        }
        if (echoEnabled && level.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage(tag, message, level);
        }
        if (savingEnabled && level.ordinal() >= savingLevel.ordinal()) {
            this.logToFile(tag, message, level);
        }
    }

    private void echoMessage(String tag, String message, Logger.Level level) {
        switch (level) {
            case Debug: {
                Log.d((String)tag, (String)message);
                break;
            }
            case Error: {
                Log.e((String)tag, (String)message);
                break;
            }
            case Warning: {
                Log.w((String)tag, (String)message);
                break;
            }
            case Information: {
                Log.i((String)tag, (String)message);
                break;
            }
            case Verbose: {
                Log.v((String)tag, (String)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void logToFile(String tag, String message, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer != null) {
            try {
                writer.write(this.buildLogMessage(tag, message, level));
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeSafely(writer);
            }
        }
    }

    private void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String buildLogMessage(String tag, String message, Logger.Level level) {
        String editedTag = tag != null ? tag.replace('|', '/') : "";
        return TIME_FORMAT.format(new Date()) + (Object)((Object)level) + LOG_FIELD_SEPARATOR + editedTag + LOG_FIELD_SEPARATOR + message + "\r\n";
    }

    private Writer getLogWriter() {
        FileWriter writer = null;
        File externalStorage = Environment.getExternalStorageDirectory();
        this.prepareLogsFolder(externalStorage);
        File logfile = new File(externalStorage, this.getLogFilename());
        try {
            writer = new FileWriter(logfile, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer;
    }

    private void prepareLogsFolder(File externalStorage) {
        File logDir = new File(externalStorage, LOG_DIRECTORY);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
    }

    private String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    private String tokenizeClassName(String className) {
        String result;
        ArrayList<String> parts = new ArrayList<String>();
        try {
            Matcher matcher = CLASS_NAME_PATTERN.matcher(className);
            while (matcher.find()) {
                String part = className.substring(matcher.start(), matcher.end());
                if (TextUtils.isEmpty((CharSequence)part.trim())) continue;
                parts.add(part.toUpperCase());
            }
            result = parts.isEmpty() ? className : TextUtils.join((CharSequence)"_", parts);
        }
        catch (Exception e) {
            result = className;
        }
        return result;
    }

    private String getCallerClassName() {
        String className;
        int CALLER_STACK_INDEX = 4;
        try {
            String fullClassName;
            int lastPoint;
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            className = callStack.length > 4 ? ((lastPoint = (fullClassName = callStack[4].getClassName()).lastIndexOf(".")) >= 0 && lastPoint + 1 < fullClassName.length() ? fullClassName.substring(lastPoint + 1) : UNKNOWN_SIGNATURE) : UNKNOWN_SIGNATURE;
        }
        catch (Exception e) {
            className = UNKNOWN_SIGNATURE;
        }
        return this.tokenizeClassName(className);
    }

    private String getCallerMethodName() {
        String methodName;
        int CALLER_STACK_INDEX = 4;
        try {
            StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
            methodName = callStack.length > 4 ? callStack[4].getMethodName() : UNKNOWN_SIGNATURE;
        }
        catch (Exception e) {
            methodName = UNKNOWN_SIGNATURE;
        }
        return methodName;
    }
}

