/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.autosnapping;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.scanbot.sdk.camera.autosnapping.SignificantMoveListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\fJ\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/camera/autosnapping/SignificantMoveCatcher;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "acceleration", "", "accelerometer", "Landroid/hardware/Sensor;", "currentAcceleration", "lastAcceleration", "moveListener", "Lio/scanbot/sdk/camera/autosnapping/SignificantMoveListener;", "sensorManager", "Landroid/hardware/SensorManager;", "onAccuracyChanged", "", "sensor", "accuracy", "", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "registerSensorListener", "registerSignificantMoveListener", "listener", "unregisterSensorListener", "unregisterSignificantMoveListener", "sdk-base_release"})
public final class SignificantMoveCatcher
implements SensorEventListener {
    private final SensorManager sensorManager;
    private final Sensor accelerometer;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener;

    private final void registerSensorListener() {
        block1: {
            if (this.accelerometer == null) break block1;
            SensorManager sensorManager = this.sensorManager;
            if (sensorManager != null) {
                sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 2);
            }
        }
    }

    private final void unregisterSensorListener() {
        block0: {
            SensorManager sensorManager = this.sensorManager;
            if (sensorManager == null) break block0;
            sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public final void registerSignificantMoveListener(@Nullable SignificantMoveListener listener) {
        if (listener != null && this.moveListener != listener) {
            this.moveListener = listener;
            this.registerSensorListener();
        }
    }

    public final void unregisterSignificantMoveListener(@Nullable SignificantMoveListener listener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Sensor sensor = event.sensor;
            Intrinsics.checkNotNullExpressionValue((Object)sensor, (String)"event.sensor");
            if (sensor.getType() != 1) break block2;
            float[] gravity = (float[])event.values.clone();
            float x = gravity[0];
            float y = gravity[1];
            float z = gravity[2];
            this.lastAcceleration = this.currentAcceleration;
            double d = (double)(x * x + y * y) + (double)(z * z);
            boolean bl = false;
            this.currentAcceleration = (float)Math.sqrt(d);
            float delta = this.currentAcceleration - this.lastAcceleration;
            this.acceleration = this.acceleration * 0.9f + delta;
            SignificantMoveListener significantMoveListener = this.moveListener;
            if (significantMoveListener != null) {
                SignificantMoveListener significantMoveListener2 = significantMoveListener;
                bl = false;
                boolean bl2 = false;
                SignificantMoveListener it = significantMoveListener2;
                boolean bl3 = false;
                if (this.acceleration > it.getMoveThreshold()) {
                    it.onSignificantMove();
                }
            }
        }
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    public SignificantMoveCatcher(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("sensor");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        this.sensorManager = (SensorManager)object;
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }
}

