/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.PointF;
import android.util.Size;
import android.view.Display;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DisplayOrientedMeteringPointFactory;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.view.PreviewView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0015J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/ui/camera/PreviewViewMeteringPointFactory;", "Landroidx/camera/core/MeteringPointFactory;", "display", "Landroid/view/Display;", "cameraInfo", "Landroidx/camera/core/CameraInfo;", "resolution", "Landroid/util/Size;", "scaleType", "Landroidx/camera/view/PreviewView$ScaleType;", "viewWidth", "", "viewHeight", "(Landroid/view/Display;Landroidx/camera/core/CameraInfo;Landroid/util/Size;Landroidx/camera/view/PreviewView$ScaleType;II)V", "displayOrientedMeteringPointFactory", "Landroidx/camera/core/DisplayOrientedMeteringPointFactory;", "factoryHeight", "", "factoryWidth", "isValid", "", "convertPoint", "Landroid/graphics/PointF;", "x", "y", "isNaturalPortrait", "sdk-base_release"})
@SuppressLint(value={"RestrictedApi"})
public final class PreviewViewMeteringPointFactory
extends MeteringPointFactory {
    private final DisplayOrientedMeteringPointFactory displayOrientedMeteringPointFactory;
    private final float viewWidth;
    private final float viewHeight;
    private final float factoryWidth;
    private final float factoryHeight;
    private final PreviewView.ScaleType scaleType;
    private boolean isValid;

    @SuppressLint(value={"RestrictedApi"})
    @NotNull
    protected PointF convertPoint(float x, float y) {
        PointF pointF;
        MeteringPoint pt;
        if (!this.isValid) {
            return new PointF(2.0f, 2.0f);
        }
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.scaleType == PreviewView.ScaleType.FILL_START || this.scaleType == PreviewView.ScaleType.FIT_START) {
            offsetX = 0.0f;
            offsetY = 0.0f;
        } else if (this.scaleType == PreviewView.ScaleType.FILL_CENTER || this.scaleType == PreviewView.ScaleType.FIT_CENTER) {
            offsetX = (this.factoryWidth - this.viewWidth) / (float)2;
            offsetY = (this.factoryHeight - this.viewHeight) / (float)2;
        } else if (this.scaleType == PreviewView.ScaleType.FILL_END || this.scaleType == PreviewView.ScaleType.FIT_END) {
            offsetX = this.factoryWidth - this.viewWidth;
            offsetY = this.factoryHeight - this.viewHeight;
        }
        float adjustedX = x + offsetX;
        float adjustedY = y + offsetY;
        DisplayOrientedMeteringPointFactory displayOrientedMeteringPointFactory = this.displayOrientedMeteringPointFactory;
        MeteringPoint meteringPoint = pt = displayOrientedMeteringPointFactory != null ? displayOrientedMeteringPointFactory.createPoint(adjustedX, adjustedY) : null;
        if (meteringPoint != null) {
            MeteringPoint meteringPoint2 = meteringPoint;
            boolean bl = false;
            boolean bl2 = false;
            MeteringPoint it = meteringPoint2;
            boolean bl3 = false;
            pointF = new PointF(pt.getX(), pt.getY());
        } else {
            pointF = new PointF(0.0f, 0.0f);
        }
        return pointF;
    }

    private final boolean isNaturalPortrait(Display display) {
        Point deviceSize = new Point();
        display.getRealSize(deviceSize);
        int rotation = display.getRotation();
        int width = deviceSize.x;
        int height = deviceSize.y;
        return (rotation == 0 || rotation == 2) && width < height || (rotation == 1 || rotation == 3) && width >= height;
    }

    public PreviewViewMeteringPointFactory(@NotNull Display display, @NotNull CameraInfo cameraInfo, @Nullable Size resolution, @NotNull PreviewView.ScaleType scaleType, int viewWidth, int viewHeight) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)cameraInfo, (String)"cameraInfo");
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.scaleType = scaleType;
        if (resolution == null || this.viewWidth <= 0.0f || this.viewHeight <= 0.0f) {
            this.isValid = false;
            this.factoryHeight = 0.0f;
            this.factoryWidth = 0.0f;
            this.displayOrientedMeteringPointFactory = null;
        } else {
            float f;
            boolean bl;
            float f2;
            float f3;
            this.isValid = true;
            boolean needReverse = false;
            if (this.isNaturalPortrait(display)) {
                if (display.getRotation() == 0 || display.getRotation() == 2) {
                    needReverse = true;
                }
            } else if (display.getRotation() == 1 || display.getRotation() == 3) {
                needReverse = true;
            }
            int bufferRotatedWidth = 0;
            int bufferRotatedHeight = 0;
            if (needReverse) {
                bufferRotatedWidth = resolution.getHeight();
                bufferRotatedHeight = resolution.getWidth();
            } else {
                bufferRotatedWidth = resolution.getWidth();
                bufferRotatedHeight = resolution.getHeight();
            }
            float scale = 0.0f;
            if (this.scaleType == PreviewView.ScaleType.FILL_CENTER || this.scaleType == PreviewView.ScaleType.FILL_START || this.scaleType == PreviewView.ScaleType.FILL_END) {
                f3 = (float)viewWidth / (float)bufferRotatedWidth;
                f2 = (float)viewHeight / (float)bufferRotatedHeight;
                bl = false;
                f = Math.max(f3, f2);
            } else if (this.scaleType == PreviewView.ScaleType.FIT_START || this.scaleType == PreviewView.ScaleType.FIT_CENTER || this.scaleType == PreviewView.ScaleType.FIT_END) {
                f3 = (float)viewWidth / (float)bufferRotatedWidth;
                f2 = (float)viewHeight / (float)bufferRotatedHeight;
                bl = false;
                f = Math.min(f3, f2);
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown scale type " + scaleType);
            }
            scale = f;
            this.factoryWidth = (float)bufferRotatedWidth * scale;
            this.factoryHeight = (float)bufferRotatedHeight * scale;
            this.displayOrientedMeteringPointFactory = new DisplayOrientedMeteringPointFactory(display, cameraInfo, this.factoryWidth, this.factoryHeight);
        }
    }
}

