/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001bH\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils;", "", "()V", "TAG", "", "computeCropRectFromAspectRatio", "Landroid/graphics/Rect;", "sourceSize", "Landroid/util/Size;", "aspectRatio", "Landroid/util/Rational;", "cropByteArray", "", "data", "cropRect", "imageToJpegByteArray", "image", "Landroidx/camera/core/ImageProxy;", "inverseRational", "rational", "isAspectRatioValid", "", "isCropAspectRatioHasEffect", "jpegImageToJpegByteArray", "nv21ToJpeg", "nv21", "width", "", "height", "rotate", "rotation", "shouldCropImage", "yuv420888toNv21", "yuvImageToJpegByteArray", "CodecFailedException", "sdk-base_release"})
public final class CameraXImageUtils {
    private static final String TAG = "ImageUtil";
    public static final CameraXImageUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) throws CodecFailedException {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        byte[] data = null;
        switch (image.getFormat()) {
            case 256: {
                data = INSTANCE.jpegImageToJpegByteArray(image);
                break;
            }
            case 35: {
                data = INSTANCE.yuvImageToJpegByteArray(image);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unrecognized image format: " + image.getFormat()));
            }
        }
        return data;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) throws CodecFailedException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (cropRect == null) {
            return data;
        }
        Bitmap bitmap = null;
        try {
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((byte[])data, (int)0, (int)data.length, (boolean)false);
            bitmap = decoder.decodeRegion(cropRect, new BitmapFactory.Options());
            decoder.recycle();
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new CodecFailedException("Decode byte array failed with illegal argument." + e, CodecFailedException.FailureType.DECODE_FAILED);
        }
        catch (IOException e) {
            throw (Throwable)new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        if (bitmap == null) {
            throw (Throwable)new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean success = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        if (!success) {
            throw (Throwable)new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        bitmap.recycle();
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        return aspectRatio != null && aspectRatio.floatValue() > 0.0f && !aspectRatio.isNaN();
    }

    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)sourceSize, (String)"sourceSize");
        return aspectRatio != null && aspectRatio.floatValue() > 0.0f && this.isCropAspectRatioHasEffect(sourceSize, aspectRatio) && !aspectRatio.isNaN();
    }

    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)sourceSize, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid(aspectRatio)) {
            Log.w((String)TAG, (String)"Invalid view ratio.");
            return null;
        }
        int sourceWidth = sourceSize.getWidth();
        int sourceHeight = sourceSize.getHeight();
        float srcRatio = (float)sourceWidth / (float)sourceHeight;
        int cropLeft = 0;
        int cropTop = 0;
        int outputWidth = sourceWidth;
        int outputHeight = sourceHeight;
        int numerator = aspectRatio.getNumerator();
        int denominator = aspectRatio.getDenominator();
        if (aspectRatio.floatValue() > srcRatio) {
            outputHeight = Math.round((float)sourceWidth / (float)numerator * (float)denominator);
            cropTop = (sourceHeight - outputHeight) / 2;
        } else {
            outputWidth = Math.round((float)sourceHeight / (float)denominator * (float)numerator);
            cropLeft = (sourceWidth - outputWidth) / 2;
        }
        return new Rect(cropLeft, cropTop, cropLeft + outputWidth, cropTop + outputHeight);
    }

    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        Intrinsics.checkNotNullParameter((Object)rational, (String)"rational");
        return rotation == 90 || rotation == 270 ? INSTANCE.inverseRational(rational) : rational;
    }

    private final byte[] nv21ToJpeg(byte[] nv21, int width, int height, Rect cropRect) throws CodecFailedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        YuvImage yuv = new YuvImage(nv21, 17, width, height, null);
        Rect rect = cropRect;
        if (rect == null) {
            rect = new Rect(0, 0, width, height);
        }
        boolean success = yuv.compressToJpeg(rect, 100, (OutputStream)out);
        if (!success) {
            throw (Throwable)new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] yuv420888toNv21(ImageProxy image) {
        ImageProxy.PlaneProxy yPlane = image.getPlanes()[0];
        ImageProxy.PlaneProxy uPlane = image.getPlanes()[1];
        ImageProxy.PlaneProxy vPlane = image.getPlanes()[2];
        ImageProxy.PlaneProxy planeProxy = yPlane;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"yPlane");
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"yPlane.buffer");
        ByteBuffer yBuffer = byteBuffer;
        ImageProxy.PlaneProxy planeProxy2 = uPlane;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy2, (String)"uPlane");
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"uPlane.buffer");
        ByteBuffer uBuffer = byteBuffer2;
        ImageProxy.PlaneProxy planeProxy3 = vPlane;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"vPlane");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"vPlane.buffer");
        ByteBuffer vBuffer = byteBuffer3;
        yBuffer.rewind();
        uBuffer.rewind();
        vBuffer.rewind();
        int ySize = yBuffer.remaining();
        int position = 0;
        byte[] nv21 = new byte[ySize + image.getWidth() * image.getHeight() / 2];
        int n = 0;
        int n2 = image.getHeight();
        while (n < n2) {
            void row;
            yBuffer.get(nv21, position, image.getWidth());
            position += image.getWidth();
            yBuffer.position(Math.min(ySize, yBuffer.position() - image.getWidth() + yPlane.getRowStride()));
            ++row;
        }
        int chromaHeight = image.getHeight() / 2;
        int chromaWidth = image.getWidth() / 2;
        int vRowStride = vPlane.getRowStride();
        int uRowStride = uPlane.getRowStride();
        int vPixelStride = vPlane.getPixelStride();
        int uPixelStride = uPlane.getPixelStride();
        byte[] vLineBuffer = new byte[vRowStride];
        byte[] uLineBuffer = new byte[uRowStride];
        int n3 = 0;
        int n4 = chromaHeight;
        while (n3 < n4) {
            void row;
            int n5 = vBuffer.remaining();
            boolean bl = false;
            vBuffer.get(vLineBuffer, 0, Math.min(vRowStride, n5));
            n5 = uBuffer.remaining();
            bl = false;
            uBuffer.get(uLineBuffer, 0, Math.min(uRowStride, n5));
            int vLineBufferPosition = 0;
            int uLineBufferPosition = 0;
            int n6 = 0;
            int n7 = chromaWidth;
            while (n6 < n7) {
                void col;
                nv21[position++] = vLineBuffer[vLineBufferPosition];
                nv21[position++] = uLineBuffer[uLineBufferPosition];
                vLineBufferPosition += vPixelStride;
                uLineBufferPosition += uPixelStride;
                ++col;
            }
            ++row;
        }
        return nv21;
    }

    private final boolean isCropAspectRatioHasEffect(Size sourceSize, Rational aspectRatio) {
        int denominator;
        int numerator;
        int sourceWidth = sourceSize.getWidth();
        int sourceHeight = sourceSize.getHeight();
        return sourceHeight != Math.round((float)sourceWidth / (float)(numerator = aspectRatio.getNumerator()) * (float)(denominator = aspectRatio.getDenominator())) || sourceWidth != Math.round((float)sourceHeight / (float)denominator * (float)numerator);
    }

    private final Rational inverseRational(Rational rational) {
        return rational == null ? rational : new Rational(rational.getDenominator(), rational.getNumerator());
    }

    private final boolean shouldCropImage(ImageProxy image) {
        Size sourceSize = new Size(image.getWidth(), image.getHeight());
        Size targetSize = new Size(image.getCropRect().width(), image.getCropRect().height());
        return Intrinsics.areEqual((Object)targetSize, (Object)sourceSize) ^ true;
    }

    private final byte[] jpegImageToJpegByteArray(ImageProxy image) throws CodecFailedException {
        ImageProxy.PlaneProxy[] planeProxyArray = image.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        ImageProxy.PlaneProxy[] planes = planeProxyArray;
        ImageProxy.PlaneProxy planeProxy = planes[0];
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[0]");
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
        ByteBuffer buffer = byteBuffer;
        buffer.rewind();
        byte[] data = new byte[buffer.capacity()];
        buffer.get(data);
        if (this.shouldCropImage(image)) {
            data = CameraXImageUtils.cropByteArray(data, image.getCropRect());
        }
        return data;
    }

    private final byte[] yuvImageToJpegByteArray(ImageProxy image) throws CodecFailedException {
        return this.nv21ToJpeg(this.yuv420888toNv21(image), image.getWidth(), image.getHeight(), this.shouldCropImage(image) ? image.getCropRect() : null);
    }

    private CameraXImageUtils() {
    }

    static {
        CameraXImageUtils cameraXImageUtils;
        INSTANCE = cameraXImageUtils = new CameraXImageUtils();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\fB\u0011\b\u0010\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0010\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "failureType", "Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "(Ljava/lang/String;Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;)V", "<set-?>", "getFailureType", "()Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "FailureType", "sdk-base_release"})
    public static final class CodecFailedException
    extends Exception {
        @NotNull
        private FailureType failureType;

        @NotNull
        public final FailureType getFailureType() {
            return this.failureType;
        }

        public CodecFailedException(@Nullable String message) {
            super(message);
            this.failureType = FailureType.UNKNOWN;
        }

        public CodecFailedException(@Nullable String message, @NotNull FailureType failureType) {
            Intrinsics.checkNotNullParameter((Object)((Object)failureType), (String)"failureType");
            super(message);
            this.failureType = failureType;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "", "(Ljava/lang/String;I)V", "ENCODE_FAILED", "DECODE_FAILED", "UNKNOWN", "sdk-base_release"})
        public static final class FailureType
        extends Enum<FailureType> {
            public static final /* enum */ FailureType ENCODE_FAILED;
            public static final /* enum */ FailureType DECODE_FAILED;
            public static final /* enum */ FailureType UNKNOWN;
            private static final /* synthetic */ FailureType[] $VALUES;

            static {
                FailureType[] failureTypeArray = new FailureType[3];
                FailureType[] failureTypeArray2 = failureTypeArray;
                failureTypeArray[0] = ENCODE_FAILED = new FailureType();
                failureTypeArray[1] = DECODE_FAILED = new FailureType();
                failureTypeArray[2] = UNKNOWN = new FailureType();
                $VALUES = failureTypeArray;
            }

            public static FailureType[] values() {
                return (FailureType[])$VALUES.clone();
            }

            public static FailureType valueOf(String string) {
                return Enum.valueOf(FailureType.class, string);
            }
        }
    }
}

