/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/ui/camera/util/ScaleTypeTransform;", "", "()V", "getFillScaleWithBufferAspectRatio", "Landroid/util/Pair;", "", "container", "Landroid/view/View;", "view", "bufferSize", "Landroid/util/Size;", "getFitScaleWithBufferAspectRatio", "getOriginOfCenteredView", "Landroid/graphics/Point;", "getRotationDegrees", "", "isNaturalPortrait", "", "context", "Landroid/content/Context;", "rotationDegrees", "rotationDegreesFromSurfaceRotation", "rotationConstant", "sdk-base_release"})
public final class ScaleTypeTransform {
    public static final ScaleTypeTransform INSTANCE;

    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NotNull View container, @NotNull View view, @NotNull Size bufferSize) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bufferSize, (String)"bufferSize");
        if (container.getWidth() == 0 || container.getHeight() == 0 || view.getWidth() == 0 || view.getHeight() == 0 || bufferSize.getWidth() == 0 || bufferSize.getHeight() == 0) {
            return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        }
        int viewRotationDegrees = ScaleTypeTransform.getRotationDegrees(view);
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(context, viewRotationDegrees);
        int bufferWidth = 0;
        int bufferHeight = 0;
        if (isNaturalPortrait) {
            bufferWidth = bufferSize.getHeight();
            bufferHeight = bufferSize.getWidth();
        } else {
            bufferWidth = bufferSize.getWidth();
            bufferHeight = bufferSize.getHeight();
        }
        float scaleX = (float)bufferWidth / (float)view.getWidth();
        float scaleY = (float)bufferHeight / (float)view.getHeight();
        int bufferRotatedWidth = 0;
        int bufferRotatedHeight = 0;
        if (viewRotationDegrees == 0 || viewRotationDegrees == 180) {
            bufferRotatedWidth = bufferWidth;
            bufferRotatedHeight = bufferHeight;
        } else {
            bufferRotatedWidth = bufferHeight;
            bufferRotatedHeight = bufferWidth;
        }
        float f = (float)container.getWidth() / (float)bufferRotatedWidth;
        float f2 = (float)container.getHeight() / (float)bufferRotatedHeight;
        boolean bl = false;
        float scale = Math.max(f, f2);
        return new Pair((Object)Float.valueOf(scaleX *= scale), (Object)Float.valueOf(scaleY *= scale));
    }

    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NotNull View container, @NotNull View view, @NotNull Size bufferSize) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bufferSize, (String)"bufferSize");
        if (container.getWidth() == 0 || container.getHeight() == 0 || view.getWidth() == 0 || view.getHeight() == 0 || bufferSize.getWidth() == 0 || bufferSize.getHeight() == 0) {
            return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        }
        int viewRotationDegrees = ScaleTypeTransform.getRotationDegrees(view);
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(context, viewRotationDegrees);
        int bufferWidth = 0;
        int bufferHeight = 0;
        if (isNaturalPortrait) {
            bufferWidth = bufferSize.getHeight();
            bufferHeight = bufferSize.getWidth();
        } else {
            bufferWidth = bufferSize.getWidth();
            bufferHeight = bufferSize.getHeight();
        }
        float scaleX = (float)bufferWidth / (float)view.getWidth();
        float scaleY = (float)bufferHeight / (float)view.getHeight();
        int bufferRotatedWidth = 0;
        int bufferRotatedHeight = 0;
        if (viewRotationDegrees == 0 || viewRotationDegrees == 180) {
            bufferRotatedWidth = bufferWidth;
            bufferRotatedHeight = bufferHeight;
        } else {
            bufferRotatedWidth = bufferHeight;
            bufferRotatedHeight = bufferWidth;
        }
        float f = (float)container.getWidth() / (float)bufferRotatedWidth;
        float f2 = (float)container.getHeight() / (float)bufferRotatedHeight;
        boolean bl = false;
        float scale = Math.min(f, f2);
        return new Pair((Object)Float.valueOf(scaleX *= scale), (Object)Float.valueOf(scaleY *= scale));
    }

    @JvmStatic
    @NotNull
    public static final Point getOriginOfCenteredView(@NotNull View container, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int offsetX = (view.getWidth() - container.getWidth()) / 2;
        int offsetY = (view.getHeight() - container.getHeight()) / 2;
        return new Point(-offsetX, -offsetY);
    }

    @JvmStatic
    public static final int getRotationDegrees(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Object object = view.getContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        if (windowManager == null) {
            return 0;
        }
        WindowManager windowManager2 = windowManager;
        Display display = windowManager2.getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"windowManager.defaultDisplay");
        int rotation = display.getRotation();
        return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(rotation);
    }

    @JvmStatic
    public static final boolean isNaturalPortrait(@NotNull Context context, int rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        if (windowManager == null) {
            return true;
        }
        WindowManager windowManager2 = windowManager;
        Display display = windowManager2.getDefaultDisplay();
        Point deviceSize = new Point();
        display.getRealSize(deviceSize);
        int width = deviceSize.x;
        int height = deviceSize.y;
        return (rotationDegrees == 0 || rotationDegrees == 180) && width < height || (rotationDegrees == 90 || rotationDegrees == 270) && width >= height;
    }

    @JvmStatic
    public static final int rotationDegreesFromSurfaceRotation(int rotationConstant) {
        int n;
        switch (rotationConstant) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Unsupported surface rotation constant: " + rotationConstant);
            }
        }
        return n;
    }

    private ScaleTypeTransform() {
    }

    static {
        ScaleTypeTransform scaleTypeTransform;
        INSTANCE = scaleTypeTransform = new ScaleTypeTransform();
    }
}

