/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import io.scanbot.sdk.util.log.LoggerProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/util/CursorUtil;", "", "()V", "closeQuietly", "", "cursor", "Landroid/database/Cursor;", "emptyCursor", "hasElements", "", "EmptyCursor", "sdk-base_release"})
public final class CursorUtil {
    public static final CursorUtil INSTANCE;

    @JvmStatic
    public static final void closeQuietly(@Nullable Cursor cursor) {
        try {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        catch (Exception e) {
            LoggerProvider.getLogger().logException(e);
        }
    }

    @JvmStatic
    public static final boolean hasElements(@Nullable Cursor cursor) {
        return cursor != null && cursor.getCount() > 0;
    }

    @JvmStatic
    @NotNull
    public static final Cursor emptyCursor() {
        return EmptyCursor.Companion.getEMPTY_CURSOR();
    }

    private CursorUtil() {
    }

    static {
        CursorUtil cursorUtil;
        INSTANCE = cursorUtil = new CursorUtil();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0015\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020(H\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u00100\u001a\u00020(H\u0016J\b\u00101\u001a\u00020(H\u0016J\b\u00102\u001a\u00020(H\u0016J\u0010\u00103\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u00104\u001a\u00020(H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020(H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010\u001a2\u0006\u0010=\u001a\u00020\u001aH\u0016J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u001aH\u0016J\u0018\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020!H\u0016J\u0010\u0010D\u001a\u00020\u00042\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010E\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0016\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/util/CursorUtil$EmptyCursor;", "Landroid/database/Cursor;", "()V", "close", "", "copyStringToBuffer", "i", "", "charArrayBuffer", "Landroid/database/CharArrayBuffer;", "deactivate", "getBlob", "", "getColumnCount", "getColumnIndex", "s", "", "getColumnIndexOrThrow", "getColumnName", "getColumnNames", "", "()[Ljava/lang/String;", "getCount", "getDouble", "", "getExtras", "Landroid/os/Bundle;", "getFloat", "", "getInt", "getLong", "", "getNotificationUri", "Landroid/net/Uri;", "getPosition", "getShort", "", "getString", "getType", "getWantsAllOnMoveCalls", "", "isAfterLast", "isBeforeFirst", "isClosed", "isFirst", "isLast", "isNull", "move", "moveToFirst", "moveToLast", "moveToNext", "moveToPosition", "moveToPrevious", "registerContentObserver", "contentObserver", "Landroid/database/ContentObserver;", "registerDataSetObserver", "dataSetObserver", "Landroid/database/DataSetObserver;", "requery", "respond", "bundle", "setExtras", "extras", "setNotificationUri", "contentResolver", "Landroid/content/ContentResolver;", "uri", "unregisterContentObserver", "unregisterDataSetObserver", "Companion", "sdk-base_release"})
    private static final class EmptyCursor
    implements Cursor {
        @NotNull
        private static final EmptyCursor EMPTY_CURSOR;
        public static final Companion Companion;

        public int getCount() {
            return 0;
        }

        public int getPosition() {
            return 0;
        }

        public boolean move(int i) {
            return false;
        }

        public boolean moveToPosition(int i) {
            return false;
        }

        public boolean moveToFirst() {
            return false;
        }

        public boolean moveToLast() {
            return false;
        }

        public boolean moveToNext() {
            return false;
        }

        public boolean moveToPrevious() {
            return false;
        }

        public boolean isFirst() {
            return false;
        }

        public boolean isLast() {
            return false;
        }

        public boolean isBeforeFirst() {
            return false;
        }

        public boolean isAfterLast() {
            return false;
        }

        public int getColumnIndex(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return 0;
        }

        public int getColumnIndexOrThrow(@NotNull String s) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            throw (Throwable)new IllegalArgumentException("EmptyCursor doesn't have any columns");
        }

        @Nullable
        public String getColumnName(int i) {
            return null;
        }

        @NotNull
        public String[] getColumnNames() {
            return new String[0];
        }

        public int getColumnCount() {
            return 0;
        }

        @NotNull
        public byte[] getBlob(int i) {
            return new byte[0];
        }

        @Nullable
        public String getString(int i) {
            return null;
        }

        public void copyStringToBuffer(int i, @NotNull CharArrayBuffer charArrayBuffer) {
            Intrinsics.checkNotNullParameter((Object)charArrayBuffer, (String)"charArrayBuffer");
        }

        public short getShort(int i) {
            return 0;
        }

        public int getInt(int i) {
            return 0;
        }

        public long getLong(int i) {
            return 0L;
        }

        public float getFloat(int i) {
            return 0.0f;
        }

        public double getDouble(int i) {
            return 0.0;
        }

        public int getType(int i) {
            return 0;
        }

        public boolean isNull(int i) {
            return false;
        }

        public void deactivate() {
        }

        public boolean requery() {
            return false;
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }

        public void registerContentObserver(@NotNull ContentObserver contentObserver) {
            Intrinsics.checkNotNullParameter((Object)contentObserver, (String)"contentObserver");
        }

        public void unregisterContentObserver(@NotNull ContentObserver contentObserver) {
            Intrinsics.checkNotNullParameter((Object)contentObserver, (String)"contentObserver");
        }

        public void registerDataSetObserver(@NotNull DataSetObserver dataSetObserver) {
            Intrinsics.checkNotNullParameter((Object)dataSetObserver, (String)"dataSetObserver");
        }

        public void unregisterDataSetObserver(@NotNull DataSetObserver dataSetObserver) {
            Intrinsics.checkNotNullParameter((Object)dataSetObserver, (String)"dataSetObserver");
        }

        public void setNotificationUri(@NotNull ContentResolver contentResolver, @NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        }

        @Nullable
        public Uri getNotificationUri() {
            return null;
        }

        public boolean getWantsAllOnMoveCalls() {
            return false;
        }

        public void setExtras(@NotNull Bundle extras) {
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        }

        @Nullable
        public Bundle getExtras() {
            return null;
        }

        @Nullable
        public Bundle respond(@NotNull Bundle bundle) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            return null;
        }

        private EmptyCursor() {
        }

        static {
            Companion = new Companion(null);
            EMPTY_CURSOR = new EmptyCursor();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/util/CursorUtil$EmptyCursor$Companion;", "", "()V", "EMPTY_CURSOR", "Lio/scanbot/sdk/util/CursorUtil$EmptyCursor;", "getEMPTY_CURSOR", "()Lio/scanbot/sdk/util/CursorUtil$EmptyCursor;", "sdk-base_release"})
        public static final class Companion {
            @NotNull
            public final EmptyCursor getEMPTY_CURSOR() {
                return EMPTY_CURSOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

