/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import io.scanbot.sdk.util.CursorUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/util/FileChooserUtils;", "", "()V", "CONTENT_SCHEME", "", "DOWNLOADS_AUTHORITY", "EXTERNALSTORAGE_AUTHORITY", "FILE_SCHEME", "MEDIA_AUTHORITY", "PUBLIC_DOWNLOADS_LINK", "getDataColumn", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "sdk-base_release"})
public final class FileChooserUtils {
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SCHEME = "file";
    private static final String EXTERNALSTORAGE_AUTHORITY = "com.android.externalstorage.documents";
    private static final String DOWNLOADS_AUTHORITY = "com.android.providers.downloads.documents";
    private static final String MEDIA_AUTHORITY = "com.android.providers.media.documents";
    private static final String PUBLIC_DOWNLOADS_LINK = "content://downloads/public_downloads";
    public static final FileChooserUtils INSTANCE;

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final String getPath(@Nullable Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileChooserUtils.isExternalStorageDocument(uri)) {
                String docId;
                String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (FileChooserUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = Uri.parse((String)PUBLIC_DOWNLOADS_LINK);
                    Long l = Long.valueOf(id2);
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                    Uri contentUri = ContentUris.withAppendedId((Uri)uri2, (long)l);
                    return FileChooserUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileChooserUtils.isMediaDocument(uri)) {
                    String docId;
                    String string = docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    String type = split[0];
                    Uri contentUri = null;
                    if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileChooserUtils.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)CONTENT_SCHEME, (String)uri.getScheme(), (boolean)true)) {
                return FileChooserUtils.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)FILE_SCHEME, (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String getDataColumn(@Nullable Context context, @Nullable Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Cursor cursor;
        String[] projection = new String[]{"_data"};
        if (context == null) {
            Object object = uri;
            if (object == null || (object = object.getPath()) == null) {
                object = "";
            }
            return object;
        }
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            Object object = uri;
            if (object == null || (object = object.getPath()) == null) {
                object = "";
            }
            return object;
        }
        ContentResolver resolver = contentResolver;
        Cursor cursor2 = cursor = resolver.query(uri, projection, selection, selectionArgs, null);
        if (cursor2 != null) {
            Cursor cursor3 = cursor2;
            boolean bl = false;
            boolean bl2 = false;
            Cursor it = cursor3;
            boolean bl3 = false;
            int columnIndex = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String path = cursor.getString(columnIndex);
            CursorUtil.closeQuietly(cursor);
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            return string;
        }
        Object object = uri;
        if (object == null || (object = object.getPath()) == null) {
            object = "";
        }
        return object;
    }

    @JvmStatic
    public static final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)EXTERNALSTORAGE_AUTHORITY, (Object)uri.getAuthority());
    }

    @JvmStatic
    public static final boolean isDownloadsDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)DOWNLOADS_AUTHORITY, (Object)uri.getAuthority());
    }

    @JvmStatic
    public static final boolean isMediaDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)MEDIA_AUTHORITY, (Object)uri.getAuthority());
    }

    private FileChooserUtils() {
    }

    static {
        FileChooserUtils fileChooserUtils;
        INSTANCE = fileChooserUtils = new FileChooserUtils();
    }
}

