/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import net.doo.snap.connectivity.BlobsStorage;
import net.doo.snap.entity.Blob;
import net.doo.snap.persistence.BlobStoreStrategy;
import org.jetbrains.annotations.NotNull;

public class BlobFactory {
    private static final String PDF_FONT = "pdf.ttf";
    private static final String BANKS_DATA_FILENAME = "banks.csv";
    private static final String MRZ_TRAINEDDATA_FILENAME = "ocrb.traineddata";
    private static final String MRZ_CASCADE_FILENAME = "mrz.xml";
    private static final String BARCODE_SCANNER_MODEL_FILENAME = "barcode_detector.tflite";
    private static final String BLUR_ESTIMATOR_MODEL_FILENAME = "blur_estimator_model.tflite";
    private static final String FILTER_PREDICTION_MODEL_FILENAME = "FilterPrediction.tflite";
    private static final String CHEQUE_DIGIT_RECOGNITION_MODEL_FILENAME = "ChequeDigitRecognizerModel.tflite";
    private static final String DC_FORM_MODELS_FOLDER = "dc_forms_models";
    private static final String DOC_DETECTOR_MODELS_FOLDER = "docdetector_models";
    private final BlobStoreStrategy blobStoreStrategy;
    private final BlobsStorage blobsStorage;
    private final AssetManager assetManager;

    public BlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.blobsStorage = blobsStorage;
        this.assetManager = assetManager;
    }

    @NotNull
    public Collection<Blob> ocrLanguageBlobs() throws IOException {
        HashSet<Blob> blobs = new HashSet<Blob>();
        File ocrDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        String ocrBlobsStoragePath = this.blobsStorage.ocrBlobsPath().toString();
        String[] languagesBlobs = this.assetManager.list(ocrBlobsStoragePath);
        if (languagesBlobs != null) {
            for (String ocrFilePath : languagesBlobs) {
                File ocrFile = new File(ocrBlobsStoragePath, ocrFilePath);
                blobs.add(new Blob(new File(ocrDirectory, ocrFile.getName()).getPath(), ocrFile.getPath()));
            }
        }
        Blob pdfBlob = new Blob(new File(ocrDirectory, PDF_FONT).getPath(), PDF_FONT);
        blobs.add(pdfBlob);
        return blobs;
    }

    @NotNull
    public Blob bankDataBlob() throws IOException {
        File bankDataFile = this.blobStoreStrategy.getBanksDataFile();
        return new Blob(bankDataFile.getPath(), BANKS_DATA_FILENAME);
    }

    @NotNull
    public Blob mrzTraineddataBlob() throws IOException {
        File mrzTraineddataFile = this.blobStoreStrategy.getMRZTraindataFile();
        return new Blob(mrzTraineddataFile.getPath(), MRZ_TRAINEDDATA_FILENAME);
    }

    @NotNull
    public Blob mrzCascadeBlob() throws IOException {
        File mrzCascadeFile = this.blobStoreStrategy.getMRZCascadeFile();
        return new Blob(mrzCascadeFile.getPath(), MRZ_CASCADE_FILENAME);
    }

    @NotNull
    public Blob chequeDigitRecognitionModelBlob() throws IOException {
        File chequeTraineddataFile = this.blobStoreStrategy.getChequeDigitRecognitionModelFile();
        return new Blob(chequeTraineddataFile.getPath(), CHEQUE_DIGIT_RECOGNITION_MODEL_FILENAME);
    }

    @NotNull
    public Blob barcodeScannerModelBlob() throws IOException {
        File barcodeScannerModelFile = this.blobStoreStrategy.getBarcodeScannerModelFile();
        return new Blob(barcodeScannerModelFile.getPath(), BARCODE_SCANNER_MODEL_FILENAME);
    }

    @NotNull
    public Blob prepareBlurEstimatorBlob() throws IOException {
        File blurEstimatorModelFile = this.blobStoreStrategy.getBlurEstimatorModelFile();
        return new Blob(blurEstimatorModelFile.getPath(), BLUR_ESTIMATOR_MODEL_FILENAME);
    }

    @NotNull
    public Blob filterPredictionModelBlob() throws IOException {
        File filterPredictionModelFile = this.blobStoreStrategy.getFilterPredictionModelFile();
        return new Blob(filterPredictionModelFile.getPath(), FILTER_PREDICTION_MODEL_FILENAME);
    }

    @NotNull
    public Collection<Blob> dcFormModelsBlobs() throws IOException {
        HashSet<Blob> blobs = new HashSet<Blob>();
        File dcDirectory = this.blobStoreStrategy.getDcFormModelsFile();
        String[] dcFormModels = this.assetManager.list(DC_FORM_MODELS_FOLDER);
        if (dcFormModels != null) {
            for (String model : dcFormModels) {
                File dcModelFile = new File(DC_FORM_MODELS_FOLDER, model);
                blobs.add(new Blob(new File(dcDirectory, dcModelFile.getName()).getPath(), dcModelFile.getPath()));
            }
        }
        return blobs;
    }

    @NotNull
    public Collection<Blob> docDetectorModelsBlobs() throws IOException {
        HashSet<Blob> blobs = new HashSet<Blob>();
        File docDetectorDirectory = this.blobStoreStrategy.getDocumentDetectorFile();
        String[] docDetectorFormModels = this.assetManager.list(DOC_DETECTOR_MODELS_FOLDER);
        if (docDetectorFormModels != null) {
            for (String model : docDetectorFormModels) {
                File docDetectorModelFile = new File(DOC_DETECTOR_MODELS_FOLDER, model);
                blobs.add(new Blob(new File(docDetectorDirectory, docDetectorModelFile.getName()).getPath(), docDetectorModelFile.getPath()));
            }
        }
        return blobs;
    }

    public boolean docDetectorModelsAvailable() {
        try {
            String[] list = this.assetManager.list(DOC_DETECTOR_MODELS_FOLDER);
            return list != null && list.length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }
}

