/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.scanbot.sdk.base.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.IFinderView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\rH\u0004J\b\u0010*\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020/H\u0016J0\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\rH\u0014J \u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\u0019H\u0016J\u000e\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020\rJ\u000e\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\rJ\b\u0010>\u001a\u00020(H\u0016J\u000e\u0010?\u001a\u00020(2\u0006\u0010$\u001a\u00020\rJ\u000e\u0010@\u001a\u00020(2\u0006\u0010%\u001a\u00020\rJ\u000e\u0010A\u001a\u00020(2\u0006\u0010&\u001a\u00020\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u001a\u0010!\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010\u0011R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lio/scanbot/sdk/ui/camera/BaseFinderOverlayView;", "Landroid/widget/FrameLayout;", "Lnet/doo/snap/camera/IFinderView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bitmap", "Landroid/graphics/Bitmap;", "cornerRadius", "", "fixedFinderHeightInPx", "", "getFixedFinderHeightInPx", "()I", "setFixedFinderHeightInPx", "(I)V", "fixedFinderWidthInPx", "getFixedFinderWidthInPx", "setFixedFinderWidthInPx", "initialPreviewHeight", "getInitialPreviewHeight", "setInitialPreviewHeight", "initialPreviewMode", "Lnet/doo/snap/camera/CameraPreviewMode;", "getInitialPreviewMode", "()Lnet/doo/snap/camera/CameraPreviewMode;", "setInitialPreviewMode", "(Lnet/doo/snap/camera/CameraPreviewMode;)V", "initialPreviewWidth", "getInitialPreviewWidth", "setInitialPreviewWidth", "minFinderPadding", "getMinFinderPadding", "setMinFinderPadding", "overlayColor", "strokeColor", "strokeWidth", "adjustDescriptionPosition", "", "paddingTopBottom", "createWindowFrame", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "isInEditMode", "", "onLayout", "changed", "l", "t", "r", "b", "setCameraParameters", "previewWidth", "previewHeight", "cameraPreviewMode", "setFixedFinderHeight", "fixedFinderHeight", "setFixedFinderWidth", "fixedFinderWidth", "setInitialFinderViewSize", "setOverlayColor", "setStrokeColor", "setStrokeWidth", "sdk-base_release"})
public class BaseFinderOverlayView
extends FrameLayout
implements IFinderView {
    private Bitmap bitmap;
    private int overlayColor;
    private int strokeColor;
    private float strokeWidth;
    private int fixedFinderWidthInPx;
    private int fixedFinderHeightInPx;
    private float cornerRadius;
    private int minFinderPadding;
    private int initialPreviewWidth;
    private int initialPreviewHeight;
    @NotNull
    private CameraPreviewMode initialPreviewMode;
    private HashMap _$_findViewCache;

    protected final int getFixedFinderWidthInPx() {
        return this.fixedFinderWidthInPx;
    }

    protected final void setFixedFinderWidthInPx(int n) {
        this.fixedFinderWidthInPx = n;
    }

    protected final int getFixedFinderHeightInPx() {
        return this.fixedFinderHeightInPx;
    }

    protected final void setFixedFinderHeightInPx(int n) {
        this.fixedFinderHeightInPx = n;
    }

    protected final int getMinFinderPadding() {
        return this.minFinderPadding;
    }

    protected final void setMinFinderPadding(int n) {
        this.minFinderPadding = n;
    }

    protected final int getInitialPreviewWidth() {
        return this.initialPreviewWidth;
    }

    protected final void setInitialPreviewWidth(int n) {
        this.initialPreviewWidth = n;
    }

    protected final int getInitialPreviewHeight() {
        return this.initialPreviewHeight;
    }

    protected final void setInitialPreviewHeight(int n) {
        this.initialPreviewHeight = n;
    }

    @NotNull
    protected final CameraPreviewMode getInitialPreviewMode() {
        return this.initialPreviewMode;
    }

    protected final void setInitialPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cameraPreviewMode), (String)"<set-?>");
        this.initialPreviewMode = cameraPreviewMode;
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        if (this.bitmap == null) {
            this.createWindowFrame();
        }
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    private final void createWindowFrame() {
        float strokeOffset = this.strokeWidth / (float)2;
        float finderOffsetLeft = strokeOffset + (float)this.getPaddingLeft();
        float finderOffsetRight = strokeOffset + (float)this.getPaddingRight();
        float finderOffsetTop = strokeOffset + (float)this.getPaddingTop();
        float finderOffsetBottom = strokeOffset + (float)this.getPaddingBottom();
        this.bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        RectF outerRectangle = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        Paint paint = new Paint(1);
        paint.setColor(this.overlayColor);
        canvas.drawRect(outerRectangle, paint);
        paint.setColor(0);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        canvas.drawRoundRect(new RectF(finderOffsetLeft, finderOffsetTop, (float)this.getWidth() - finderOffsetRight, (float)this.getHeight() - finderOffsetBottom), this.cornerRadius, this.cornerRadius, paint);
        paint = new Paint(1);
        paint.setColor(this.strokeColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(this.strokeWidth);
        canvas.drawRoundRect(new RectF(finderOffsetLeft, finderOffsetTop, (float)this.getWidth() - finderOffsetRight, (float)this.getHeight() - finderOffsetBottom), this.cornerRadius, this.cornerRadius, paint);
    }

    public boolean isInEditMode() {
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.bitmap = null;
    }

    public final void setOverlayColor(int overlayColor) {
        this.overlayColor = overlayColor;
        this.invalidate();
    }

    public final void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    public final void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public final void setFixedFinderWidth(int fixedFinderWidth) {
        this.fixedFinderWidthInPx = fixedFinderWidth;
        this.invalidate();
    }

    public final void setFixedFinderHeight(int fixedFinderHeight) {
        this.fixedFinderHeightInPx = fixedFinderHeight;
        this.invalidate();
    }

    @Override
    public void setCameraParameters(int previewWidth, int previewHeight, @NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cameraPreviewMode), (String)"cameraPreviewMode");
        this.initialPreviewWidth = previewWidth;
        this.initialPreviewHeight = previewHeight;
        this.initialPreviewMode = cameraPreviewMode;
        this.post(new Runnable(this){
            final /* synthetic */ BaseFinderOverlayView this$0;

            public final void run() {
                this.this$0.setInitialFinderViewSize();
            }
            {
                this.this$0 = baseFinderOverlayView;
            }
        });
    }

    public void setInitialFinderViewSize() {
        int paddingTopBottom = 0;
        int paddingLeftRight = 0;
        int scaledFrameWidth = 0;
        int scaledFrameHeight = 0;
        if (this.fixedFinderWidthInPx <= 0 || this.fixedFinderHeightInPx <= 0) {
            double finderAspectRatio;
            if (this.initialPreviewMode == CameraPreviewMode.FIT_IN) {
                double frameAspectRatio = this.initialPreviewWidth == 0 || this.initialPreviewHeight == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.initialPreviewWidth / (double)this.initialPreviewHeight;
                double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
                scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
            } else {
                scaledFrameWidth = this.getMeasuredWidth();
                scaledFrameHeight = this.getMeasuredHeight();
            }
            int finderWidth = scaledFrameWidth - 2 * this.minFinderPadding;
            int finderHeight = scaledFrameHeight - 2 * this.minFinderPadding;
            double targetAspectRatio = finderAspectRatio = (double)finderWidth / (double)finderHeight;
            if (targetAspectRatio < finderAspectRatio) {
                double targetWidth = (double)finderHeight * targetAspectRatio;
                paddingTopBottom = this.minFinderPadding + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = (int)(((double)scaledFrameWidth - targetWidth) / (double)2) + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            } else {
                double targetHeight = (double)finderWidth / targetAspectRatio;
                paddingTopBottom = (int)(((double)scaledFrameHeight - targetHeight) / (double)2) + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = this.minFinderPadding + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            }
        } else {
            paddingTopBottom = (this.getMeasuredHeight() - this.fixedFinderHeightInPx) / 2;
            paddingLeftRight = (this.getMeasuredWidth() - this.fixedFinderWidthInPx) / 2;
        }
        this.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        this.adjustDescriptionPosition(paddingTopBottom);
        this.invalidate();
    }

    protected final void adjustDescriptionPosition(int paddingTopBottom) {
        block2: {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            if (viewGroup == null || (viewGroup = viewGroup.findViewById(R.id.finder_description)) == null) break block2;
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
                layoutParams = null;
            }
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            int marginTop = marginLayoutParams != null ? marginLayoutParams.topMargin : 0;
            int marginBottom = paddingTopBottom - it.getMeasuredHeight() - marginTop;
            ViewGroup.LayoutParams layoutParams2 = it.getLayoutParams();
            if (layoutParams2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)layoutParams2;
            param.setMargins(param.leftMargin, param.topMargin, param.rightMargin, marginBottom);
            it.setLayoutParams((ViewGroup.LayoutParams)param);
            it.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFinderOverlayView(@Nullable Context context, @Nullable AttributeSet attr) {
        block4: {
            super(context, attr);
            this.overlayColor = -1;
            this.strokeColor = -1;
            this.strokeWidth = -1.0f;
            this.fixedFinderWidthInPx = -1;
            this.fixedFinderHeightInPx = -1;
            this.initialPreviewMode = CameraPreviewMode.FILL_IN;
            Context context2 = context;
            if (context2 == null) break block4;
            Context context3 = context2;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context3;
            boolean bl3 = false;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attr, R.styleable.FinderOverlayView, 0, 0);
            try {
                int n = typedArray.getColor(R.styleable.FinderOverlayView_overlay_color, -1);
                boolean bl4 = false;
                boolean bl5 = false;
                int it2 = n;
                boolean bl6 = false;
                this.overlayColor = it2 != -1 ? it2 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_color);
                n = typedArray.getColor(R.styleable.FinderOverlayView_overlay_stroke_color, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl7 = false;
                this.strokeColor = it2 != -1 ? it2 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_stroke_color);
                n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_stroke_width, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl8 = false;
                this.strokeWidth = it2 != -1 ? (float)it2 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_stroke_width);
                n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_corner_radius, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl9 = false;
                this.cornerRadius = it2 != -1 ? (float)it2 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_corner_radius);
                n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_min_padding, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl10 = false;
                this.minFinderPadding = it2 != -1 ? it2 : this.getResources().getDimensionPixelSize(R.dimen.default_min_finder_padding);
                n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_width, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl11 = false;
                this.fixedFinderWidthInPx = it2 != -1 ? it2 : this.fixedFinderWidthInPx;
                n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_height, -1);
                bl4 = false;
                bl5 = false;
                it2 = n;
                boolean bl12 = false;
                this.fixedFinderHeightInPx = it2 != -1 ? it2 : this.fixedFinderHeightInPx;
            }
            finally {
                typedArray.recycle();
            }
            LayoutTransition layoutTransition = new LayoutTransition();
            layoutTransition.enableTransitionType(4);
            this.setLayoutTransition(layoutTransition);
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

