/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.camera.CameraHost;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private CameraHost cameraHost;
    private boolean resumed = false;
    private State state = State.IDLE;
    private final Set<CameraStateCallback> stateCallbacks = new LinkedHashSet<CameraStateCallback>();
    private final Set<CameraTakePictureCallback> takePictureCallbacks = new LinkedHashSet<CameraTakePictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        if (!SapSingleton.getInstance().isLicenseActive()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        this.cameraView = new CameraView(context);
        this.cameraHost = new CameraHost(context);
        this.cameraView.setCameraHost((com.commonsware.cwac.camera.CameraHost)this.cameraHost);
        this.cameraView.setAutofocusCallback(new AutofocusCallbackImpl());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.addView((View)this.cameraView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.logger.logMethod();
        super.onLayout(changed, left, top, right, bottom);
        View cameraSurface = this.cameraView.getChildAt(0);
        if (cameraSurface == null) {
            return;
        }
        int childCount = this.getChildCount();
        int surfaceWidthSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getWidth(), (int)Integer.MIN_VALUE);
        int surfaceHeightSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getHeight(), (int)Integer.MIN_VALUE);
        for (int i = 1; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view instanceof CameraView) continue;
            view.measure(surfaceWidthSpec, surfaceHeightSpec);
            view.layout(cameraSurface.getLeft(), cameraSurface.getTop(), cameraSurface.getRight(), cameraSurface.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.getPreviewBuffer();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = SapSingleton.getInstance().isLicenseActive();
        this.state = State.IDLE;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = State.IDLE;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onResume();
        }
    }

    private void notifyPausedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onPause();
        }
    }

    private void notifyTakePictureCancelled() {
        for (CameraTakePictureCallback callback : this.takePictureCallbacks) {
            callback.onTakePictureCancelled();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean aquireFocus) {
        this.logger.logMethod();
        if (this.state != State.IDLE) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (aquireFocus) {
            this.state = State.PENDING_SHOOT;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    private void performSnapping() {
        this.state = State.SHOOTING;
        try {
            Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((com.commonsware.cwac.camera.CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (cameraParameters != null) {
                pictureTransaction = pictureTransaction.flashMode(cameraParameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
        }
        catch (IllegalStateException e) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
        }
    }

    public void useFlash(boolean useFlash) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            this.cameraView.setFlashMode(useFlash ? "torch" : "off");
        }
    }

    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.cameraView.setAutoFocusOnTouch(autoFocusOnTouch);
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.continuousFocus();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.addPictureCallback(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.removePictureCallback(pictureCallback);
    }

    public void addCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback);
    }

    public void removeCameraStateCallback(CameraStateCallback cameraStateCallback) {
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback);
    }

    public void addTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    public void removeTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.setCameraOpenCallback(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            return cameraParameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            return cameraParameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size pictureSize) {
        this.logger.logMethod();
        this.cameraHost.setDefaultPictureSize(pictureSize);
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            cameraParameters.setPictureSize(pictureSize.width, pictureSize.height);
            this.cameraView.setCameraParameters(cameraParameters);
        }
    }

    public void setPreviewSize(Camera.Size previewSize) {
        this.logger.logMethod();
        this.cameraHost.setDefaultPreviewSize(previewSize);
        Camera.Parameters cameraParameters = this.cameraView.getCameraParameters();
        if (cameraParameters != null) {
            cameraParameters.setPreviewSize(previewSize.width, previewSize.height);
            this.cameraView.setCameraParameters(cameraParameters);
        }
    }

    public void setAutoFocusSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.setAutoFocusSound(enabled);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        this.cameraHost.setShutterSound(enabled);
        this.cameraView.setShutterSound(enabled);
    }

    public void setPreviewMode(CameraPreviewMode mode) {
        this.logger.logMethod();
        this.cameraHost.setPreviewMode(mode);
    }

    @Deprecated
    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    public void lockToPortrait(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToPortrait(lockPicture);
    }

    public void lockToLandscape(boolean lockPicture) {
        this.logger.logMethod();
        this.cameraView.lockToLandscape(lockPicture);
    }

    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    private static enum State {
        IDLE,
        PENDING_SHOOT,
        SHOOTING;

    }

    private class AutofocusCallbackImpl
    implements CameraView.AutofocusCallback {
        private AutofocusCallbackImpl() {
        }

        @Override
        public void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            ScanbotCameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScanbotCameraView.this.state == State.PENDING_SHOOT) {
                        ScanbotCameraView.this.performSnapping();
                    } else {
                        ScanbotCameraView.this.state = State.IDLE;
                        ScanbotCameraView.this.notifyTakePictureCancelled();
                    }
                }
            }, 500L);
        }
    }
}

