/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.security;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.preference.PreferenceManager;
import io.scanbot.sap.SapManager;

public class SapSingleton {
    private static SapManager instance;

    public static synchronized SapManager getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        return instance;
    }

    public static synchronized void initializeSapManager(Context context) {
        instance = SapSingleton.initialize(context.getApplicationContext());
    }

    private static SapManager initialize(Context context) {
        String licenseStr = null;
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SapManager sapManager = new SapManager();
        if (preferences.contains("SCANBOT_SDK_LICENSE_KEY")) {
            licenseStr = preferences.getString("SCANBOT_SDK_LICENSE_KEY", "");
        } else {
            Bundle metaData = null;
            try {
                metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (metaData != null && metaData.containsKey("SCANBOT_SDK_LICENSE_KEY")) {
                licenseStr = metaData.getString("SCANBOT_SDK_LICENSE_KEY");
            }
        }
        sapManager.install(context, licenseStr);
        return sapManager;
    }
}

