/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BlobManager {
    private final BlobStoreStrategy blobStoreStrategy;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;
    private final Logger logger = LoggerProvider.getLogger();

    public BlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
    }

    public boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) {
        for (Blob blob : blobs) {
            if (this.isBlobAvailable(blob)) continue;
            return false;
        }
        return true;
    }

    public boolean isBlobAvailable(@NotNull Blob blob) {
        File file = new File(blob.getLocalPath());
        return file.exists();
    }

    @NotNull
    public Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        EnumSet<Language> languageSet = EnumSet.noneOf(Language.class);
        File ocrDataDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        File[] files = ocrDataDirectory.listFiles();
        if (files == null) {
            return languageSet;
        }
        for (File file : files) {
            String filename;
            String isoCode;
            Language language;
            if (file.isDirectory() || (language = Language.languageByIso(isoCode = FilenameUtils.removeExtension((String)(filename = file.getName())))) == null || !this.allBlobsAvailable(this.blobFactory.ocrLanguageBlobs())) continue;
            languageSet.add(language);
        }
        return languageSet;
    }

    @NotNull
    public File getOCRBlobsDirectory() throws IOException {
        File ocrDataDirectory = this.blobStoreStrategy.getOCRDataDirectory();
        if (!ocrDataDirectory.exists() && !ocrDataDirectory.mkdirs()) {
            throw new IOException("Can't get OCR blobs directory");
        }
        return ocrDataDirectory;
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        File banksDataFile = this.blobStoreStrategy.getBanksDataFile();
        if (!banksDataFile.exists()) {
            throw new IOException("Can't get banks data file");
        }
        return banksDataFile;
    }

    @NotNull
    public File getBarcodeScannerModelFile() throws IOException {
        File barcodeScannerModelFile = this.blobStoreStrategy.getBarcodeScannerModelFile();
        if (!barcodeScannerModelFile.exists()) {
            throw new IOException("Can't get Barcode scanner model file");
        }
        return barcodeScannerModelFile;
    }

    @NotNull
    public File getMRZTraineddataFile() throws IOException {
        File mrzRecognizerTraindataFile = this.blobStoreStrategy.getMRZTraindataFile();
        if (!mrzRecognizerTraindataFile.exists()) {
            throw new IOException("Can't get MRZ traineddata file");
        }
        return mrzRecognizerTraindataFile;
    }

    @NotNull
    public File getMRZCascadeFile() throws IOException {
        File mrzCascadeFile = this.blobStoreStrategy.getMRZCascadeFile();
        if (!mrzCascadeFile.exists()) {
            throw new IOException("Can't get MRZ cascade file");
        }
        return mrzCascadeFile;
    }

    @NotNull
    public File getFilterPredictionModelFile() throws IOException {
        File filterPredictionModelFile = this.blobStoreStrategy.getFilterPredictionModelFile();
        if (!filterPredictionModelFile.exists()) {
            throw new IOException("Can't get Filter prediction TensorFlow model file");
        }
        return filterPredictionModelFile;
    }

    @NotNull
    public File getChequeDigitPredictionModelFile() throws IOException {
        File chequePredictionModelFile = this.blobStoreStrategy.getChequeDigitRecognitionModelFile();
        if (!chequePredictionModelFile.exists()) {
            throw new IOException("Can't get Cheque digit prediction TensorFlow model file");
        }
        return chequePredictionModelFile;
    }

    @NotNull
    public File getDcModelsFolderFile() throws IOException {
        File dcFormModelsFile = this.blobStoreStrategy.getDcFormModelsFile();
        if (!dcFormModelsFile.exists()) {
            throw new IOException("Can't get DC TensorFlow models folder");
        }
        return dcFormModelsFile;
    }

    @NotNull
    public File getDocumentDetectorModelsFolderFile() throws IOException {
        return this.blobStoreStrategy.getDocumentDetectorFile();
    }

    public long fetch(@NotNull Blob blob) throws IOException {
        if (this.isBlobAvailable(blob)) {
            return -1L;
        }
        this.ensureDirectoryCreated(blob);
        Uri blobUri = Uri.parse((String)blob.getRemotePath());
        return this.copyFromAssets(blob, blobUri);
    }

    private long copyFromAssets(Blob blob, Uri blobUri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(blobUri.getPath()), (File)new File(blob.getLocalPath()));
        return -1L;
    }

    private void ensureDirectoryCreated(Blob blob) throws IOException {
        File dir = new File(blob.getLocalPath()).getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }
}

