/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import java.io.File;
import java.io.IOException;
import net.doo.snap.entity.Blob;
import net.doo.snap.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BlobStoreStrategy {
    public static final String TRAINEDDATA_EXTENSION = ".traineddata";
    public static final String BIN_EXTENSION = ".bin";
    public static final String BINARIES_DIR_NAME = "binaries";
    private final Application application;
    private final SharedPreferences preferences;

    public BlobStoreStrategy(Application application, SharedPreferences preferences) {
        this.application = application;
        this.preferences = preferences;
    }

    @NotNull
    public File getBinariesDirectory() throws IOException {
        String dirPath = this.preferences.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!dirPath.isEmpty()) {
            return FileUtils.getFilesDirOrShowError(dirPath, BINARIES_DIR_NAME);
        }
        return FileUtils.getFilesDirOrShowError(FileUtils.getAppFilesDirOrShowError((Context)this.application, "scanbot-sdk").getPath(), BINARIES_DIR_NAME);
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"banks.csv"});
    }

    @NotNull
    public File getMRZTraindataFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getOCRDataDirectory(), (String[])new String[]{"ocrb.traineddata"});
    }

    @NotNull
    public File getMRZCascadeFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"mrz.xml"});
    }

    @NotNull
    public File getOCRDataDirectory() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"tessdata"});
    }

    @NotNull
    public File getBlobFile(Blob blob) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{blob.getLocalPath()});
    }

    @NotNull
    public File getChequeDigitRecognitionModelFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"ChequeDigitRecognizerModel.tflite"});
    }

    @NotNull
    public File getDcFormModelsFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"dc_forms_models"});
    }

    @NotNull
    public File getDocumentDetectorFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"docdetector_models"});
    }

    @NotNull
    public File getRoutingNumberCascadeFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"routing.xml"});
    }

    @NotNull
    public File getAccountNumberCascadeFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"account.xml"});
    }

    @NotNull
    public File getBarcodeScannerModelFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"barcode_detector.tflite"});
    }

    @NotNull
    public File getFilterPredictionModelFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"FilterPrediction.tflite"});
    }
}

