/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.PictureCallback;

class CameraHost
extends SimpleCameraHost {
    private final Set<PictureCallback> pictureCallbacks = new LinkedHashSet<PictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();
    private Camera.Size defaultPictureSize;
    private Camera.Size defaultPreviewSize;
    private boolean autoFocusSoundEnabled = true;
    private boolean shutterSoundEnabled = true;
    private CameraPreviewMode previewMode = CameraPreviewMode.FILL_IN;
    private Context context;

    public CameraHost(Context context) {
        super(context);
        this.context = context;
    }

    public Camera.Parameters adjustPreviewParameters(Camera.Parameters parameters) {
        this.logger.logMethod();
        super.adjustPreviewParameters(parameters);
        parameters.setPreviewFormat(17);
        return parameters;
    }

    public final Camera.Size getPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        this.logger.logMethod();
        if (this.defaultPreviewSize == null) {
            return this.findPreviewSize(displayOrientation, width, height, parameters);
        }
        return this.defaultPreviewSize;
    }

    public Camera.ShutterCallback getShutterCallback() {
        Camera.ShutterCallback shutterCallback = new Camera.ShutterCallback(){

            public void onShutter() {
            }
        };
        return this.shutterSoundEnabled ? shutterCallback : null;
    }

    protected Camera.Size findPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        this.logger.logMethod();
        Camera.Size pictureSize = Utils.getLargestPictureSize(parameters);
        return Utils.getLargestSizeWithAspectRatioMatch(parameters.getSupportedPreviewSizes(), (double)pictureSize.width / (double)pictureSize.height);
    }

    public Camera.Size getPictureSize(PictureTransaction xact, Camera.Parameters parameters) {
        this.logger.logMethod();
        if (this.defaultPictureSize == null) {
            return Utils.getLargestPictureSize(parameters);
        }
        return this.defaultPictureSize;
    }

    public boolean useFullBleedPreview() {
        switch (this.previewMode) {
            case FIT_IN: {
                return false;
            }
        }
        return true;
    }

    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(PictureTransaction xact, byte[] image, int imageOrientation) {
        this.logger.logMethod();
        Set<PictureCallback> set = this.pictureCallbacks;
        synchronized (set) {
            for (PictureCallback callback : this.pictureCallbacks) {
                callback.onPictureTaken(image, imageOrientation);
            }
        }
    }

    public void onAutoFocus(boolean success, Camera camera) {
        if (this.autoFocusSoundEnabled) {
            super.onAutoFocus(success, camera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        if (pictureCallback == null) {
            throw new NullPointerException();
        }
        Set<PictureCallback> set = this.pictureCallbacks;
        synchronized (set) {
            this.pictureCallbacks.add(pictureCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        Set<PictureCallback> set = this.pictureCallbacks;
        synchronized (set) {
            this.pictureCallbacks.remove(pictureCallback);
        }
    }

    public void setDefaultPictureSize(Camera.Size defaultPictureSize) {
        this.defaultPictureSize = defaultPictureSize;
    }

    public void setDefaultPreviewSize(Camera.Size defaultPreviewSize) {
        this.defaultPreviewSize = defaultPreviewSize;
    }

    public void setAutoFocusSound(boolean autoFocusSoundEnabled) {
        this.autoFocusSoundEnabled = autoFocusSoundEnabled;
    }

    public void setShutterSound(boolean shutterSoundEnabled) {
        this.shutterSoundEnabled = shutterSoundEnabled;
    }

    public void setPreviewMode(CameraPreviewMode mode) {
        this.previewMode = mode;
    }

    public CameraPreviewMode getPreviewMode() {
        return this.previewMode;
    }
}

