/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ImageFormat;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.DeviceProfile;
import com.commonsware.cwac.camera.PictureTransaction;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.doo.snap.camera.CameraHost;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.IFinderView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import org.jetbrains.annotations.NotNull;

class CameraView
extends com.commonsware.cwac.camera.CameraView {
    private static final int AUTO_FOCUS_TIMEOUT_MS = 5000;
    private static final int DELAY_REFOCUSING_NEEDED_MS = 3000;
    private static final int DELAY_HIDE_TOUCH_FOCUS_MS = 1000;
    private static final int DELAY_ENABLE_CONTINUOUS_FOCUS_MS = 1000;
    private static final int DELAY_CAMERA_BUFFER_INIT_MS = 1000;
    private static final int DEFAULT_FOCUS_AREA_SIZE = 75;
    private static final int AREA_WEIGHT = 1000;
    private static final int MIN_AREA_COORD = -1000;
    private static final int MAX_AREA_COORD = 1000;
    private static final String SAMSUNG_SCENE_MODE_TEXT = "text";
    private static final int MAX_FRAMES_IN_PROCESSING = 2;
    private Camera camera;
    private final Handler autoFocusHandler = new Handler();
    private final Runnable cancelAutoFocusAndStartContinuousRunnable = new Runnable(){

        @Override
        public void run() {
            CameraView.this.continuousFocus();
        }
    };
    private long lastFocusedTime = 0L;
    private List<PointF> polygon = Collections.emptyList();
    private boolean autoFocusOnTouch = true;
    private boolean isAutoFocusing = false;
    private boolean cameraAvailable = false;
    private final Paint touchFocusPaint;
    private Rect touchRect;
    private final PreviewBufferImpl previewBuffer = new PreviewBufferImpl();
    private final Logger logger = LoggerProvider.getLogger();
    private AutofocusCallback autofocusCallback = AutofocusCallback.NULL;
    private CameraOpenCallback cameraOpenCallback = CameraOpenCallback.NULL;
    private int finderInnerThresholdPx;
    private int finderOuterThresholdPx;

    public CameraView(Context context) {
        super(context);
        this.touchFocusPaint = new Paint();
        this.touchFocusPaint.setColor(this.getResources().getColor(17170443));
        this.touchFocusPaint.setStyle(Paint.Style.STROKE);
        this.touchFocusPaint.setStrokeWidth(this.getResources().getDimension(R.dimen.touch_focus_polygon_width));
        this.touchFocusPaint.setAntiAlias(true);
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    public void onCameraOpen(Camera camera) throws RuntimeException {
        this.logger.logMethod();
        super.onCameraOpen(camera);
        this.camera = camera;
        this.cameraOpenCallback.onCameraOpened();
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (System.currentTimeMillis() - this.lastFocusedTime < 3000L || !this.isAutoFocusAvailable()) {
            this.autofocusCallback.onAutoFocusCompleted();
            return;
        }
        this.autoFocusHandler.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
        this.autoFocusHandler.postDelayed(this.cancelAutoFocusAndStartContinuousRunnable, 5000L);
        this.isAutoFocusing = true;
        try {
            Camera.Parameters params = this.getCameraParameters();
            Utils.enableAutoFocus(params);
            this.applyFocusAndMeteringArea(params);
            this.setCameraParameters(params);
            super.autoFocus();
        }
        catch (RuntimeException e) {
            this.logger.logException(e);
        }
    }

    public void cancelAutoFocus() {
        this.logger.logMethod();
        super.cancelAutoFocus();
        this.updateTouchRect(false);
        this.isAutoFocusing = false;
        this.autoFocusHandler.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
    }

    public boolean isAutoFocusAvailable() {
        this.logger.logMethod();
        return super.isAutoFocusAvailable() && !this.isAutoFocusing;
    }

    public void setAutofocusCallback(AutofocusCallback autofocusCallback) {
        this.logger.logMethod();
        this.autofocusCallback = autofocusCallback != null ? autofocusCallback : AutofocusCallback.NULL;
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraOpenCallback = cameraOpenCallback != null ? cameraOpenCallback : CameraOpenCallback.NULL;
    }

    private void applyFocusAndMeteringArea(Camera.Parameters parameters) {
        List<Camera.Area> areas;
        if (parameters.getMaxNumFocusAreas() > 0) {
            areas = this.getAreas();
            parameters.setFocusAreas(areas);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            areas = this.getAreas();
            parameters.setMeteringAreas(areas);
        }
    }

    private List<Camera.Area> getAreas() {
        Rect areaRect;
        if (this.touchRect != null) {
            areaRect = new Rect(this.polygonCoordToAreaCoord((float)this.touchRect.left / (float)this.getWidth()), this.polygonCoordToAreaCoord((float)this.touchRect.top / (float)this.getHeight()), this.polygonCoordToAreaCoord((float)this.touchRect.right / (float)this.getWidth()), this.polygonCoordToAreaCoord((float)this.touchRect.bottom / (float)this.getHeight()));
        } else if (!this.polygon.isEmpty()) {
            float minX = 1.0f;
            float maxX = 0.0f;
            float minY = 1.0f;
            float maxY = 0.0f;
            for (PointF point : this.polygon) {
                if (point.x < minX) {
                    minX = point.x;
                }
                if (point.x > maxX) {
                    maxX = point.x;
                }
                if (point.y < minY) {
                    minY = point.y;
                }
                if (!(point.y > maxY)) continue;
                maxY = point.y;
            }
            float left = (maxX - minX) / 2.0f - 0.075f;
            float right = (maxX - minX) / 2.0f + 0.075f;
            float top = minY;
            float bottom = maxY;
            areaRect = new Rect(this.polygonCoordToAreaCoord(left), this.polygonCoordToAreaCoord(top), this.polygonCoordToAreaCoord(right), this.polygonCoordToAreaCoord(bottom));
        } else {
            areaRect = new Rect(-75, -75, 75, 75);
        }
        Camera.Area area = new Camera.Area(areaRect, 1000);
        ArrayList<Camera.Area> areas = new ArrayList<Camera.Area>();
        areas.add(area);
        return areas;
    }

    private int polygonCoordToAreaCoord(float coordinate) {
        int result = Math.round(coordinate * 1000.0f * 2.0f + -1000.0f);
        if (result > 1000) {
            result = 1000;
        }
        if (result < -1000) {
            result = -1000;
        }
        return result;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.logger.logMethod();
        if (this.isAutoFocusing) {
            this.updateTouchRect(success);
            this.autoFocusHandler.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
            this.isAutoFocusing = false;
            super.onAutoFocus(success, camera);
        }
        this.lastFocusedTime = success ? System.currentTimeMillis() : 0L;
        this.autofocusCallback.onAutoFocusCompleted();
    }

    private void updateTouchRect(boolean success) {
        if (this.touchRect != null) {
            if (this.touchFocusPaint.getColor() != -1) {
                this.touchFocusPaint.setAlpha(0);
                this.invalidate();
                return;
            }
            this.touchFocusPaint.setColor(this.getResources().getColor(success ? 17170452 : 0x1060016));
            this.invalidate();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CameraView.this.touchFocusPaint.getColor() != -1) {
                        CameraView.this.touchFocusPaint.setAlpha(0);
                        CameraView.this.invalidate();
                    }
                }
            }, 1000L);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0 && this.isAutoFocusAvailable() && this.autoFocusOnTouch) {
            this.autoFocusOnTouch(event);
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void autoFocusOnTouch(MotionEvent event) {
        this.touchFocusPaint.setColor(this.getResources().getColor(17170443));
        float x = event.getX();
        float y = event.getY();
        this.touchRect = new Rect((int)(x - 75.0f), (int)(y - 75.0f), (int)(x + 75.0f), (int)(y + 75.0f));
        this.invalidate();
        this.autoFocus();
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.touchRect != null) {
            canvas.drawRect(this.touchRect, this.touchFocusPaint);
        }
    }

    public void onResume() {
        this.logger.logMethod();
        super.onResume();
        this.cameraAvailable = true;
    }

    public void onPause() {
        this.logger.logMethod();
        this.removeCallbacks(this.cancelAutoFocusAndStartContinuousRunnable);
        super.onPause();
        this.cameraAvailable = false;
        this.previewBuffer.deleteFrame();
    }

    public void startPreview() {
        Camera.Parameters parameters;
        this.logger.logMethod();
        if (this.cameraAvailable && (parameters = this.getCameraParameters()) != null) {
            super.startPreview();
        }
    }

    protected void startPreviewSync() {
        this.logger.logMethod();
        if (this.cameraAvailable) {
            this.polygon = Collections.emptyList();
            this.touchRect = null;
            this.isAutoFocusing = false;
            Camera.Parameters parameters = this.getCameraParameters();
            if (parameters != null) {
                this.applyAdvancedParameter(parameters);
                this.applyFocusAndMeteringArea(parameters);
                this.setCameraParametersSync(parameters);
                Camera.Size previewSize = this.getPreviewSize();
                if (previewSize != null) {
                    this.previewBuffer.allocateFrame(previewSize.width, previewSize.height);
                    this.adjustFinderView(previewSize);
                }
                super.startPreviewSync();
            }
            this.enableContinuousFocusWithDaley();
        }
    }

    private void enableContinuousFocusWithDaley() {
        this.postDelayed(this.cancelAutoFocusAndStartContinuousRunnable, 1000L);
    }

    public void takePicture(PictureTransaction xact) {
        this.logger.logMethod();
        super.takePicture(xact);
    }

    private void applyAdvancedParameter(@NotNull Camera.Parameters parameters) {
        List sceneModes;
        Camera.Size pictureSize = this.getCameraHost().getPictureSize(null, parameters);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        parameters.setPictureFormat(256);
        if (!this.getCameraHost().getDeviceProfile().isCustomRom()) {
            parameters.setJpegQuality(100);
        }
        if ((sceneModes = parameters.getSupportedSceneModes()) != null && sceneModes.contains(SAMSUNG_SCENE_MODE_TEXT)) {
            parameters.setSceneMode(SAMSUNG_SCENE_MODE_TEXT);
        }
    }

    private void adjustFinderView(Camera.Size previewSize) {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            int previewHeight;
            int previewWidth;
            ViewParent parent = this.getParent().getParent();
            if (!(parent instanceof ViewGroup)) {
                return;
            }
            View finderOverlay = ((ViewGroup)parent).findViewById(R.id.finder_overlay);
            if (finderOverlay == null) {
                return;
            }
            int displayOrientation = this.getDisplayOrientation();
            if (displayOrientation == 0 || displayOrientation == 180) {
                previewWidth = previewSize.width < previewSize.height ? previewSize.height : previewSize.width;
                previewHeight = previewSize.width < previewSize.height ? previewSize.width : previewSize.height;
            } else {
                previewWidth = previewSize.width > previewSize.height ? previewSize.height : previewSize.width;
                int n = previewHeight = previewSize.width > previewSize.height ? previewSize.width : previewSize.height;
            }
            if (finderOverlay instanceof IFinderView) {
                CameraPreviewMode previewMode = ((CameraHost)this.getCameraHost()).getPreviewMode();
                ((IFinderView)finderOverlay).setCameraParameters(previewWidth, previewHeight, previewMode);
            }
        }
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (this.cameraAvailable) {
            super.stopPreview();
        }
    }

    protected void onDetachedFromWindow() {
        this.logger.logMethod();
        super.onDetachedFromWindow();
        this.previewBuffer.dispose();
    }

    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.autoFocusOnTouch = autoFocusOnTouch;
    }

    public void continuousFocus() {
        this.logger.logMethod();
        this.cancelAutoFocus();
        try {
            Camera.Parameters params = this.getCameraParameters();
            Utils.enableContinuousFocus(params);
            this.setCameraParameters(params);
        }
        catch (RuntimeException e) {
            this.logger.logException(e);
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.previewBuffer;
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        ((CameraHost)this.getCameraHost()).addPictureCallback(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        ((CameraHost)this.getCameraHost()).removePictureCallback(pictureCallback);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        if (info.canDisableShutterSound && this.camera != null) {
            try {
                this.camera.enableShutterSound(enabled);
            }
            catch (RuntimeException exception) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Could not work with camera?", (Throwable)exception);
            }
        }
    }

    private RectF calculateVisibleRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            ViewParent parent = this.getParent().getParent();
            if (!(parent instanceof ViewGroup)) {
                return null;
            }
            int parentWidth = ((View)parent).getMeasuredWidth();
            int parentHeight = ((View)parent).getMeasuredHeight();
            double heightScale = (double)parentHeight / (double)previewHeight;
            double widthScale = (double)parentWidth / (double)previewWidth;
            if (previewMode == CameraPreviewMode.FILL_IN) {
                int scaledPreviewHeight;
                int scaledPreviewWidth;
                if (heightScale > widthScale) {
                    scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                    scaledPreviewHeight = parentHeight;
                } else {
                    scaledPreviewWidth = parentWidth;
                    scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                }
                int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
                int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
                float overlayTop = this.normalizeF((float)previewOffsetHeight / (float)scaledPreviewHeight);
                float overlayLeft = this.normalizeF((float)previewOffsetWidth / (float)scaledPreviewWidth);
                float overlayBottom = this.normalizeF((float)(scaledPreviewHeight - previewOffsetHeight) / (float)scaledPreviewHeight);
                float overlayRight = this.normalizeF((float)(scaledPreviewWidth - previewOffsetWidth) / (float)scaledPreviewWidth);
                return new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
            }
            return new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return null;
    }

    private RectF calculateFinderRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            int scaledPreviewHeight;
            int scaledPreviewWidth;
            ViewParent parent = this.getParent().getParent();
            if (!(parent instanceof ViewGroup)) {
                return null;
            }
            View finderOverlay = ((ViewGroup)parent).findViewById(R.id.finder_overlay);
            if (finderOverlay == null || finderOverlay.getVisibility() != 0) {
                return null;
            }
            int parentWidth = ((View)parent).getMeasuredWidth();
            int parentHeight = ((View)parent).getMeasuredHeight();
            Rect overlayRect = new Rect();
            finderOverlay.getDrawingRect(overlayRect);
            ((ViewGroup)parent).offsetDescendantRectToMyCoords(finderOverlay, overlayRect);
            overlayRect = new Rect(overlayRect.left + finderOverlay.getPaddingLeft(), overlayRect.top + finderOverlay.getPaddingTop(), overlayRect.right - finderOverlay.getPaddingRight(), overlayRect.bottom - finderOverlay.getPaddingBottom());
            double heightScale = (double)parentHeight / (double)previewHeight;
            double widthScale = (double)parentWidth / (double)previewWidth;
            if (previewMode == CameraPreviewMode.FILL_IN) {
                if (heightScale > widthScale) {
                    scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                    scaledPreviewHeight = parentHeight;
                } else {
                    scaledPreviewWidth = parentWidth;
                    scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                }
            } else if (heightScale > widthScale) {
                scaledPreviewWidth = parentWidth;
                scaledPreviewHeight = (int)((double)previewHeight * widthScale);
            } else {
                scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                scaledPreviewHeight = parentHeight;
            }
            int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
            int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
            float overlayTop = this.normalizeF((float)(previewOffsetHeight + overlayRect.top) / (float)scaledPreviewHeight);
            float overlayLeft = this.normalizeF((float)(previewOffsetWidth + overlayRect.left) / (float)scaledPreviewWidth);
            float overlayBottom = this.normalizeF((float)(previewOffsetHeight + overlayRect.bottom) / (float)scaledPreviewHeight);
            float overlayRight = this.normalizeF((float)(previewOffsetWidth + overlayRect.right) / (float)scaledPreviewWidth);
            return new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
        }
        return null;
    }

    private float normalizeF(float rectCoordinates) {
        if (rectCoordinates < 0.0f) {
            return 0.0f;
        }
        if (rectCoordinates > 1.0f) {
            return 1.0f;
        }
        return rectCoordinates;
    }

    private class PreviewBufferImpl
    implements PreviewBuffer,
    Camera.PreviewCallback {
        private final AtomicReference<byte[]> currentFrame = new AtomicReference();
        private int frameWidth = 0;
        private int frameHeight = 0;
        private final AtomicInteger framesInProcessing = new AtomicInteger(0);
        private final Set<PreviewBuffer.FrameHandler> frameHandlers = new LinkedHashSet<PreviewBuffer.FrameHandler>();
        private final ExecutorService frameDispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("FRAME_DISPATCHER");
                return thread;
            }
        });

        PreviewBufferImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFrameHandler(PreviewBuffer.FrameHandler frameHandler) {
            CameraView.this.logger.logMethod();
            Set<PreviewBuffer.FrameHandler> set = this.frameHandlers;
            synchronized (set) {
                this.frameHandlers.add(frameHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFrameHandler(PreviewBuffer.FrameHandler frameHandler) {
            CameraView.this.logger.logMethod();
            Set<PreviewBuffer.FrameHandler> set = this.frameHandlers;
            synchronized (set) {
                this.frameHandlers.remove(frameHandler);
            }
        }

        private synchronized void allocateFrame(final int frameWidth, final int frameHeight) {
            this.deleteFrame();
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            CameraView.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PreviewBufferImpl.this.isPreviewBufferSupported()) {
                        byte[] newPreviewBuffer = PreviewBufferImpl.this.allocateFrameBuffer(frameWidth, frameHeight);
                        if (PreviewBufferImpl.this.currentFrame.get() == null || newPreviewBuffer.length != ((byte[])PreviewBufferImpl.this.currentFrame.get()).length) {
                            PreviewBufferImpl.this.currentFrame.set(newPreviewBuffer);
                        }
                        CameraView.this.addPreviewCallbackBuffer((byte[])PreviewBufferImpl.this.currentFrame.get());
                    }
                }
            }, 1000L);
            CameraView.this.setPreviewCallback(this);
        }

        private boolean isPreviewBufferSupported() {
            return !DeviceProfile.getInstance((Context)CameraView.this.getContext()).isCustomRom();
        }

        private synchronized void deleteFrame() {
            CameraView.this.setPreviewCallback(null);
        }

        private byte[] allocateFrameBuffer(int frameWidth, int frameHeight) {
            return new byte[frameWidth * frameHeight * ImageFormat.getBitsPerPixel((int)17) / 8];
        }

        private void dispose() {
            this.frameDispatcher.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onPreviewFrame(byte[] frame, Camera camera) {
            if (this.isUnderBackpressure()) {
                CameraView.this.logger.e("Camera", "Frame rejected - too many frames in processing");
                return;
            }
            Set<PreviewBuffer.FrameHandler> set = this.frameHandlers;
            synchronized (set) {
                this.dispatchFrame(frame);
            }
        }

        private boolean isUnderBackpressure() {
            return this.framesInProcessing.get() >= 2;
        }

        private void dispatchFrame(final byte[] frame) {
            if (this.frameDispatcher.isShutdown()) {
                return;
            }
            this.frameDispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.logger.logMethod();
                    PreviewBufferImpl.this.framesInProcessing.incrementAndGet();
                }
            });
            final AtomicBoolean handled = new AtomicBoolean(false);
            final int frameWidthCopy = this.frameWidth;
            final int frameHeightCopy = this.frameHeight;
            final int displayOrientation = CameraView.this.getDisplayOrientation();
            Rect finderRect = null;
            RectF visibleRectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            Camera.Parameters cameraParameters = CameraView.this.getCameraParameters();
            if (cameraParameters != null) {
                int previewHeight;
                int previewWidth;
                Camera.Size previewSize = cameraParameters.getPreviewSize();
                if (displayOrientation == 0 || displayOrientation == 180) {
                    previewWidth = previewSize.width < previewSize.height ? previewSize.height : previewSize.width;
                    previewHeight = previewSize.width < previewSize.height ? previewSize.width : previewSize.height;
                } else {
                    previewWidth = previewSize.width > previewSize.height ? previewSize.height : previewSize.width;
                    previewHeight = previewSize.width > previewSize.height ? previewSize.width : previewSize.height;
                }
                CameraPreviewMode previewMode = ((CameraHost)CameraView.this.getCameraHost()).getPreviewMode();
                RectF overlayRectF = CameraView.this.calculateFinderRectF(previewWidth, previewHeight, previewMode);
                visibleRectF = CameraView.this.calculateVisibleRectF(previewWidth, previewHeight, previewMode);
                if (overlayRectF != null) {
                    finderRect = new Rect((int)((float)previewWidth * overlayRectF.left), (int)((float)previewHeight * overlayRectF.top), (int)((float)previewWidth * overlayRectF.right), (int)((float)previewHeight * overlayRectF.bottom));
                    if (finderRect.left < 0 || finderRect.left > previewWidth || finderRect.top < 0 || finderRect.top > previewHeight || finderRect.right < 0 || finderRect.right > previewWidth || finderRect.bottom < 0 || finderRect.bottom > previewHeight || finderRect.width() <= 0 || finderRect.height() <= 0) {
                        CameraView.this.logger.e("Camera", "Finder overlay layout does not fit to the Camera preview frame.");
                        this.returnFrameToCamera(frame, handled);
                        return;
                    }
                }
            }
            final Rect resultFinderRect = finderRect;
            final RectF resultVisibleRectF = visibleRectF;
            for (final PreviewBuffer.FrameHandler frameHandler : this.frameHandlers) {
                this.frameDispatcher.execute(new Runnable(){

                    @Override
                    public void run() {
                        CameraView.this.logger.logMethod();
                        if (handled.get()) {
                            return;
                        }
                        boolean result = frameHandler.handleFrame(new PreviewBuffer.FrameHandler.Frame(frame, frameWidthCopy, frameHeightCopy, displayOrientation, resultFinderRect, resultVisibleRectF, CameraView.this.finderInnerThresholdPx, CameraView.this.finderOuterThresholdPx));
                        handled.set(result);
                    }
                });
            }
            this.returnFrameToCamera(frame, handled);
        }

        private void returnFrameToCamera(final byte[] frame, final AtomicBoolean handled) {
            this.frameDispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.logger.logMethod();
                    PreviewBufferImpl.this.framesInProcessing.decrementAndGet();
                    if (handled.get()) {
                        return;
                    }
                    if (PreviewBufferImpl.this.currentFrame.get() == frame) {
                        CameraView.this.addPreviewCallbackBuffer(frame);
                    }
                }
            });
        }
    }

    public static interface AutofocusCallback {
        public static final AutofocusCallback NULL = new AutofocusCallback(){

            @Override
            public void onAutoFocusCompleted() {
            }
        };

        public void onAutoFocusCompleted();
    }
}

