/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/util/ImageUtil;", "", "()V", "convertNV21ToBitmap", "Landroid/graphics/Bitmap;", "nv21Image", "", "imageWidth", "", "imageHeight", "imageOrientation", "sdk-base_release"})
public final class ImageUtil {
    public static final ImageUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Intrinsics.checkParameterIsNotNull((Object)nv21Image, (String)"nv21Image");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = outputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)closeable;
            boolean bl2 = false;
            YuvImage yuvImage = new YuvImage(nv21Image, 17, imageWidth, imageHeight, null);
            yuvImage.compressToJpeg(new Rect(0, 0, imageWidth, imageHeight), 100, (OutputStream)os);
            byte[] previewByteArray = os.toByteArray();
            Bitmap resultBitmap = BitmapFactory.decodeByteArray((byte[])previewByteArray, (int)0, (int)previewByteArray.length);
            if (imageOrientation != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)imageOrientation);
                resultBitmap = Bitmap.createBitmap((Bitmap)resultBitmap, (int)0, (int)0, (int)imageWidth, (int)imageHeight, (Matrix)matrix, (boolean)false);
            }
            Bitmap bitmap = resultBitmap;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"resultBitmap");
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return ImageUtil.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    private ImageUtil() {
    }

    static {
        ImageUtil imageUtil;
        INSTANCE = imageUtil = new ImageUtil();
    }
}

