/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import io.scanbot.sdk.util.log.DebugLog$WhenMappings;
import io.scanbot.sdk.util.log.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001a\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001b\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010\u001b\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001dJ$\u0010\u001e\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\u001f\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010 \u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010!\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0017H\u0016J$\u0010#\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\u0010\u0010*\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\u001c\u0010*\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lio/scanbot/sdk/util/log/DebugLog;", "Lio/scanbot/sdk/util/log/Logger;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callerClassName", "", "getCallerClassName", "()Ljava/lang/String;", "callerMethodName", "getCallerMethodName", "logFilename", "getLogFilename", "logWriter", "Ljava/io/Writer;", "getLogWriter", "()Ljava/io/Writer;", "buildLogMessage", "tag", "message", "level", "Lio/scanbot/sdk/util/log/Logger$Level;", "closeSafely", "", "closeable", "Ljava/io/Closeable;", "d", "e", "where", "", "echoMessage", "i", "logException", "logMessage", "logMethod", "logToFile", "prepareLogsFolder", "externalStorage", "Ljava/io/File;", "printVersionInfo", "tokenizeClassName", "className", "w", "Companion", "sdk-base_release"})
public final class DebugLog
implements Logger {
    @NotNull
    public static final String LOG_DIRECTORY = "debug_logs";
    @NotNull
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT;
    private static final Pattern CLASS_NAME_PATTERN;
    private static boolean prepared;
    private static final boolean savingEnabled = true;
    private static final boolean echoEnabled = true;
    private static final Logger.Level savingLevel;
    private static final Logger.Level echoLevel;
    private static String packageName;
    public static final Companion Companion;

    private final void printVersionInfo(Context context) {
        String string;
        PackageManager packageMgr = context.getPackageManager();
        String message = null;
        try {
            PackageInfo packageInfo = packageMgr.getPackageInfo(packageName, 0);
            int appLabelId = packageInfo.applicationInfo.labelRes;
            string = (appLabelId != 0 ? context.getString(appLabelId) : UNKNOWN_SIGNATURE) + " v" + packageInfo.versionName + " #" + packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logException(e);
            string = NO_APPLICATION_INFO_MESSAGE;
        }
        message = string;
        this.i("APP_INFO", message);
    }

    @Override
    public void d(@Nullable String tag, @Nullable String message) {
        this.logMessage(tag, message, Logger.Level.Debug);
    }

    @Override
    public void w(@Nullable String tag, @Nullable String message) {
        this.logMessage(tag, message, Logger.Level.Warning);
    }

    @Override
    public void e(@Nullable String tag, @Nullable String message) {
        this.logMessage(tag, message, Logger.Level.Error);
    }

    @Override
    public void i(@Nullable String tag, @Nullable String message) {
        this.logMessage(tag, message, Logger.Level.Information);
    }

    public final void e(@Nullable String tag, @Nullable String where, @NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string = "Exception in " + where + ": " + e.getClass().getName() + LOG_FIELD_SEPARATOR + e.getMessage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(\"Exception\u2026              .toString()");
        String message = string;
        this.e(tag, message);
    }

    public final void d(@Nullable String message) {
        String tag = this.getCallerClassName();
        this.d(tag, message);
    }

    public final void i(@Nullable String message) {
        String tag = this.getCallerClassName();
        this.i(tag, message);
    }

    public final void w(@Nullable String message) {
        String tag = this.getCallerClassName();
        this.w(tag, message);
    }

    public final void e(@Nullable String message) {
        String tag = this.getCallerClassName();
        this.e(tag, message);
    }

    @Override
    public void logException(@Nullable Throwable e) {
        if (!prepared) {
            return;
        }
        String tag = this.getCallerClassName();
        String where = this.getCallerMethodName();
        if (e != null) {
            this.e(tag, where, e);
        } else {
            this.e(tag, where, new Exception("Unknown exception"));
        }
    }

    @Override
    public void logMethod() {
        if (!prepared) {
            return;
        }
        String tag = this.getCallerClassName();
        String where = this.getCallerMethodName();
        this.i(tag, where);
    }

    private final void logMessage(String tag, String message, Logger.Level level) {
        if (!prepared) {
            return;
        }
        if (level.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage(tag, message, level);
        }
        if (level.ordinal() >= savingLevel.ordinal()) {
            this.logToFile(tag, message, level);
        }
    }

    private final void echoMessage(String tag, String message, Logger.Level level) {
        switch (DebugLog$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                Log.d((String)tag, (String)message);
                break;
            }
            case 2: {
                Log.e((String)tag, (String)message);
                break;
            }
            case 3: {
                Log.w((String)tag, (String)message);
                break;
            }
            case 4: {
                Log.i((String)tag, (String)message);
                break;
            }
            case 5: {
                Log.v((String)tag, (String)message);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void logToFile(String tag, String message, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer != null) {
            try {
                writer.write(this.buildLogMessage(tag, message, level));
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeSafely(writer);
            }
        }
    }

    private final void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final String buildLogMessage(String tag, String message, Logger.Level level) {
        String string = tag;
        if (string == null || (string = StringsKt.replace$default((String)string, (char)'|', (char)'/', (boolean)false, (int)4, null)) == null) {
            string = "";
        }
        String editedTag = string;
        return StringsKt.trimIndent((String)("\n            " + TIME_FORMAT.format(new Date()) + (Object)((Object)level) + LOG_FIELD_SEPARATOR + editedTag + LOG_FIELD_SEPARATOR + message + "\n\n            "));
    }

    private final Writer getLogWriter() {
        File externalStorage;
        FileWriter writer = null;
        File file = externalStorage = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"externalStorage");
        this.prepareLogsFolder(file);
        File logfile = new File(externalStorage, this.getLogFilename());
        try {
            writer = new FileWriter(logfile, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer;
    }

    private final void prepareLogsFolder(File externalStorage) {
        File logDir = new File(externalStorage, LOG_DIRECTORY);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
    }

    private final String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    private final String tokenizeClassName(String className) {
        String string;
        List parts = new ArrayList();
        String result = null;
        try {
            String string2;
            Matcher matcher = CLASS_NAME_PATTERN.matcher(className);
            while (matcher.find()) {
                String string3;
                String part;
                String string4 = className;
                int n = matcher.start();
                int n2 = matcher.end();
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String $this$trim$iv = part;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (TextUtils.isEmpty((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) continue;
                string4 = part;
                List list = parts;
                n = 0;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string6.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                list.add(string3);
            }
            if (parts.isEmpty()) {
                string2 = className;
            } else {
                String string7 = TextUtils.join((CharSequence)"_", (Iterable)parts);
                string2 = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"TextUtils.join(\"_\", parts)");
            }
            string = string2;
        }
        catch (Exception e) {
            string = className;
        }
        result = string;
        return result;
    }

    private final String getCallerClassName() {
        String string;
        String className = null;
        int CALLER_STACK_INDEX = 4;
        try {
            String string2;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] callStack = thread.getStackTrace();
            if (callStack.length > CALLER_STACK_INDEX) {
                String fullClassName;
                StackTraceElement stackTraceElement = callStack[CALLER_STACK_INDEX];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"callStack[CALLER_STACK_INDEX]");
                String string3 = fullClassName = stackTraceElement.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fullClassName");
                int lastPoint = StringsKt.lastIndexOf$default((CharSequence)string3, (String)".", (int)0, (boolean)false, (int)6, null);
                if (lastPoint >= 0 && lastPoint + 1 < fullClassName.length()) {
                    String string4 = fullClassName;
                    int n = lastPoint + 1;
                    boolean bl = false;
                    String string5 = string4.substring(n);
                    string2 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string2 = UNKNOWN_SIGNATURE;
                }
            } else {
                string2 = UNKNOWN_SIGNATURE;
            }
            string = string2;
        }
        catch (Exception e) {
            string = UNKNOWN_SIGNATURE;
        }
        className = string;
        return this.tokenizeClassName(className);
    }

    private final String getCallerMethodName() {
        String string;
        String methodName = null;
        int CALLER_STACK_INDEX = 4;
        try {
            String string2;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] callStack = thread.getStackTrace();
            if (callStack.length > CALLER_STACK_INDEX) {
                StackTraceElement stackTraceElement = callStack[CALLER_STACK_INDEX];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"callStack[CALLER_STACK_INDEX]");
                String string3 = stackTraceElement.getMethodName();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"callStack[CALLER_STACK_INDEX].methodName");
            } else {
                string2 = UNKNOWN_SIGNATURE;
            }
            string = string2;
        }
        catch (Exception e) {
            string = UNKNOWN_SIGNATURE;
        }
        methodName = string;
        return methodName;
    }

    public DebugLog(@Nullable Context context) {
        prepared = true;
        if (context != null) {
            String string = context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageName");
            packageName = string;
            this.printVersionInfo(context);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    static {
        Companion = new Companion(null);
        TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
        CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
        savingLevel = Logger.Level.Verbose;
        echoLevel = Logger.Level.Verbose;
        packageName = DEFAULT_PACKAGE_NAME;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/scanbot/sdk/util/log/DebugLog$Companion;", "", "()V", "CLASS_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "DEFAULT_PACKAGE_NAME", "", "LOG_DIRECTORY", "LOG_EXTENSION", "LOG_FIELD_SEPARATOR", "NO_APPLICATION_INFO_MESSAGE", "TIME_FORMAT", "Ljava/text/SimpleDateFormat;", "UNKNOWN_SIGNATURE", "echoEnabled", "", "echoLevel", "Lio/scanbot/sdk/util/log/Logger$Level;", "packageName", "prepared", "savingEnabled", "savingLevel", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

