/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.graphics.PointF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/util/PolygonHelper;", "", "()V", "Companion", "sdk-base_release"})
public final class PolygonHelper {
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final ArrayList<PointF> getFulPolygon() {
        return Companion.getFulPolygon();
    }

    @JvmStatic
    @NotNull
    public static final List<PointF> rotatePolygon(@NotNull List<? extends PointF> polygon, float rotation) {
        return Companion.rotatePolygon(polygon, rotation);
    }

    @JvmStatic
    public static final float approximatePolygonAspectRatio(@NotNull List<? extends PointF> polygon, int frameWidth, int frameHeight, int frameOrientation) {
        return Companion.approximatePolygonAspectRatio(polygon, frameWidth, frameHeight, frameOrientation);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u0018\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00070\rj\b\u0012\u0004\u0012\u00020\u0007`\u000eH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/util/PolygonHelper$Companion;", "", "()V", "approximatePolygonAspectRatio", "", "polygon", "", "Landroid/graphics/PointF;", "frameWidth", "", "frameHeight", "frameOrientation", "getFulPolygon", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "rotatePolygon", "rotation", "sdk-base_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ArrayList<PointF> getFulPolygon() {
            return CollectionsKt.arrayListOf((Object[])new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.0f, 1.0f), new PointF(1.0f, 1.0f), new PointF(1.0f, 0.0f)});
        }

        @JvmStatic
        @NotNull
        public final List<PointF> rotatePolygon(@NotNull List<? extends PointF> polygon, float rotation) {
            Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
            List result = new ArrayList();
            float rotationPoint = 0.5f;
            float grad = (float)(Math.PI * (double)rotation / (double)180);
            for (PointF pointF : polygon) {
                float f = pointF.x - rotationPoint;
                float f2 = rotationPoint;
                List list = result;
                boolean bl = false;
                float f3 = (float)Math.cos(grad);
                float f4 = f2 + f * f3;
                f = rotationPoint - pointF.y;
                f2 = f4;
                bl = false;
                f3 = (float)Math.sin(grad);
                float f5 = f2 + f * f3;
                f3 = pointF.y - rotationPoint;
                f = rotationPoint;
                f2 = f5;
                bl = false;
                float f6 = (float)Math.cos(grad);
                float f7 = f + f3 * f6;
                f3 = pointF.x - rotationPoint;
                f = f7;
                bl = false;
                f6 = (float)Math.sin(grad);
                float f8 = f + f3 * f6;
                float f9 = f2;
                list.add(new PointF(f9, f8));
            }
            Collections.rotate(result, (int)(rotation / (float)90));
            return result;
        }

        public static /* synthetic */ List rotatePolygon$default(Companion companion, List list, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 0.0f;
            }
            return companion.rotatePolygon(list, f);
        }

        @JvmStatic
        public final float approximatePolygonAspectRatio(@NotNull List<? extends PointF> polygon, int frameWidth, int frameHeight, int frameOrientation) {
            Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
            float polygonWidth = (polygon.get((int)1).x - polygon.get((int)0).x) * (float)frameWidth;
            float polygonHeight = (polygon.get((int)2).y - polygon.get((int)1).y) * (float)frameHeight;
            return frameOrientation % 180 == 0 ? polygonWidth / polygonHeight : polygonHeight / polygonWidth;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

