/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020*H\u0002J\u000e\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020*J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u00020\u000f2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00106\u001a\u00020'2\u0006\u0010-\u001a\u00020*R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011\u00a8\u00067"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "assetManager", "Landroid/content/res/AssetManager;", "blobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "allLanguagesWithAvailableOcrBlobs", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "banksDataFile", "Ljava/io/File;", "getBanksDataFile", "()Ljava/io/File;", "barcodeScannerModelFile", "getBarcodeScannerModelFile", "blurEstimatorModelFile", "getBlurEstimatorModelFile", "chequeDigitPredictionModelFile", "getChequeDigitPredictionModelFile", "dcModelsFolderFile", "getDcModelsFolderFile", "documentDetectorModelFile", "getDocumentDetectorModelFile", "filterPredictionModelFile", "getFilterPredictionModelFile", "idCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile", "logger", "Lio/scanbot/sdk/util/log/Logger;", "mrzCascadeFile", "getMrzCascadeFile", "ocrBlobsDirectory", "getOcrBlobsDirectory", "allBlobsAvailable", "", "blobs", "", "Lio/scanbot/sdk/entity/Blob;", "copyFromAssets", "", "blob", "blobUri", "Landroid/net/Uri;", "ensureDirectoryCreated", "fetch", "forceFetch", "blobType", "Lio/scanbot/sdk/blob/BlobType;", "getLocalFileStrict", "isBlobAvailable", "sdk-base_release"})
public final class BlobManager {
    private final Logger logger;
    private final BlobStoreStrategy blobStoreStrategy;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) throws IOException {
        Intrinsics.checkParameterIsNotNull(blobs, (String)"blobs");
        for (Blob blob : blobs) {
            if (this.isBlobAvailable(blob)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)blob, (String)"blob");
        File file = new File(blob.getLocalPath());
        try (InputStream fileInputStream = this.assetManager.open(blob.getRemotePath());){
            bl = file.exists() && (long)fileInputStream.available() == file.length();
        }
        return bl;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        File[] files;
        EnumSet<Language> enumSet = EnumSet.noneOf(Language.class);
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"EnumSet.noneOf(Language::class.java)");
        Set languageSet = enumSet;
        File ocrDataDirectory = this.blobStoreStrategy.getOcrDataDirectory();
        File[] fileArray = ocrDataDirectory.listFiles();
        if (fileArray == null) {
            return languageSet;
        }
        File[] fileArray2 = files = fileArray;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            Language language;
            String tessBlobName;
            File file;
            File file2 = file = fileArray2[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (file2.isDirectory()) continue;
            String filename = file.getName();
            String string = tessBlobName = FilenameUtils.removeExtension((String)filename);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tessBlobName");
            if (Language.Companion.languageByTessTag(string) == null) {
                continue;
            }
            languageSet.add(language);
        }
        return languageSet;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File ocrDataDirectory = this.blobStoreStrategy.getOcrDataDirectory();
        if (!ocrDataDirectory.exists() && !ocrDataDirectory.mkdirs()) {
            throw (Throwable)new IOException("Can't get OCR blobs directory");
        }
        return ocrDataDirectory;
    }

    @NotNull
    public final File getBanksDataFile() throws IOException {
        return this.getLocalFileStrict(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeScannerModelFile() throws IOException {
        return this.getLocalFileStrict(BlobType.BARCODE_SCANNER_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.getLocalFileStrict(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() throws IOException {
        return this.getLocalFileStrict(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.getLocalFileStrict(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getChequeDigitPredictionModelFile() throws IOException {
        return this.getLocalFileStrict(BlobType.CHEQUE_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() throws IOException {
        return this.getLocalFileStrict(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() throws IOException {
        return this.blobStoreStrategy.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() throws IOException {
        return this.blobStoreStrategy.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    private final File getLocalFileStrict(BlobType blobType) throws IOException {
        File localFile = this.blobStoreStrategy.getLocalFileFor(blobType);
        if (!localFile.exists()) {
            throw (Throwable)new IOException("Can't get file for blob type: " + (Object)((Object)blobType));
        }
        return localFile;
    }

    public final void fetch(@NotNull Blob blob) throws IOException {
        Uri blobUri;
        Intrinsics.checkParameterIsNotNull((Object)blob, (String)"blob");
        if (this.isBlobAvailable(blob)) {
            return;
        }
        this.ensureDirectoryCreated(blob);
        Uri uri = blobUri = Uri.parse((String)blob.getRemotePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"blobUri");
        this.copyFromAssets(blob, uri);
    }

    public final void forceFetch(@NotNull BlobType blobType) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blobType), (String)"blobType");
        for (Blob blob : this.blobFactory.getBlobsForType(blobType)) {
            this.fetch(blob);
        }
    }

    private final void copyFromAssets(Blob blob, Uri blobUri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(blobUri.getPath()), (File)new File(blob.getLocalPath()));
    }

    private final void ensureDirectoryCreated(Blob blob) throws IOException {
        File dir = new File(blob.getLocalPath()).getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw (Throwable)new IOException("Can't create destination directory");
        }
    }

    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        Intrinsics.checkParameterIsNotNull((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)assetManager, (String)"assetManager");
        Intrinsics.checkParameterIsNotNull((Object)blobFactory, (String)"blobFactory");
        this.blobStoreStrategy = blobStoreStrategy;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
        this.logger = LoggerProvider.getLogger();
    }
}

