/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.snap;

import android.hardware.Camera;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tH\u0007J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tH\u0002J*\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\t2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J:\u0010\u0013\u001a\b\u0018\u00010\u000fR\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0018\u0010\u0016\u001a\u00060\u000fR\u00020\t2\n\u0010\u0007\u001a\u00060\bR\u00020\tH\u0007J&\u0010\u0017\u001a\u00060\u000fR\u00020\t2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u000fR\u00020\t0\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/util/snap/Utils;", "", "()V", "ASPECT_TOLERANCE", "", "enableAutoFocus", "", "parameters", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "enableContinuousFocus", "extractFocusModes", "", "", "findByWidthAndHeight", "Landroid/hardware/Camera$Size;", "width", "", "height", "getBestAspectPictureSize", "displayOrientation", "closeEnough", "getLargestPictureSize", "getLargestSizeWithAspectRatioMatch", "sizes", "targetAspect", "isFlashSupported", "", "SizeComparator", "sdk-base_release"})
public final class Utils {
    private static final double ASPECT_TOLERANCE = 0.1;
    public static final Utils INSTANCE;

    @JvmStatic
    public static final boolean isFlashSupported(@Nullable Camera.Parameters parameters) {
        if (parameters == null) {
            return false;
        }
        List supportedFlashModes = parameters.getSupportedFlashModes();
        return supportedFlashModes != null && !supportedFlashModes.isEmpty() && (supportedFlashModes.size() != 1 || !Intrinsics.areEqual((Object)((String)supportedFlashModes.get(0)), (Object)"off"));
    }

    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestPictureSize(@NotNull Camera.Parameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Camera.Size result = null;
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (result == null) {
                result = size;
                continue;
            }
            int newArea = size.width * size.height;
            int resultArea = result.width * result.height;
            if (newArea <= resultArea) continue;
            result = size;
        }
        Camera.Size size = result;
        if (size == null) {
            Intrinsics.throwNpe();
        }
        return size;
    }

    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestSizeWithAspectRatioMatch(@NotNull List<? extends Camera.Size> sizes, double targetAspect) {
        Intrinsics.checkParameterIsNotNull(sizes, (String)"sizes");
        Comparator comparator = new SizeComparator();
        ArrayList<Camera.Size> matchedPictureSizes = new ArrayList<Camera.Size>();
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            double d = targetAspect - ratio;
            boolean bl = false;
            if (!(Math.abs(d) < 0.1)) continue;
            matchedPictureSizes.add(size);
        }
        Object t = Collections.max((Collection)matchedPictureSizes, comparator);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"Collections.max(matchedPictureSizes, comparator)");
        return (Camera.Size)t;
    }

    @JvmStatic
    @Nullable
    public static final Camera.Size findByWidthAndHeight(@NotNull Camera.Parameters parameters, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (size.width != width || size.height != height) continue;
            return size;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Camera.Size getBestAspectPictureSize(int displayOrientation, int width, int height, @NotNull Camera.Parameters parameters, double closeEnough) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        double targetRatio = (double)width / (double)height;
        Camera.Size optimalSize = null;
        double minDiff = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        if (displayOrientation == 90 || displayOrientation == 270) {
            targetRatio = (double)height / (double)width;
        }
        List sizes = parameters.getSupportedPictureSizes();
        Collections.sort(sizes, Collections.reverseOrder(new SizeComparator()));
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            double d = ratio - targetRatio;
            boolean bl = false;
            if (Math.abs(d) < minDiff) {
                optimalSize = size;
                d = ratio - targetRatio;
                bl = false;
                minDiff = Math.abs(d);
            }
            if (!(minDiff < closeEnough)) continue;
            break;
        }
        return optimalSize;
    }

    @JvmStatic
    public static final void enableContinuousFocus(@Nullable Camera.Parameters parameters) {
        block2: {
            List<String> focusModes;
            block3: {
                block1: {
                    if (parameters == null) {
                        return;
                    }
                    focusModes = INSTANCE.extractFocusModes(parameters);
                    if (!focusModes.contains("continuous-picture")) break block1;
                    parameters.setFocusMode("continuous-picture");
                    break block2;
                }
                if (!focusModes.contains("continuous-video")) break block3;
                parameters.setFocusMode("continuous-video");
                break block2;
            }
            if (!focusModes.contains("auto")) break block2;
            parameters.setFocusMode("auto");
        }
    }

    @JvmStatic
    public static final void enableAutoFocus(@Nullable Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        List<String> focusModes = INSTANCE.extractFocusModes(parameters);
        if (focusModes.contains("auto") && Intrinsics.areEqual((Object)parameters.getFocusMode(), (Object)"auto") ^ true) {
            parameters.setFocusMode("auto");
        }
    }

    private final List<String> extractFocusModes(Camera.Parameters parameters) {
        if (parameters == null) {
            return CollectionsKt.emptyList();
        }
        List modes = parameters.getSupportedFocusModes();
        List list = modes;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\u0002R\u00020\u00032\n\u0010\b\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/util/snap/Utils$SizeComparator;", "Ljava/util/Comparator;", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "()V", "compare", "", "lhs", "rhs", "sdk-base_release"})
    private static final class SizeComparator
    implements Comparator<Camera.Size> {
        @Override
        public int compare(@NotNull Camera.Size lhs, @NotNull Camera.Size rhs) {
            Intrinsics.checkParameterIsNotNull((Object)lhs, (String)"lhs");
            Intrinsics.checkParameterIsNotNull((Object)rhs, (String)"rhs");
            int left = lhs.width * lhs.height;
            int right = rhs.width * rhs.height;
            return left - right;
        }
    }
}

