/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.autosnapping;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.scanbot.sdk.camera.autosnapping.SignificantMoveListener;

public class SignificantMoveCatcher
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener = null;

    public SignificantMoveCatcher(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }

    private void registerSensorListener() {
        if (this.accelerometer != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 2);
        }
    }

    private void unregisterSensorListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void registerSignificantMoveListener(SignificantMoveListener listener) {
        if (listener != null && this.moveListener != listener) {
            this.moveListener = listener;
            this.registerSensorListener();
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener listener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            float[] gravity = (float[])event.values.clone();
            float x = gravity[0];
            float y = gravity[1];
            float z = gravity[2];
            this.lastAcceleration = this.currentAcceleration;
            this.currentAcceleration = (float)Math.sqrt(x * x + y * y + z * z);
            float delta = this.currentAcceleration - this.lastAcceleration;
            this.acceleration = this.acceleration * 0.9f + delta;
            if (this.moveListener != null && this.acceleration > this.moveListener.getMoveThreshold()) {
                this.moveListener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

