/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "getApplication", "()Landroid/app/Application;", "sdkBarcodeImagesFolderName", "", "cleanupBarcodeImagesDirectory", "", "getBarcodeImagesDirectory", "Ljava/io/File;", "sdk-base_release"})
public final class BarcodeFileStorage {
    private final String sdkBarcodeImagesFolderName = "barcode_images";
    @NotNull
    private final Application application;

    @NotNull
    public final File getBarcodeImagesDirectory() throws IOException {
        String sdkFilesDirPath = PreferenceManager.getDefaultSharedPreferences((Context)((Context)this.application)).getString("CUSTOM_SDK_FILES_PATH", "");
        return FileUtils.ensureDirExists(sdkFilesDirPath) ? FileUtils.getFilesDirOrShowError(sdkFilesDirPath, this.sdkBarcodeImagesFolderName) : FileUtils.getFilesDirOrShowError(FileUtils.getAppFilesDirOrShowError((Context)this.application, "scanbot-sdk").getPath(), this.sdkBarcodeImagesFolderName);
    }

    public final void cleanupBarcodeImagesDirectory() {
        try {
            File[] fileArray = this.getBarcodeImagesDirectory().listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"getBarcodeImagesDirectory().listFiles()");
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                org.apache.commons.io.FileUtils.deleteQuietly((File)it);
            }
        }
        catch (Exception e) {
            LoggerProvider.getLogger().logException(e);
        }
    }

    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    public BarcodeFileStorage(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
        this.sdkBarcodeImagesFolderName = "barcode_images";
    }
}

