/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.autosnapping;

import android.os.SystemClock;
import io.scanbot.sdk.camera.autosnapping.IAutoSnappingPredicate;
import io.scanbot.sdk.camera.autosnapping.ResettablePredicate;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0002H\u0016J\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/scanbot/sdk/camera/autosnapping/CaptureIntervalAutoSnappingPredicate;", "Lio/scanbot/sdk/camera/autosnapping/IAutoSnappingPredicate;", "", "Lio/scanbot/sdk/camera/autosnapping/ResettablePredicate;", "()V", "captureInterval", "Ljava/util/concurrent/atomic/AtomicLong;", "lastCapture", "", "reset", "setSensitivity", "sensitivity", "", "verify", "", "param", "(Lkotlin/Unit;)Z", "Companion", "sdk-base_release"})
public final class CaptureIntervalAutoSnappingPredicate
implements IAutoSnappingPredicate<Unit>,
ResettablePredicate {
    private long lastCapture;
    private final AtomicLong captureInterval = new AtomicLong(0L);
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    public static final float DEFAULT_SENSITIVITY = 0.66f;
    public static final Companion Companion = new Companion(null);

    public final void setSensitivity(float sensitivity) {
        float threshold = 1.0f - ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(sensitivity), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        this.captureInterval.set((long)(threshold * (float)3000L));
    }

    @Override
    public boolean verify(@NotNull Unit param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return SystemClock.elapsedRealtime() - this.lastCapture > this.captureInterval.get();
    }

    @Override
    public void reset() {
        this.lastCapture = SystemClock.elapsedRealtime();
    }

    public CaptureIntervalAutoSnappingPredicate() {
        this.setSensitivity(0.66f);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/camera/autosnapping/CaptureIntervalAutoSnappingPredicate$Companion;", "", "()V", "DEFAULT_SENSITIVITY", "", "MAXIMUM_CAPTURE_INTERVAL", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

