/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.util.FileUtils;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "", "application", "Landroid/app/Application;", "preferences", "Landroid/content/SharedPreferences;", "(Landroid/app/Application;Landroid/content/SharedPreferences;)V", "binariesDirectory", "Ljava/io/File;", "getBinariesDirectory", "()Ljava/io/File;", "ocrDataDirectory", "getOcrDataDirectory", "getLocalFileFor", "blobType", "Lio/scanbot/sdk/blob/BlobType;", "Companion", "sdk-base_release"})
public final class BlobStoreStrategy {
    private final Application application;
    private final SharedPreferences preferences;
    @NotNull
    public static final String BINARIES_DIR_NAME = "binaries";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final File getBinariesDirectory() throws IOException {
        String dirPath;
        String string = dirPath = this.preferences.getString("CUSTOM_SDK_FILES_PATH", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirPath");
        CharSequence charSequence = string;
        boolean bl = false;
        return charSequence.length() > 0 ? FileUtils.getFilesDirOrShowError(dirPath, BINARIES_DIR_NAME) : FileUtils.getFilesDirOrShowError(FileUtils.getAppFilesDirOrShowError((Context)this.application, "scanbot-sdk").getPath(), BINARIES_DIR_NAME);
    }

    @NotNull
    public final File getOcrDataDirectory() throws IOException {
        File file = org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"tessdata"});
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"org.apache.commons.io.Fi\u2026iesDirectory, \"tessdata\")");
        return file;
    }

    @NotNull
    public final File getLocalFileFor(@NotNull BlobType blobType) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)((Object)blobType), (String)"blobType");
        if (blobType.isOcrBlob()) {
            File file2 = org.apache.commons.io.FileUtils.getFile((File)this.getOcrDataDirectory(), (String[])new String[]{blobType.getFilename()});
            file = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"org.apache.commons.io.Fi\u2026ctory, blobType.filename)");
        } else {
            File file3 = org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{blobType.getFilename()});
            file = file3;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"org.apache.commons.io.Fi\u2026ctory, blobType.filename)");
        }
        return file;
    }

    public BlobStoreStrategy(@NotNull Application application, @NotNull SharedPreferences preferences) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)preferences, (String)"preferences");
        this.application = application;
        this.preferences = preferences;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/BlobStoreStrategy$Companion;", "", "()V", "BINARIES_DIR_NAME", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

