/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class CameraXImageUtils {
    private static final String a = "ImageUtil";

    private CameraXImageUtils() {
    }

    @Nullable
    public static byte[] imageToJpegByteArray(@NonNull ImageProxy imageProxy) throws CodecFailedException {
        byte[] byArray = null;
        if (imageProxy.getFormat() == 256) {
            byArray = CameraXImageUtils.a(imageProxy);
        } else if (imageProxy.getFormat() == 35) {
            byArray = CameraXImageUtils.c(imageProxy);
        } else {
            Log.w((String)a, (String)("Unrecognized image format: " + imageProxy.getFormat()));
        }
        return byArray;
    }

    @NonNull
    public static byte[] cropByteArray(@NonNull byte[] byArray, @Nullable Rect rect) throws CodecFailedException {
        block7: {
            ByteArrayOutputStream byteArrayOutputStream;
            if (rect == null) {
                return byArray;
            }
            int n = 0;
            Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n, (int)byArray.length, (boolean)false);
            rect = object.decodeRegion(rect, new BitmapFactory.Options());
            try {
                object.recycle();
                if (rect == null) break block7;
            }
            catch (IOException iOException) {
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException, CodecFailedException.FailureType.DECODE_FAILED);
            }
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (rect.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                rect.recycle();
                return ((ByteArrayOutputStream)object).toByteArray();
            }
            throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
    }

    public static boolean isAspectRatioValid(@Nullable Rational rational) {
        return rational != null && rational.floatValue() > 0.0f && !rational.isNaN();
    }

    public static boolean isAspectRatioValid(@NonNull Size size, @Nullable Rational rational) {
        return rational != null && rational.floatValue() > 0.0f && CameraXImageUtils.a(size, rational) && !rational.isNaN();
    }

    @Nullable
    public static Rect computeCropRectFromAspectRatio(@NonNull Size size, @NonNull Rational rational) {
        if (!CameraXImageUtils.isAspectRatioValid(rational)) {
            Log.w((String)a, (String)"Invalid view ratio.");
            return null;
        }
        Rational rational2 = rational;
        int n = size.getWidth();
        int n2 = size.getHeight();
        float f2 = n;
        float f3 = n2;
        float f4 = f2 / f3;
        int n3 = 0;
        int n4 = 0;
        int n5 = rational2.getNumerator();
        int n6 = rational2.getDenominator();
        if (rational2.floatValue() > f4) {
            int n7 = n2;
            n2 = Math.round(f2 / (float)n5 * (float)n6);
            n4 = (n7 - n2) / 2;
        } else {
            int n8 = n;
            n = Math.round(f3 / (float)n6 * (float)n5);
            n3 = (n8 - n) / 2;
        }
        n = n3 + n;
        n2 = n4 + n2;
        return new Rect(n3, n4, n, n2);
    }

    @NonNull
    public static Rational rotate(@NonNull Rational rational, int n) {
        if (n != 90 && n != 270) {
            return rational;
        }
        return CameraXImageUtils.a(rational);
    }

    private static byte[] a(byte[] byArray, int n, int n2, @Nullable Rect rect) throws CodecFailedException {
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(byArray, 17, n, n2, null);
        if (rect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, n, n2);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            return byteArrayOutputStream2.toByteArray();
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    private static byte[] d(ImageProxy imageProxy) {
        ImageProxy.PlaneProxy planeProxy = imageProxy.getPlanes()[0];
        ImageProxy imageProxy2 = imageProxy;
        ImageProxy.PlaneProxy planeProxy2 = imageProxy2.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy3 = imageProxy2.getPlanes()[2];
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n = byteBuffer.remaining();
        int n2 = 0;
        byte[] byArray = new byte[n + imageProxy.getWidth() * imageProxy.getHeight() / 2];
        for (int i = 0; i < imageProxy.getHeight(); ++i) {
            byteBuffer.get(byArray, n2, imageProxy.getWidth());
            n2 += imageProxy.getWidth();
            byteBuffer.position(Math.min(n, byteBuffer.position() - imageProxy.getWidth() + planeProxy.getRowStride()));
        }
        ImageProxy imageProxy3 = imageProxy;
        int n3 = imageProxy3.getHeight() / 2;
        int n4 = imageProxy3.getWidth() / 2;
        int n5 = planeProxy3.getRowStride();
        n = planeProxy2.getRowStride();
        int n6 = planeProxy3.getPixelStride();
        int n7 = planeProxy2.getPixelStride();
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n3; ++i) {
            byteBuffer3.get(byArray2, 0, Math.min(n5, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n, byteBuffer2.remaining()));
            int n8 = 0;
            int n9 = 0;
            for (int j = 0; j < n4; ++j) {
                int n10 = n2 + 1;
                byArray[n2] = byArray2[n8];
                n2 = n10 + 1;
                byArray[n10] = byArray3[n9];
                n8 += n6;
                n9 += n7;
            }
        }
        return byArray;
    }

    private static boolean a(Size size, Rational rational) {
        int n;
        float f2;
        Size size2 = size;
        int n2 = size2.getWidth();
        int n3 = size2.getHeight();
        Rational rational2 = rational;
        int n4 = rational2.getNumerator();
        float f3 = n4;
        return n3 != Math.round((float)n2 / f3 * (f2 = (float)(n = rational2.getDenominator()))) || n2 != Math.round((float)n3 / f2 * f3);
    }

    private static Rational a(Rational rational) {
        if (rational == null) {
            return rational;
        }
        Rational rational2 = rational;
        int n = rational2.getDenominator();
        return new Rational(n, rational2.getNumerator());
    }

    private static boolean b(ImageProxy imageProxy) {
        Size size;
        Size size2 = size;
        ImageProxy imageProxy2 = imageProxy;
        int n = imageProxy2.getWidth();
        size = new Size(n, imageProxy2.getHeight());
        return new Size(imageProxy.getCropRect().width(), imageProxy.getCropRect().height()).equals((Object)size2) ^ true;
    }

    private static byte[] a(ImageProxy imageProxy) throws CodecFailedException {
        ImageProxy imageProxy2 = imageProxy;
        ByteBuffer byteBuffer = imageProxy2.getPlanes()[0].getBuffer();
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        if (CameraXImageUtils.b(imageProxy2)) {
            byArray = CameraXImageUtils.cropByteArray(byArray, imageProxy.getCropRect());
        }
        return byArray;
    }

    private static byte[] c(ImageProxy object) throws CodecFailedException {
        ImageProxy imageProxy = object;
        byte[] byArray = CameraXImageUtils.d(imageProxy);
        int n = imageProxy.getWidth();
        int n2 = imageProxy.getHeight();
        object = CameraXImageUtils.b(imageProxy) ? object.getCropRect() : null;
        return CameraXImageUtils.a(byArray, n, n2, (Rect)object);
    }

    public static final class CodecFailedException
    extends Exception {
        private FailureType a;

        public CodecFailedException(String string) {
            super(string);
            this.a = FailureType.UNKNOWN;
        }

        public CodecFailedException(String string, FailureType failureType) {
            super(string);
            this.a = failureType;
        }

        @NonNull
        public FailureType getFailureType() {
            return this.a;
        }

        public static final class FailureType
        extends Enum<FailureType> {
            public static final /* enum */ FailureType ENCODE_FAILED;
            public static final /* enum */ FailureType DECODE_FAILED;
            public static final /* enum */ FailureType UNKNOWN;
            private static final /* synthetic */ FailureType[] a;

            public static FailureType[] values() {
                return (FailureType[])a.clone();
            }

            public static FailureType valueOf(String string) {
                return Enum.valueOf(FailureType.class, string);
            }

            static {
                FailureType failureType;
                FailureType failureType2;
                FailureType failureType3;
                FailureType failureType4 = failureType3;
                ENCODE_FAILED = new FailureType();
                FailureType failureType5 = failureType2;
                DECODE_FAILED = new FailureType();
                FailureType failureType6 = failureType;
                UNKNOWN = new FailureType();
                a = new FailureType[]{failureType4, failureType5, failureType6};
            }
        }
    }
}

