/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/util/thread/BackgroundThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "threadPriority", "", "threadNamePrefix", "", "(ILjava/lang/String;)V", "threadCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "Companion", "sdk-base_release"})
public final class BackgroundThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadCounter;
    private final int threadPriority;
    private final String threadNamePrefix;
    private static final int DEFAULT_THREAD_PRIORITY = 4;
    private static final String DEFAULT_THREAD_NAME = "WORKER_THREAD_";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Thread thread = new Thread(r);
        thread.setPriority(this.threadPriority);
        thread.setName(this.threadNamePrefix + this.threadCounter.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }

    @JvmOverloads
    public BackgroundThreadFactory(int threadPriority, @NotNull String threadNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)threadNamePrefix, (String)"threadNamePrefix");
        this.threadPriority = threadPriority;
        this.threadNamePrefix = threadNamePrefix;
        this.threadCounter = new AtomicInteger(0);
    }

    public /* synthetic */ BackgroundThreadFactory(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            string = DEFAULT_THREAD_NAME;
        }
        this(n, string);
    }

    @JvmOverloads
    public BackgroundThreadFactory(int threadPriority) {
        this(threadPriority, null, 2, null);
    }

    @JvmOverloads
    public BackgroundThreadFactory() {
        this(0, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/util/thread/BackgroundThreadFactory$Companion;", "", "()V", "DEFAULT_THREAD_NAME", "", "DEFAULT_THREAD_PRIORITY", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

