/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class CameraXImageUtils {
    private static final String TAG = "ImageUtil";

    private CameraXImageUtils() {
    }

    @Nullable
    public static byte[] imageToJpegByteArray(@NonNull ImageProxy image) throws CodecFailedException {
        byte[] data = null;
        if (image.getFormat() == 256) {
            data = CameraXImageUtils.jpegImageToJpegByteArray(image);
        } else if (image.getFormat() == 35) {
            data = CameraXImageUtils.yuvImageToJpegByteArray(image);
        } else {
            Log.w((String)TAG, (String)("Unrecognized image format: " + image.getFormat()));
        }
        return data;
    }

    @NonNull
    public static byte[] cropByteArray(@NonNull byte[] data, @Nullable Rect cropRect) throws CodecFailedException {
        if (cropRect == null) {
            return data;
        }
        Bitmap bitmap = null;
        try {
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((byte[])data, (int)0, (int)data.length, (boolean)false);
            bitmap = decoder.decodeRegion(cropRect, new BitmapFactory.Options());
            decoder.recycle();
        }
        catch (IllegalArgumentException e) {
            throw new CodecFailedException("Decode byte array failed with illegal argument." + e, CodecFailedException.FailureType.DECODE_FAILED);
        }
        catch (IOException e) {
            throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        if (bitmap == null) {
            throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean success = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        if (!success) {
            throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        bitmap.recycle();
        return out.toByteArray();
    }

    public static boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        return aspectRatio != null && aspectRatio.floatValue() > 0.0f && !aspectRatio.isNaN();
    }

    public static boolean isAspectRatioValid(@NonNull Size sourceSize, @Nullable Rational aspectRatio) {
        return aspectRatio != null && aspectRatio.floatValue() > 0.0f && CameraXImageUtils.isCropAspectRatioHasEffect(sourceSize, aspectRatio) && !aspectRatio.isNaN();
    }

    @Nullable
    public static Rect computeCropRectFromAspectRatio(@NonNull Size sourceSize, @NonNull Rational aspectRatio) {
        if (!CameraXImageUtils.isAspectRatioValid(aspectRatio)) {
            Log.w((String)TAG, (String)"Invalid view ratio.");
            return null;
        }
        int sourceWidth = sourceSize.getWidth();
        int sourceHeight = sourceSize.getHeight();
        float srcRatio = (float)sourceWidth / (float)sourceHeight;
        int cropLeft = 0;
        int cropTop = 0;
        int outputWidth = sourceWidth;
        int outputHeight = sourceHeight;
        int numerator = aspectRatio.getNumerator();
        int denominator = aspectRatio.getDenominator();
        if (aspectRatio.floatValue() > srcRatio) {
            outputHeight = Math.round((float)sourceWidth / (float)numerator * (float)denominator);
            cropTop = (sourceHeight - outputHeight) / 2;
        } else {
            outputWidth = Math.round((float)sourceHeight / (float)denominator * (float)numerator);
            cropLeft = (sourceWidth - outputWidth) / 2;
        }
        return new Rect(cropLeft, cropTop, cropLeft + outputWidth, cropTop + outputHeight);
    }

    @NonNull
    public static Rational rotate(@NonNull Rational rational, int rotation) {
        if (rotation == 90 || rotation == 270) {
            return CameraXImageUtils.inverseRational(rational);
        }
        return rational;
    }

    private static byte[] nv21ToJpeg(byte[] nv21, int width, int height, @Nullable Rect cropRect) throws CodecFailedException {
        ByteArrayOutputStream out;
        YuvImage yuv = new YuvImage(nv21, 17, width, height, null);
        boolean success = yuv.compressToJpeg(cropRect == null ? new Rect(0, 0, width, height) : cropRect, 100, (OutputStream)(out = new ByteArrayOutputStream()));
        if (!success) {
            throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        return out.toByteArray();
    }

    private static byte[] yuv_420_888toNv21(ImageProxy image) {
        ImageProxy.PlaneProxy yPlane = image.getPlanes()[0];
        ImageProxy.PlaneProxy uPlane = image.getPlanes()[1];
        ImageProxy.PlaneProxy vPlane = image.getPlanes()[2];
        ByteBuffer yBuffer = yPlane.getBuffer();
        ByteBuffer uBuffer = uPlane.getBuffer();
        ByteBuffer vBuffer = vPlane.getBuffer();
        yBuffer.rewind();
        uBuffer.rewind();
        vBuffer.rewind();
        int ySize = yBuffer.remaining();
        int position = 0;
        byte[] nv21 = new byte[ySize + image.getWidth() * image.getHeight() / 2];
        for (int row = 0; row < image.getHeight(); ++row) {
            yBuffer.get(nv21, position, image.getWidth());
            position += image.getWidth();
            yBuffer.position(Math.min(ySize, yBuffer.position() - image.getWidth() + yPlane.getRowStride()));
        }
        int chromaHeight = image.getHeight() / 2;
        int chromaWidth = image.getWidth() / 2;
        int vRowStride = vPlane.getRowStride();
        int uRowStride = uPlane.getRowStride();
        int vPixelStride = vPlane.getPixelStride();
        int uPixelStride = uPlane.getPixelStride();
        byte[] vLineBuffer = new byte[vRowStride];
        byte[] uLineBuffer = new byte[uRowStride];
        for (int row = 0; row < chromaHeight; ++row) {
            vBuffer.get(vLineBuffer, 0, Math.min(vRowStride, vBuffer.remaining()));
            uBuffer.get(uLineBuffer, 0, Math.min(uRowStride, uBuffer.remaining()));
            int vLineBufferPosition = 0;
            int uLineBufferPosition = 0;
            for (int col = 0; col < chromaWidth; ++col) {
                nv21[position++] = vLineBuffer[vLineBufferPosition];
                nv21[position++] = uLineBuffer[uLineBufferPosition];
                vLineBufferPosition += vPixelStride;
                uLineBufferPosition += uPixelStride;
            }
        }
        return nv21;
    }

    private static boolean isCropAspectRatioHasEffect(Size sourceSize, Rational aspectRatio) {
        int denominator;
        int numerator;
        int sourceWidth = sourceSize.getWidth();
        int sourceHeight = sourceSize.getHeight();
        return sourceHeight != Math.round((float)sourceWidth / (float)(numerator = aspectRatio.getNumerator()) * (float)(denominator = aspectRatio.getDenominator())) || sourceWidth != Math.round((float)sourceHeight / (float)denominator * (float)numerator);
    }

    private static Rational inverseRational(Rational rational) {
        if (rational == null) {
            return rational;
        }
        return new Rational(rational.getDenominator(), rational.getNumerator());
    }

    private static boolean shouldCropImage(ImageProxy image) {
        Size sourceSize = new Size(image.getWidth(), image.getHeight());
        Size targetSize = new Size(image.getCropRect().width(), image.getCropRect().height());
        return !targetSize.equals((Object)sourceSize);
    }

    private static byte[] jpegImageToJpegByteArray(ImageProxy image) throws CodecFailedException {
        ImageProxy.PlaneProxy[] planes = image.getPlanes();
        ByteBuffer buffer = planes[0].getBuffer();
        buffer.rewind();
        byte[] data = new byte[buffer.capacity()];
        buffer.get(data);
        if (CameraXImageUtils.shouldCropImage(image)) {
            data = CameraXImageUtils.cropByteArray(data, image.getCropRect());
        }
        return data;
    }

    private static byte[] yuvImageToJpegByteArray(ImageProxy image) throws CodecFailedException {
        return CameraXImageUtils.nv21ToJpeg(CameraXImageUtils.yuv_420_888toNv21(image), image.getWidth(), image.getHeight(), CameraXImageUtils.shouldCropImage(image) ? image.getCropRect() : null);
    }

    public static final class CodecFailedException
    extends Exception {
        private FailureType mFailureType;

        CodecFailedException(String message) {
            super(message);
            this.mFailureType = FailureType.UNKNOWN;
        }

        CodecFailedException(String message, FailureType failureType) {
            super(message);
            this.mFailureType = failureType;
        }

        @NonNull
        public FailureType getFailureType() {
            return this.mFailureType;
        }

        public static enum FailureType {
            ENCODE_FAILED,
            DECODE_FAILED,
            UNKNOWN;

        }
    }
}

