/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;

public final class ScaleTypeTransform {
    public static Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NonNull View view, @NonNull View view2, @NonNull Size size) {
        if (view.getWidth() != 0 && view.getHeight() != 0 && view2.getWidth() != 0 && view2.getHeight() != 0 && size.getWidth() != 0 && size.getHeight() != 0) {
            int n;
            int n2;
            View view3 = view2;
            int n3 = ScaleTypeTransform.getRotationDegrees(view3);
            if (ScaleTypeTransform.isNaturalPortrait(view3.getContext(), n3)) {
                Size size2 = size;
                n2 = size2.getHeight();
                n = size2.getWidth();
            } else {
                Size size3 = size;
                n2 = size3.getWidth();
                n = size3.getHeight();
            }
            float f2 = (float)n2 / (float)view2.getWidth();
            float f3 = (float)n / (float)view2.getHeight();
            if (n3 == 0 || n3 == 180) {
                int n4 = n2;
                n2 = n;
                n = n4;
            }
            float f4 = f3;
            float f5 = Math.max((float)view.getWidth() / (float)n, (float)view.getHeight() / (float)n2);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    public static Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NonNull View view, @NonNull View view2, @NonNull Size size) {
        if (view.getWidth() != 0 && view.getHeight() != 0 && view2.getWidth() != 0 && view2.getHeight() != 0 && size.getWidth() != 0 && size.getHeight() != 0) {
            int n;
            int n2;
            View view3 = view2;
            int n3 = ScaleTypeTransform.getRotationDegrees(view3);
            if (ScaleTypeTransform.isNaturalPortrait(view3.getContext(), n3)) {
                Size size2 = size;
                n2 = size2.getHeight();
                n = size2.getWidth();
            } else {
                Size size3 = size;
                n2 = size3.getWidth();
                n = size3.getHeight();
            }
            float f2 = (float)n2 / (float)view2.getWidth();
            float f3 = (float)n / (float)view2.getHeight();
            if (n3 == 0 || n3 == 180) {
                int n4 = n2;
                n2 = n;
                n = n4;
            }
            float f4 = f3;
            float f5 = Math.min((float)view.getWidth() / (float)n, (float)view.getHeight() / (float)n2);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    public static Point getOriginOfCenteredView(@NonNull View view, @NonNull View view2) {
        int n;
        View view3 = view2;
        int n2 = (view3.getWidth() - view.getWidth()) / 2;
        int n3 = n = (view3.getHeight() - view.getHeight()) / 2;
        n = -n2;
        return new Point(n, -n3);
    }

    public static int getRotationDegrees(@NonNull View view) {
        if ((view = (WindowManager)view.getContext().getSystemService("window")) == null) {
            return 0;
        }
        return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(view.getDefaultDisplay().getRotation());
    }

    public static boolean isNaturalPortrait(@NonNull Context context, int n) {
        Point point;
        if ((context = (WindowManager)context.getSystemService("window")) == null) {
            return true;
        }
        context = context.getDefaultDisplay();
        Point point2 = point;
        point2();
        context.getRealSize(point2);
        int n2 = point.x;
        int n3 = point.y;
        return (n == 0 || n == 180) && n2 < n3 || (n == 90 || n == 270) && n2 >= n3;
    }

    public static int rotationDegreesFromSurfaceRotation(int n) {
        switch (n) {
            default: {
                throw new UnsupportedOperationException("Unsupported surface rotation constant: " + n);
            }
            case 3: {
                return 270;
            }
            case 2: {
                return 180;
            }
            case 1: {
                return 90;
            }
            case 0: 
        }
        return 0;
    }
}

