/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.snap;

import android.hardware.Camera;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\t\u001a\u00060\bR\u00020\u00032\n\u0010\u0004\u001a\u00060\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u000f\u001a\u00060\bR\u00020\u00032\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\bR\u00020\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\u0014\u001a\b\u0018\u00010\bR\u00020\u00032\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015JA\u0010\u0018\u001a\b\u0018\u00010\bR\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0017\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u001a2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001cJ#\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\f\u0010\u0004\u001a\b\u0018\u00010\u0002R\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020\r8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010!\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/util/snap/Utils;", "", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "parameters", "", "isFlashSupported", "(Landroid/hardware/Camera$Parameters;)Z", "Landroid/hardware/Camera$Size;", "getLargestPictureSize", "(Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "", "sizes", "", "targetAspect", "getLargestSizeWithAspectRatioMatch", "(Ljava/util/List;D)Landroid/hardware/Camera$Size;", "", "width", "height", "findByWidthAndHeight", "(Landroid/hardware/Camera$Parameters;II)Landroid/hardware/Camera$Size;", "displayOrientation", "closeEnough", "getBestAspectPictureSize", "(IIILandroid/hardware/Camera$Parameters;D)Landroid/hardware/Camera$Size;", "", "enableContinuousFocus", "(Landroid/hardware/Camera$Parameters;)V", "enableAutoFocus", "", "a", "(Landroid/hardware/Camera$Parameters;)Ljava/util/List;", "D", "ASPECT_TOLERANCE", "<init>", "()V", "sdk-base_release"})
public final class Utils {
    private static final double a = 0.1;
    public static final Utils INSTANCE = new Utils();

    @JvmStatic
    public static final boolean isFlashSupported(@Nullable Camera.Parameters object) {
        if (object == null) {
            return false;
        }
        return (object = object.getSupportedFlashModes()) != null && !object.isEmpty() && (object.size() != 1 || !Intrinsics.areEqual((Object)((String)object.get(0)), (Object)"off"));
    }

    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestPictureSize(@NotNull Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        parameters = null;
        for (Camera.Size size : parameters2.getSupportedPictureSizes()) {
            int n;
            if (parameters != null && size.width * size.height <= (n = parameters.width * parameters.height)) {
                size = parameters;
            }
            parameters = size;
        }
        Camera.Parameters parameters3 = parameters;
        Intrinsics.checkNotNull((Object)parameters3);
        return parameters3;
    }

    @JvmStatic
    @NotNull
    public static final Camera.Size getLargestSizeWithAspectRatioMatch(@NotNull List<? extends Camera.Size> object, double d2) {
        ArrayList<Camera.Size> arrayList;
        a a2;
        Object object2 = object;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"sizes");
        object = a2;
        a2 = new a();
        ArrayList<Camera.Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Camera.Size>();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Camera.Size size;
            Camera.Size size2 = (Camera.Size)iterator.next();
            if (!(Math.abs(d2 - (double)size.width / (double)size2.height) < 0.1)) continue;
            arrayList2.add(size2);
        }
        Object e2 = Collections.max(arrayList2, object);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"Collections.max(matchedPictureSizes, comparator)");
        return (Camera.Size)e2;
    }

    @JvmStatic
    @Nullable
    public static final Camera.Size findByWidthAndHeight(@NotNull Camera.Parameters object, int n, int n2) {
        Camera.Parameters parameters = object;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            if (size.width != n || size.height != n2) continue;
            return size;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Camera.Size getBestAspectPictureSize(int n, int n2, int n3, @NotNull Camera.Parameters parameters, double d2) {
        Camera.Size size3;
        block5: {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            double d3 = n2;
            double d4 = n3;
            double d5 = d3 / d4;
            Camera.Size size2 = null;
            double d6 = Double.MAX_VALUE;
            if (n == 90 || n == 270) {
                d5 = d4 / d3;
            }
            List list = parameters.getSupportedPictureSizes();
            Collections.sort(list, Collections.reverseOrder(new a()));
            for (Camera.Size size3 : list) {
                double d7;
                double d8 = (double)size3.width / (double)size3.height - d5;
                if (Math.abs(d7) < d6) {
                    d6 = Math.abs(d8);
                } else {
                    size3 = size2;
                }
                if (!(d6 < d2)) {
                    size2 = size3;
                    continue;
                }
                break block5;
            }
            size3 = size2;
        }
        return size3;
    }

    @JvmStatic
    public static final void enableContinuousFocus(@Nullable Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        List<String> list = INSTANCE.a(parameters);
        if (list.contains("continuous-picture")) {
            parameters.setFocusMode("continuous-picture");
        } else if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else if (list.contains("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    @JvmStatic
    public static final void enableAutoFocus(@Nullable Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (INSTANCE.a(parameters).contains("auto") && Intrinsics.areEqual((Object)parameters.getFocusMode(), (Object)"auto") ^ true) {
            parameters.setFocusMode("auto");
        }
    }

    private final List<String> a(Camera.Parameters parameters) {
        if (parameters == null) {
            return CollectionsKt.emptyList();
        }
        Object object = parameters.getSupportedFocusModes();
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private Utils() {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0007\u001a\u00020\u00062\n\u0010\u0004\u001a\u00060\u0002R\u00020\u00032\n\u0010\u0005\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"io/scanbot/sdk/util/snap/Utils$a", "Ljava/util/Comparator;", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "lhs", "rhs", "", "a", "(Landroid/hardware/Camera$Size;Landroid/hardware/Camera$Size;)I", "<init>", "()V", "sdk-base_release"})
    public static final class a
    implements Comparator<Camera.Size> {
        public int a(@NotNull Camera.Size size, @NotNull Camera.Size size2) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"lhs");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"rhs");
            return size.width * size.height - size2.width * size2.height;
        }
    }
}

