/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.thread;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u0016\u0010\u0012\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/util/thread/ExecutionUtils;", "", "", "ensureMainThread", "()V", "Ljava/lang/Runnable;", "runnable", "runOnUIThread", "(Ljava/lang/Runnable;)V", "Landroid/content/Context;", "context", "", "messageRes", "showToast", "(Landroid/content/Context;I)V", "Landroid/os/Handler;", "a", "Landroid/os/Handler;", "MAIN_LOOPER_HANDLER", "<init>", "sdk-base_release"})
public final class ExecutionUtils {
    private static final Handler a;
    public static final ExecutionUtils INSTANCE;

    @JvmStatic
    public static final void ensureMainThread() throws IllegalStateException {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            return;
        }
        throw new IllegalStateException("Method must be called from the main thread".toString());
    }

    @JvmStatic
    public static final void runOnUIThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable.run();
        } else {
            a.post(runnable);
        }
    }

    @JvmStatic
    public static final void showToast(final @Nullable Context context, final int n) {
        ExecutionUtils.runOnUIThread(new Runnable(){

            @Override
            public final void run() {
                Toast.makeText((Context)context, (int)n, (int)1).show();
            }
        });
    }

    private ExecutionUtils() {
    }

    static {
        INSTANCE = new ExecutionUtils();
        a = new Handler(Looper.getMainLooper());
    }
}

