/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import io.scanbot.sdk.camera.CameraHost;
import io.scanbot.sdk.camera.CameraHost$WhenMappings;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fJ\u0018\u0010\u001c\u001a\u00060\u001dR\u00020\t2\n\u0010\u001e\u001a\u00060\u001dR\u00020\tH\u0016J0\u0010\u001f\u001a\u00060\bR\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\n\u0010\u001e\u001a\u00060\u001dR\u00020\tH\u0002J\"\u0010$\u001a\u00060\bR\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&2\n\u0010\u001e\u001a\u00060\u001dR\u00020\tH\u0016J0\u0010'\u001a\u00060\bR\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\n\u0010\u001e\u001a\u00060\u001dR\u00020\tH\u0016J\b\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\tH\u0016J\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fJ \u0010/\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020!H\u0016J\u000e\u00103\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u00104\u001a\u00020\u001a2\f\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tJ\u0014\u00105\u001a\u00020\u001a2\f\u0010\n\u001a\b\u0018\u00010\bR\u00020\tJ\u000e\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0017J\u000e\u00108\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0006J\b\u00109\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/scanbot/sdk/camera/CameraHost;", "Lcom/commonsware/cwac/camera/SimpleCameraHost;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "autoFocusSoundEnabled", "", "defaultPictureSize", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "defaultPreviewSize", "logger", "Lio/scanbot/sdk/util/log/Logger;", "pictureCallbacks", "", "Lio/scanbot/sdk/camera/PictureCallback;", "previewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "getPreviewMode", "()Lio/scanbot/sdk/camera/CameraPreviewMode;", "setPreviewMode", "(Lio/scanbot/sdk/camera/CameraPreviewMode;)V", "shutterListener", "Landroid/hardware/Camera$ShutterCallback;", "shutterSoundEnabled", "addPictureCallback", "", "pictureCallback", "adjustPreviewParameters", "Landroid/hardware/Camera$Parameters;", "parameters", "findPreviewSize", "displayOrientation", "", "width", "height", "getPictureSize", "xact", "Lcom/commonsware/cwac/camera/PictureTransaction;", "getPreviewSize", "getRecordingHint", "Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "getShutterCallback", "onAutoFocus", "success", "camera", "removePictureCallback", "saveImage", "image", "", "imageOrientation", "setAutoFocusSound", "setDefaultPictureSize", "setDefaultPreviewSize", "setShutterCallback", "shutterCallback", "setShutterSound", "useFullBleedPreview", "sdk-base_release"})
public final class CameraHost
extends SimpleCameraHost {
    private final Set<PictureCallback> pictureCallbacks;
    private final Logger logger;
    private Camera.Size defaultPictureSize;
    private Camera.Size defaultPreviewSize;
    private boolean autoFocusSoundEnabled;
    private boolean shutterSoundEnabled;
    private Camera.ShutterCallback shutterListener;
    @NotNull
    private CameraPreviewMode previewMode;

    @NotNull
    public final CameraPreviewMode getPreviewMode() {
        return this.previewMode;
    }

    public final void setPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraPreviewMode), (String)"<set-?>");
        this.previewMode = cameraPreviewMode;
    }

    @NotNull
    public Camera.Parameters adjustPreviewParameters(@NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.logger.logMethod();
        super.adjustPreviewParameters(parameters);
        parameters.setPreviewFormat(17);
        return parameters;
    }

    @NotNull
    public Camera.Size getPreviewSize(int displayOrientation, int width, int height, @NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.logger.logMethod();
        Camera.Size size = this.defaultPreviewSize;
        if (size == null) {
            size = this.findPreviewSize(displayOrientation, width, height, parameters);
        }
        return size;
    }

    public final void setShutterCallback(@NotNull Camera.ShutterCallback shutterCallback) {
        Intrinsics.checkNotNullParameter((Object)shutterCallback, (String)"shutterCallback");
        this.shutterListener = shutterCallback;
    }

    @Nullable
    public Camera.ShutterCallback getShutterCallback() {
        return this.shutterSoundEnabled ? this.shutterListener : null;
    }

    private final Camera.Size findPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        this.logger.logMethod();
        Camera.Size pictureSize = Utils.getLargestPictureSize(parameters);
        List list = parameters.getSupportedPreviewSizes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameters.supportedPreviewSizes");
        return Utils.getLargestSizeWithAspectRatioMatch(list, (double)pictureSize.width / (double)pictureSize.height);
    }

    @NotNull
    public Camera.Size getPictureSize(@Nullable PictureTransaction xact, @NotNull Camera.Parameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.logger.logMethod();
        Camera.Size size = this.defaultPictureSize;
        if (size == null) {
            size = Utils.getLargestPictureSize(parameters);
        }
        return size;
    }

    public boolean useFullBleedPreview() {
        boolean bl;
        switch (CameraHost$WhenMappings.$EnumSwitchMapping$0[this.previewMode.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(@NotNull PictureTransaction xact, @NotNull byte[] image, int imageOrientation) {
        Intrinsics.checkNotNullParameter((Object)xact, (String)"xact");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.logger.logMethod();
        Set<PictureCallback> set = this.pictureCallbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (PictureCallback callback : this.pictureCallbacks) {
                callback.onPictureTaken(image, imageOrientation);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void onAutoFocus(boolean success, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (this.autoFocusSoundEnabled) {
            super.onAutoFocus(success, camera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        Set<PictureCallback> set = this.pictureCallbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.pictureCallbacks.add(pictureCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        Set<PictureCallback> set = this.pictureCallbacks;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.pictureCallbacks.remove(pictureCallback);
        }
    }

    public final void setDefaultPictureSize(@Nullable Camera.Size defaultPictureSize) {
        this.defaultPictureSize = defaultPictureSize;
    }

    public final void setDefaultPreviewSize(@Nullable Camera.Size defaultPreviewSize) {
        this.defaultPreviewSize = defaultPreviewSize;
    }

    public final void setAutoFocusSound(boolean autoFocusSoundEnabled) {
        this.autoFocusSoundEnabled = autoFocusSoundEnabled;
    }

    public final void setShutterSound(boolean shutterSoundEnabled) {
        this.shutterSoundEnabled = shutterSoundEnabled;
    }

    public CameraHost(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.pictureCallbacks = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.autoFocusSoundEnabled = true;
        this.shutterSoundEnabled = true;
        this.shutterListener = shutterListener.1.INSTANCE;
        this.previewMode = CameraPreviewMode.FILL_IN;
    }
}

