/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera.autosnapping;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.CallSuper;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.autosnapping.BaseAutoSnappingController;
import io.scanbot.sdk.camera.autosnapping.CaptureIntervalAutoSnappingPredicate;
import io.scanbot.sdk.camera.autosnapping.IAutoSnappingController;
import io.scanbot.sdk.camera.autosnapping.IAutoSnappingPredicate;
import io.scanbot.sdk.camera.autosnapping.ShakeAutoSnappingPredicate;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000o\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0005*\u0003\u000f\u0012\u0015\b&\u0018\u0000 7*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00017B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010'\u001a\u00020(H&J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0015J\u0015\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00028\u0000H\u0015\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020(2\b\u0010/\u001a\u0004\u0018\u00010\bJ\u000e\u00100\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020(2\u0006\u00102\u001a\u000203J\u0015\u00104\u001a\u00020(2\u0006\u00105\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lio/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController;", "T", "", "Lio/scanbot/sdk/camera/autosnapping/IAutoSnappingController;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "(Lio/scanbot/sdk/ui/camera/IScanbotCameraView;)V", "autoSnappingCallback", "Lio/scanbot/sdk/camera/autosnapping/IAutoSnappingController$Callback;", "autoSnappingRunnable", "Ljava/lang/Runnable;", "basePredicates", "", "Lio/scanbot/sdk/camera/autosnapping/IAutoSnappingPredicate;", "cameraPictureCallback", "io/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraPictureCallback$1", "Lio/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraPictureCallback$1;", "cameraStateCallback", "io/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraStateCallback$1", "Lio/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraStateCallback$1;", "cameraTakePictureCallback", "io/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraTakePictureCallback$1", "Lio/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$cameraTakePictureCallback$1;", "captureIntervalPredicate", "Lio/scanbot/sdk/camera/autosnapping/CaptureIntervalAutoSnappingPredicate;", "forceAutofocusBeforeSnap", "", "isAutosnappingShooting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled", "()Z", "setEnabled", "(Z)V", "isResumed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mainThreadHandler", "Landroid/os/Handler;", "shakePredicate", "Lio/scanbot/sdk/camera/autosnapping/ShakeAutoSnappingPredicate;", "detach", "", "onSignificantMove", "resetPredicates", "runPredicates", "param", "(Ljava/lang/Object;)Z", "setAutoSnappingCallback", "callback", "setForceAutofocusBeforeSnap", "setSensitivity", "sensitivity", "", "trySnap", "parameter", "(Ljava/lang/Object;)V", "Companion", "sdk-base_release"})
public abstract class BaseAutoSnappingController<T>
implements IAutoSnappingController<T> {
    private final Handler mainThreadHandler;
    private final AtomicBoolean isAutosnappingShooting;
    private IAutoSnappingController.Callback autoSnappingCallback;
    private final ShakeAutoSnappingPredicate shakePredicate;
    private final CaptureIntervalAutoSnappingPredicate captureIntervalPredicate;
    private final List<IAutoSnappingPredicate<?>> basePredicates;
    @NotNull
    private final AtomicBoolean isResumed;
    private boolean isEnabled;
    private boolean forceAutofocusBeforeSnap;
    private final Runnable autoSnappingRunnable;
    private final cameraStateCallback.1 cameraStateCallback;
    private final cameraTakePictureCallback.1 cameraTakePictureCallback;
    private final cameraPictureCallback.1 cameraPictureCallback;
    private final IScanbotCameraView cameraView;
    public static final boolean FORCE_AUTOFOCUS_BEFORE_SNAP_DEFAULT = false;
    private static final Companion Companion = new Companion(null);

    @NotNull
    protected final AtomicBoolean isResumed() {
        return this.isResumed;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public final void setForceAutofocusBeforeSnap(boolean forceAutofocusBeforeSnap) {
        this.forceAutofocusBeforeSnap = forceAutofocusBeforeSnap;
    }

    public final void setSensitivity(float sensitivity) {
        this.captureIntervalPredicate.setSensitivity(sensitivity);
    }

    @Override
    public void trySnap(@NotNull T parameter) {
        Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
        if (!this.isAutosnappingShooting.get() && this.runPredicates(parameter)) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autoSnappingRunnable);
            this.resetPredicates();
        }
    }

    @CallSuper
    protected boolean runPredicates(@NotNull T param) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        return IAutoSnappingPredicate.DefaultImpls.verify$default(this.captureIntervalPredicate, null, 1, null) && IAutoSnappingPredicate.DefaultImpls.verify$default(this.shakePredicate, null, 1, null);
    }

    public final void setAutoSnappingCallback(@Nullable IAutoSnappingController.Callback callback) {
        IAutoSnappingController.Callback callback2 = callback;
        if (callback2 == null) {
            callback2 = IAutoSnappingController.Callback.Companion.getNULL();
        }
        this.autoSnappingCallback = callback2;
    }

    public abstract void detach();

    @CallSuper
    protected void resetPredicates() {
        this.captureIntervalPredicate.reset();
    }

    private final void onSignificantMove() {
        if (this.isResumed.get() && this.isAutosnappingShooting.get()) {
            this.cameraView.continuousFocus();
            this.mainThreadHandler.removeCallbacksAndMessages(null);
            this.isAutosnappingShooting.set(false);
        }
    }

    public BaseAutoSnappingController(@NotNull IScanbotCameraView cameraView) {
        Intrinsics.checkNotNullParameter((Object)cameraView, (String)"cameraView");
        this.cameraView = cameraView;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = IAutoSnappingController.Callback.Companion.getNULL();
        IScanbotCameraView iScanbotCameraView = this.cameraView;
        if (iScanbotCameraView == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        Context context = ((View)iScanbotCameraView).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"(cameraView as View).context");
        this.shakePredicate = new ShakeAutoSnappingPredicate(context, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BaseAutoSnappingController this$0;

            public final void invoke() {
                BaseAutoSnappingController.access$onSignificantMove(this.this$0);
            }
            {
                this.this$0 = baseAutoSnappingController;
                super(0);
            }
        }));
        this.captureIntervalPredicate = new CaptureIntervalAutoSnappingPredicate();
        this.basePredicates = CollectionsKt.listOf((Object[])new IAutoSnappingPredicate[]{this.shakePredicate, this.captureIntervalPredicate});
        this.isResumed = new AtomicBoolean(false);
        this.isEnabled = true;
        this.autoSnappingRunnable = new Runnable(this){
            final /* synthetic */ BaseAutoSnappingController this$0;

            public final void run() {
                if (this.this$0.isEnabled()) {
                    if (!BaseAutoSnappingController.access$getAutoSnappingCallback$p(this.this$0).onAutoSnapping()) {
                        boolean acquireFocus = BaseAutoSnappingController.access$getForceAutofocusBeforeSnap$p(this.this$0) || Build.VERSION.SDK_INT < 24;
                        BaseAutoSnappingController.access$getCameraView$p(this.this$0).takePicture(acquireFocus);
                    }
                } else {
                    BaseAutoSnappingController.access$isAutosnappingShooting$p(this.this$0).set(false);
                }
            }
            {
                this.this$0 = baseAutoSnappingController;
            }
        };
        this.cameraStateCallback = new CameraStateCallback(this){
            final /* synthetic */ BaseAutoSnappingController this$0;

            public void onResume() {
                this.this$0.isResumed().set(true);
                BaseAutoSnappingController.access$getShakePredicate$p(this.this$0).onResume();
            }

            public void onPause() {
                this.this$0.isResumed().set(false);
                BaseAutoSnappingController.access$isAutosnappingShooting$p(this.this$0).set(false);
                BaseAutoSnappingController.access$getShakePredicate$p(this.this$0).onPause();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.cameraTakePictureCallback = new CameraTakePictureCallback(this){
            final /* synthetic */ BaseAutoSnappingController this$0;

            public void onTakePictureRequested() {
            }

            public void onTakePictureCancelled() {
                BaseAutoSnappingController.access$getMainThreadHandler$p(this.this$0).removeCallbacksAndMessages(null);
                BaseAutoSnappingController.access$isAutosnappingShooting$p(this.this$0).set(false);
                this.this$0.resetPredicates();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.cameraPictureCallback = new PictureCallback(this){
            final /* synthetic */ BaseAutoSnappingController this$0;

            public void onPictureTaken(@NotNull byte[] image, int imageOrientation) {
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                BaseAutoSnappingController.access$getMainThreadHandler$p(this.this$0).removeCallbacksAndMessages(null);
                BaseAutoSnappingController.access$isAutosnappingShooting$p(this.this$0).set(false);
                this.this$0.resetPredicates();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.cameraView.addPictureCallback(this.cameraPictureCallback);
        this.cameraView.addCameraStateCallback(this.cameraStateCallback);
        this.cameraView.addTakePictureCallback(this.cameraTakePictureCallback);
    }

    public static final /* synthetic */ void access$onSignificantMove(BaseAutoSnappingController $this) {
        $this.onSignificantMove();
    }

    public static final /* synthetic */ IAutoSnappingController.Callback access$getAutoSnappingCallback$p(BaseAutoSnappingController $this) {
        return $this.autoSnappingCallback;
    }

    public static final /* synthetic */ void access$setAutoSnappingCallback$p(BaseAutoSnappingController $this, IAutoSnappingController.Callback callback) {
        $this.autoSnappingCallback = callback;
    }

    public static final /* synthetic */ boolean access$getForceAutofocusBeforeSnap$p(BaseAutoSnappingController $this) {
        return $this.forceAutofocusBeforeSnap;
    }

    public static final /* synthetic */ void access$setForceAutofocusBeforeSnap$p(BaseAutoSnappingController $this, boolean bl) {
        $this.forceAutofocusBeforeSnap = bl;
    }

    public static final /* synthetic */ IScanbotCameraView access$getCameraView$p(BaseAutoSnappingController $this) {
        return $this.cameraView;
    }

    public static final /* synthetic */ AtomicBoolean access$isAutosnappingShooting$p(BaseAutoSnappingController $this) {
        return $this.isAutosnappingShooting;
    }

    public static final /* synthetic */ ShakeAutoSnappingPredicate access$getShakePredicate$p(BaseAutoSnappingController $this) {
        return $this.shakePredicate;
    }

    public static final /* synthetic */ Handler access$getMainThreadHandler$p(BaseAutoSnappingController $this) {
        return $this.mainThreadHandler;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/camera/autosnapping/BaseAutoSnappingController$Companion;", "", "()V", "FORCE_AUTOFOCUS_BEFORE_SNAP_DEFAULT", "", "sdk-base_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

