/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;

public final class ScaleTypeTransform {
    public static Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NonNull View container, @NonNull View view, @NonNull Size bufferSize) {
        int bufferRotatedHeight;
        int bufferRotatedWidth;
        int bufferHeight;
        int bufferWidth;
        if (container.getWidth() == 0 || container.getHeight() == 0 || view.getWidth() == 0 || view.getHeight() == 0 || bufferSize.getWidth() == 0 || bufferSize.getHeight() == 0) {
            return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        }
        int viewRotationDegrees = ScaleTypeTransform.getRotationDegrees(view);
        boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(view.getContext(), viewRotationDegrees);
        if (isNaturalPortrait) {
            bufferWidth = bufferSize.getHeight();
            bufferHeight = bufferSize.getWidth();
        } else {
            bufferWidth = bufferSize.getWidth();
            bufferHeight = bufferSize.getHeight();
        }
        float scaleX = (float)bufferWidth / (float)view.getWidth();
        float scaleY = (float)bufferHeight / (float)view.getHeight();
        if (viewRotationDegrees == 0 || viewRotationDegrees == 180) {
            bufferRotatedWidth = bufferWidth;
            bufferRotatedHeight = bufferHeight;
        } else {
            bufferRotatedWidth = bufferHeight;
            bufferRotatedHeight = bufferWidth;
        }
        float scale = Math.max((float)container.getWidth() / (float)bufferRotatedWidth, (float)container.getHeight() / (float)bufferRotatedHeight);
        return new Pair((Object)Float.valueOf(scaleX *= scale), (Object)Float.valueOf(scaleY *= scale));
    }

    public static Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NonNull View container, @NonNull View view, @NonNull Size bufferSize) {
        int bufferRotatedHeight;
        int bufferRotatedWidth;
        int bufferHeight;
        int bufferWidth;
        if (container.getWidth() == 0 || container.getHeight() == 0 || view.getWidth() == 0 || view.getHeight() == 0 || bufferSize.getWidth() == 0 || bufferSize.getHeight() == 0) {
            return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
        }
        int viewRotationDegrees = ScaleTypeTransform.getRotationDegrees(view);
        boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(view.getContext(), viewRotationDegrees);
        if (isNaturalPortrait) {
            bufferWidth = bufferSize.getHeight();
            bufferHeight = bufferSize.getWidth();
        } else {
            bufferWidth = bufferSize.getWidth();
            bufferHeight = bufferSize.getHeight();
        }
        float scaleX = (float)bufferWidth / (float)view.getWidth();
        float scaleY = (float)bufferHeight / (float)view.getHeight();
        if (viewRotationDegrees == 0 || viewRotationDegrees == 180) {
            bufferRotatedWidth = bufferWidth;
            bufferRotatedHeight = bufferHeight;
        } else {
            bufferRotatedWidth = bufferHeight;
            bufferRotatedHeight = bufferWidth;
        }
        float scale = Math.min((float)container.getWidth() / (float)bufferRotatedWidth, (float)container.getHeight() / (float)bufferRotatedHeight);
        return new Pair((Object)Float.valueOf(scaleX *= scale), (Object)Float.valueOf(scaleY *= scale));
    }

    public static Point getOriginOfCenteredView(@NonNull View container, @NonNull View view) {
        int offsetX = (view.getWidth() - container.getWidth()) / 2;
        int offsetY = (view.getHeight() - container.getHeight()) / 2;
        return new Point(-offsetX, -offsetY);
    }

    public static int getRotationDegrees(@NonNull View view) {
        WindowManager windowManager = (WindowManager)view.getContext().getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        int rotation = windowManager.getDefaultDisplay().getRotation();
        return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(rotation);
    }

    public static boolean isNaturalPortrait(@NonNull Context context, int rotationDegrees) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return true;
        }
        Display display = windowManager.getDefaultDisplay();
        Point deviceSize = new Point();
        display.getRealSize(deviceSize);
        int width = deviceSize.x;
        int height = deviceSize.y;
        return (rotationDegrees == 0 || rotationDegrees == 180) && width < height || (rotationDegrees == 90 || rotationDegrees == 270) && width >= height;
    }

    public static int rotationDegreesFromSurfaceRotation(int rotationConstant) {
        switch (rotationConstant) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        throw new UnsupportedOperationException("Unsupported surface rotation constant: " + rotationConstant);
    }
}

