/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.LayoutTransition;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.IFinderView;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000bH\u0004J\u0010\u00107\u001a\u0002052\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0004J\b\u0010;\u001a\u000205H\u0002J0\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bH\u0014J \u0010C\u001a\u0002052\u0006\u0010D\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020\u0017H\u0016J\u000e\u0010G\u001a\u0002052\u0006\u0010H\u001a\u00020\u000bJ\u000e\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020\u000bJ\b\u0010K\u001a\u000205H\u0014J\u000e\u0010L\u001a\u0002052\u0006\u0010)\u001a\u00020\u000bJ\u0014\u0010M\u001a\u0002052\f\u0010N\u001a\b\u0012\u0004\u0012\u00020,0+J\u0010\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020\tH\u0016J\u0010\u0010Q\u001a\u0002052\u0006\u0010R\u001a\u00020\tH\u0016J\u000e\u0010S\u001a\u0002052\u0006\u00101\u001a\u00020\u000bJ\u000e\u0010T\u001a\u0002052\u0006\u00102\u001a\u00020\u000bJ\u000e\u0010U\u001a\u0002052\u0006\u0010V\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u000e\u0010&\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/camera/IFinderView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cornerRadius", "", "fixedFinderHeightInPx", "", "getFixedFinderHeightInPx", "()I", "setFixedFinderHeightInPx", "(I)V", "fixedFinderWidthInPx", "getFixedFinderWidthInPx", "setFixedFinderWidthInPx", "initialPreviewHeight", "getInitialPreviewHeight", "setInitialPreviewHeight", "initialPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "getInitialPreviewMode", "()Lio/scanbot/sdk/camera/CameraPreviewMode;", "setInitialPreviewMode", "(Lio/scanbot/sdk/camera/CameraPreviewMode;)V", "initialPreviewWidth", "getInitialPreviewWidth", "setInitialPreviewWidth", "innerPaint", "Landroid/graphics/Paint;", "innerRectangle", "Landroid/graphics/RectF;", "minFinderPadding", "getMinFinderPadding", "setMinFinderPadding", "outerPaint", "outerRectangle", "outerXrefPaint", "overlayColor", "requiredAspectRatiosInternal", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "getRequiredAspectRatiosInternal", "()Ljava/util/List;", "setRequiredAspectRatiosInternal", "(Ljava/util/List;)V", "strokeColor", "strokeWidth", "verticalOffset", "adjustDescriptionPosition", "", "paddingTopBottom", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "getRequiredAspectRatios", "initPaintAndRect", "onLayout", "changed", "", "left", "top", "right", "bottom", "setCameraParameters", "previewWidth", "previewHeight", "cameraPreviewMode", "setFixedFinderHeight", "fixedFinderHeight", "setFixedFinderWidth", "fixedFinderWidth", "setInitialFinderViewSize", "setOverlayColor", "setRequiredAspectRatios", "requiredAspectRatios", "setScaleX", "scaleX", "setScaleY", "scaleY", "setStrokeColor", "setStrokeWidth", "setVerticalOffset", "offset", "sdk-base_release"})
public class FinderOverlayView
extends FrameLayout
implements IFinderView {
    private int overlayColor;
    private int strokeColor;
    private float strokeWidth;
    private Paint outerPaint;
    private Paint outerXrefPaint;
    private Paint innerPaint;
    private RectF innerRectangle;
    private RectF outerRectangle;
    private int fixedFinderWidthInPx;
    private int fixedFinderHeightInPx;
    private int verticalOffset;
    private float cornerRadius;
    private int minFinderPadding;
    private int initialPreviewWidth;
    private int initialPreviewHeight;
    @NotNull
    private CameraPreviewMode initialPreviewMode;
    @Nullable
    private List<FinderAspectRatio> requiredAspectRatiosInternal;

    protected final int getFixedFinderWidthInPx() {
        return this.fixedFinderWidthInPx;
    }

    protected final void setFixedFinderWidthInPx(int n) {
        this.fixedFinderWidthInPx = n;
    }

    protected final int getFixedFinderHeightInPx() {
        return this.fixedFinderHeightInPx;
    }

    protected final void setFixedFinderHeightInPx(int n) {
        this.fixedFinderHeightInPx = n;
    }

    protected final int getMinFinderPadding() {
        return this.minFinderPadding;
    }

    protected final void setMinFinderPadding(int n) {
        this.minFinderPadding = n;
    }

    protected final int getInitialPreviewWidth() {
        return this.initialPreviewWidth;
    }

    protected final void setInitialPreviewWidth(int n) {
        this.initialPreviewWidth = n;
    }

    protected final int getInitialPreviewHeight() {
        return this.initialPreviewHeight;
    }

    protected final void setInitialPreviewHeight(int n) {
        this.initialPreviewHeight = n;
    }

    @NotNull
    protected final CameraPreviewMode getInitialPreviewMode() {
        return this.initialPreviewMode;
    }

    protected final void setInitialPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraPreviewMode), (String)"<set-?>");
        this.initialPreviewMode = cameraPreviewMode;
    }

    @Nullable
    protected final List<FinderAspectRatio> getRequiredAspectRatiosInternal() {
        return this.requiredAspectRatiosInternal;
    }

    protected final void setRequiredAspectRatiosInternal(@Nullable List<FinderAspectRatio> list) {
        this.requiredAspectRatiosInternal = list;
    }

    private final void initPaintAndRect() {
        this.innerPaint.setColor(this.strokeColor);
        this.innerPaint.setStyle(Paint.Style.STROKE);
        this.innerPaint.setStrokeJoin(Paint.Join.ROUND);
        this.innerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.innerPaint.setStrokeWidth(this.strokeWidth / this.getScaleX());
        this.outerPaint.setColor(this.overlayColor);
        float strokeOffset = this.strokeWidth / (float)2;
        float finderOffsetLeft = strokeOffset + (float)this.getPaddingLeft();
        float finderOffsetRight = strokeOffset + (float)this.getPaddingRight();
        float finderOffsetTop = strokeOffset + (float)this.getPaddingTop();
        float finderOffsetBottom = strokeOffset + (float)this.getPaddingBottom();
        this.innerRectangle = new RectF(finderOffsetLeft, finderOffsetTop, (float)this.getWidth() - finderOffsetRight, (float)this.getHeight() - finderOffsetBottom);
        this.outerRectangle = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            super.dispatchDraw(canvas);
            if (this.outerRectangle == null || this.innerRectangle == null) {
                this.initPaintAndRect();
            }
            RectF rectF = this.innerRectangle;
            if (rectF == null) break block2;
            RectF rectF2 = rectF;
            boolean bl = false;
            boolean bl2 = false;
            RectF inner = rectF2;
            boolean bl3 = false;
            RectF rectF3 = this.outerRectangle;
            if (rectF3 != null) {
                RectF rectF4 = rectF3;
                boolean bl4 = false;
                boolean bl5 = false;
                RectF outer = rectF4;
                boolean bl6 = false;
                canvas.saveLayer(outer, null);
                canvas.drawRect(outer, this.outerPaint);
                canvas.drawRoundRect(inner, this.cornerRadius / this.getScaleX(), this.cornerRadius / this.getScaleX(), this.outerXrefPaint);
                canvas.restore();
                canvas.drawRoundRect(inner, this.cornerRadius / this.getScaleX(), this.cornerRadius / this.getScaleX(), this.innerPaint);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.outerRectangle = null;
        this.innerRectangle = null;
    }

    @Override
    public void setCameraParameters(int previewWidth, int previewHeight, @NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraPreviewMode), (String)"cameraPreviewMode");
        this.initialPreviewWidth = previewWidth;
        this.initialPreviewHeight = previewHeight;
        this.initialPreviewMode = cameraPreviewMode;
        this.post(new Runnable(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void run() {
                this.this$0.setInitialFinderViewSize();
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
    }

    public final void setOverlayColor(int overlayColor) {
        this.overlayColor = overlayColor;
        this.invalidate();
    }

    public final void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    public final void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public final void setFixedFinderWidth(int fixedFinderWidth) {
        this.fixedFinderWidthInPx = fixedFinderWidth;
        this.invalidate();
    }

    public final void setFixedFinderHeight(int fixedFinderHeight) {
        this.fixedFinderHeightInPx = fixedFinderHeight;
        this.invalidate();
    }

    public final void setVerticalOffset(int offset) {
        this.verticalOffset = offset;
        this.invalidate();
    }

    public final void setRequiredAspectRatios(@NotNull List<FinderAspectRatio> requiredAspectRatios) {
        Intrinsics.checkNotNullParameter(requiredAspectRatios, (String)"requiredAspectRatios");
        this.requiredAspectRatiosInternal = requiredAspectRatios;
        this.post(new Runnable(this){
            final /* synthetic */ FinderOverlayView this$0;

            public final void run() {
                this.this$0.setInitialFinderViewSize();
            }
            {
                this.this$0 = finderOverlayView;
            }
        });
    }

    @Nullable
    protected final List<FinderAspectRatio> getRequiredAspectRatios() {
        return this.requiredAspectRatiosInternal;
    }

    protected void setInitialFinderViewSize() {
        int paddingTopBottom = 0;
        int paddingLeftRight = 0;
        int scaledFrameWidth = 0;
        int scaledFrameHeight = 0;
        if (this.fixedFinderWidthInPx <= 0 || this.fixedFinderHeightInPx <= 0) {
            double finderAspectRatio;
            if (this.initialPreviewMode == CameraPreviewMode.FIT_IN) {
                double frameAspectRatio = this.initialPreviewWidth == 0 || this.initialPreviewHeight == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.initialPreviewWidth / (double)this.initialPreviewHeight;
                double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
                scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
                scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
            } else {
                scaledFrameWidth = this.getMeasuredWidth();
                scaledFrameHeight = this.getMeasuredHeight();
            }
            int finderWidth = scaledFrameWidth - 2 * this.minFinderPadding;
            int finderHeight = scaledFrameHeight - 2 * this.minFinderPadding;
            double targetAspectRatio = finderAspectRatio = (double)finderWidth / (double)finderHeight;
            if (this.requiredAspectRatiosInternal != null) {
                List<FinderAspectRatio> list = this.requiredAspectRatiosInternal;
                Intrinsics.checkNotNull(list);
                Collection collection = list;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    List<FinderAspectRatio> list2 = this.requiredAspectRatiosInternal;
                    Intrinsics.checkNotNull(list2);
                    FinderAspectRatio requiredAspectRatio = list2.get(0);
                    targetAspectRatio = requiredAspectRatio.getWidth() / requiredAspectRatio.getHeight();
                }
            }
            if (targetAspectRatio < finderAspectRatio) {
                double targetWidth = (double)finderHeight * targetAspectRatio;
                paddingTopBottom = this.minFinderPadding + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = (int)(((double)scaledFrameWidth - targetWidth) / (double)2) + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            } else {
                double targetHeight = (double)finderWidth / targetAspectRatio;
                paddingTopBottom = (int)(((double)scaledFrameHeight - targetHeight) / (double)2) + (this.getMeasuredHeight() - scaledFrameHeight) / 2;
                paddingLeftRight = this.minFinderPadding + (this.getMeasuredWidth() - scaledFrameWidth) / 2;
            }
        } else {
            paddingTopBottom = (this.getMeasuredHeight() - this.fixedFinderHeightInPx) / 2;
            paddingLeftRight = (this.getMeasuredWidth() - this.fixedFinderWidthInPx) / 2;
        }
        this.setPadding(paddingLeftRight, paddingTopBottom + this.verticalOffset, paddingLeftRight, paddingTopBottom - this.verticalOffset);
        this.adjustDescriptionPosition(paddingTopBottom);
        this.invalidate();
    }

    protected final void adjustDescriptionPosition(int paddingTopBottom) {
        block2: {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            if (viewGroup == null || (viewGroup = viewGroup.findViewById(R.id.finder_description)) == null) break block2;
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            int n = paddingTopBottom - it.getMeasuredHeight();
            ViewGroup $this$marginTop$iv = it;
            boolean $i$f$getMarginTop = false;
            ViewGroup.LayoutParams layoutParams = $this$marginTop$iv.getLayoutParams();
            if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
                layoutParams = null;
            }
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
            int marginBottom = n - (marginLayoutParams != null ? marginLayoutParams.topMargin : 0) - this.verticalOffset;
            ViewGroup.LayoutParams layoutParams2 = it.getLayoutParams();
            if (layoutParams2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)layoutParams2;
            param.setMargins(param.leftMargin, param.topMargin, param.rightMargin, marginBottom);
            it.setLayoutParams((ViewGroup.LayoutParams)param);
            it.invalidate();
        }
    }

    public void setScaleX(float scaleX) {
        super.setScaleX(scaleX);
        this.initPaintAndRect();
        this.invalidate();
    }

    public void setScaleY(float scaleY) {
        super.setScaleY(scaleY);
        this.initPaintAndRect();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr);
        this.overlayColor = -1;
        this.strokeColor = -1;
        this.strokeWidth = -1.0f;
        this.outerPaint = new Paint(1);
        this.outerXrefPaint = new Paint(1);
        this.innerPaint = new Paint(1);
        this.fixedFinderWidthInPx = -1;
        this.fixedFinderHeightInPx = -1;
        this.initialPreviewMode = CameraPreviewMode.FILL_IN;
        Context context2 = context;
        boolean bl = false;
        boolean bl2 = false;
        Context it = context2;
        boolean bl3 = false;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attr, R.styleable.FinderOverlayView, 0, 0);
        try {
            int n = typedArray.getColor(R.styleable.FinderOverlayView_overlay_color, -1);
            boolean bl4 = false;
            boolean bl5 = false;
            int it2 = n;
            boolean bl6 = false;
            this.overlayColor = it2 != -1 ? it2 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_color);
            n = typedArray.getColor(R.styleable.FinderOverlayView_overlay_stroke_color, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl7 = false;
            this.strokeColor = it2 != -1 ? it2 : ContextCompat.getColor((Context)context, (int)R.color.default_finder_overlay_stroke_color);
            n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_stroke_width, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl8 = false;
            this.strokeWidth = it2 != -1 ? (float)it2 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_stroke_width);
            n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_corner_radius, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl9 = false;
            this.cornerRadius = it2 != -1 ? (float)it2 : (float)this.getResources().getDimensionPixelSize(R.dimen.default_finder_corner_radius);
            n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_min_padding, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl10 = false;
            this.minFinderPadding = it2 != -1 ? it2 : this.getResources().getDimensionPixelSize(R.dimen.default_min_finder_padding);
            n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_width, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl11 = false;
            this.fixedFinderWidthInPx = it2 != -1 ? it2 : this.fixedFinderWidthInPx;
            n = typedArray.getDimensionPixelSize(R.styleable.FinderOverlayView_fixed_height, -1);
            bl4 = false;
            bl5 = false;
            it2 = n;
            boolean bl12 = false;
            this.fixedFinderHeightInPx = it2 != -1 ? it2 : this.fixedFinderHeightInPx;
        }
        finally {
            typedArray.recycle();
        }
        LayoutTransition layoutTransition = new LayoutTransition();
        layoutTransition.enableTransitionType(4);
        this.setLayoutTransition(layoutTransition);
        this.outerXrefPaint.setColor(0);
        this.outerXrefPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
    }
}

