/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.display.DisplayManager;
import android.media.ImageReader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewGroupKt;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.common.util.concurrent.ListenableFuture;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.base.R;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.IFinderView;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.SnapFlashView;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.JPEGImageSaver;
import io.scanbot.sdk.ui.camera.PreviewViewMeteringPointFactory;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView$WhenMappings;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView$bindCameraUseCases$1$2$$special$;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView$tryTakePicture$;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import io.scanbot.sdk.ui.camera.util.PreviewImageUtil;
import io.scanbot.sdk.ui.camera.util.ScaleTypeTransform;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b*\u0001#\u0018\u0000 \u009d\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\b\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020EH\u0016J\u0010\u0010Y\u001a\u00020W2\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020W2\u0006\u0010]\u001a\u00020<H\u0016J\u0010\u0010^\u001a\u00020W2\u0006\u0010_\u001a\u00020QH\u0016J\u0012\u0010`\u001a\u00020W2\b\u0010a\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010b\u001a\u00020W2\b\u0010a\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010c\u001a\u00020WH\u0016J\b\u0010d\u001a\u00020WH\u0003J\"\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020!2\u0006\u0010h\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0002J\"\u0010i\u001a\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020!2\u0006\u0010h\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010j\u001a\u00020WH\u0016J \u0010k\u001a\u00020W2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020m2\u0006\u0010a\u001a\u00020\u0018H\u0002J\u0010\u0010o\u001a\u00020W2\u0006\u0010p\u001a\u00020qH\u0014J'\u0010r\u001a\u0004\u0018\u0001Hs\"\b\b\u0000\u0010s*\u00020[2\f\u0010t\u001a\b\u0012\u0004\u0012\u0002Hs0uH\u0016\u00a2\u0006\u0002\u0010vJ\u0010\u0010w\u001a\u00020x2\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010y\u001a\u00020WH\u0002J\u0010\u0010z\u001a\u00020W2\u0006\u0010{\u001a\u00020\rH\u0017J\u0010\u0010|\u001a\u00020W2\u0006\u0010{\u001a\u00020\rH\u0017J\u0010\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020~H\u0002J\t\u0010\u0080\u0001\u001a\u00020WH\u0002J\t\u0010\u0081\u0001\u001a\u00020WH\u0014J\t\u0010\u0082\u0001\u001a\u00020WH\u0014J\u0011\u0010\u0083\u0001\u001a\u00020W2\u0006\u0010X\u001a\u00020EH\u0016J\u0011\u0010\u0084\u0001\u001a\u00020W2\u0006\u0010Z\u001a\u00020[H\u0016J\u0011\u0010\u0085\u0001\u001a\u00020W2\u0006\u0010]\u001a\u00020<H\u0016J\u0011\u0010\u0086\u0001\u001a\u00020W2\u0006\u0010_\u001a\u00020QH\u0016J\u0011\u0010\u0087\u0001\u001a\u00020W2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0011\u0010\u0088\u0001\u001a\u00020W2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0089\u0001\u001a\u00020W2\u0007\u0010\u008a\u0001\u001a\u00020\u0018J\u0011\u0010\u008b\u0001\u001a\u00020W2\u0006\u0010=\u001a\u00020>H\u0016J\u000f\u0010\u008c\u0001\u001a\u00020W2\u0006\u0010a\u001a\u00020\u0018J\u0012\u0010\u008d\u0001\u001a\u00020W2\u0007\u0010\u008e\u0001\u001a\u00020~H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020W2\u0007\u0010\u0090\u0001\u001a\u00020\rH\u0016J\u0015\u0010\u0091\u0001\u001a\u00020W2\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0002J\t\u0010\u0094\u0001\u001a\u00020WH\u0002J\t\u0010\u0095\u0001\u001a\u00020WH\u0016J\u0013\u0010\u0096\u0001\u001a\u00020W2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002J\u0012\u0010\u0099\u0001\u001a\u00020W2\u0007\u0010\u009a\u0001\u001a\u00020\rH\u0002J\u0012\u0010\u009b\u0001\u001a\u00020W2\u0007\u0010\u009b\u0001\u001a\u00020\rH\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u000e\u0010+\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u000609R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020E0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00180GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\"\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00180GX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bN\u0010I\"\u0004\bO\u0010KR\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u0004\u0018\u00010UX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lio/scanbot/sdk/ui/camera/ScanbotCameraXView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "analyzerExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "autoFocusOnTouch", "", "camera", "Landroidx/camera/core/Camera;", "cameraExecutor", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "cameraOpenCallback", "Lio/scanbot/sdk/camera/CameraOpenCallback;", "compoundImageAnalyzer", "Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$CompoundAnalyzer;", "customPictureSize", "Landroid/util/Size;", "customPreviewSize", "delayAfterFocusCompleteMs", "", "getDelayAfterFocusCompleteMs", "()J", "setDelayAfterFocusCompleteMs", "(J)V", "displayId", "", "displayListener", "io/scanbot/sdk/ui/camera/ScanbotCameraXView$displayListener$1", "Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$displayListener$1;", "displayManager", "Landroid/hardware/display/DisplayManager;", "getDisplayManager", "()Landroid/hardware/display/DisplayManager;", "displayManager$delegate", "Lkotlin/Lazy;", "finderInnerThresholdPx", "finderOuterThresholdPx", "imageAnalyzer", "Landroidx/camera/core/ImageAnalysis;", "imageCapture", "Landroidx/camera/core/ImageCapture;", "isOrientationHardLocked", "isOrientationLocked", "lensFacing", "logger", "Lio/scanbot/sdk/util/log/Logger;", "meteringPointFactory", "Lio/scanbot/sdk/ui/camera/PreviewViewMeteringPointFactory;", "onOrientationChangeListener", "Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$OnOrientationChange;", "pictureCallbacks", "", "Lio/scanbot/sdk/camera/PictureCallback;", "previewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "previewView", "Landroidx/camera/view/PreviewView;", "resolution", "snapAnimationView", "Lio/scanbot/sdk/camera/SnapFlashView;", "stateCallbacks", "Lio/scanbot/sdk/camera/CameraStateCallback;", "supportedPictureSizes", "", "getSupportedPictureSizes", "()[Landroid/util/Size;", "setSupportedPictureSizes", "([Landroid/util/Size;)V", "[Landroid/util/Size;", "supportedPreviewSizes", "getSupportedPreviewSizes", "setSupportedPreviewSizes", "takePictureCallbacks", "Lio/scanbot/sdk/camera/CameraTakePictureCallback;", "touchFocusPaint", "Landroid/graphics/Paint;", "touchRect", "Landroid/graphics/Rect;", "addCameraStateCallback", "", "cameraStateCallback", "addFrameHandler", "frameHandler", "Lio/scanbot/sdk/camera/FrameHandler;", "addPictureCallback", "pictureCallback", "addTakePictureCallback", "cameraTakePictureCallback", "adjustFinderView", "previewSize", "adjustPolygonView", "autoFocus", "bindCameraUseCases", "calculateFinderRectF", "Landroid/graphics/RectF;", "previewWidth", "previewHeight", "calculateVisibleRectF", "continuousFocus", "correctPolygonViewForPreviewMode", "container", "Landroid/view/View;", "polygonView", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "getAttachedFrameHandler", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lio/scanbot/sdk/camera/FrameHandler;", "getScaleType", "Landroidx/camera/view/PreviewView$ScaleType;", "initSupportedPreviewPictureSizes", "lockToLandscape", "lockPicture", "lockToPortrait", "normalizeF", "", "rectCoordinates", "notifyTakePictureCancelled", "onAttachedToWindow", "onDetachedFromWindow", "removeCameraStateCallback", "removeFrameHandler", "removePictureCallback", "removeTakePictureCallback", "setAutoFocusOnTouch", "setCameraOpenCallback", "setPictureSize", "pictureSize", "setPreviewMode", "setPreviewSize", "setUiZoomLevel", "zoomLevel", "takePicture", "acquireFocus", "tryAutoFocus", "autofocusCallback", "Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$AutofocusCallback;", "tryTakePicture", "unlockOrientation", "updateAutoFocusTouchRect", "event", "Landroid/view/MotionEvent;", "updateTouchRect", "success", "useFlash", "AutofocusCallback", "Companion", "CompoundAnalyzer", "OnOrientationChange", "sdk-base_release"})
public final class ScanbotCameraXView
extends ConstraintLayout
implements IScanbotCameraView,
UiZoomDelegate {
    @NotNull
    private Size[] supportedPreviewSizes;
    @NotNull
    private Size[] supportedPictureSizes;
    private Size customPreviewSize;
    private Size customPictureSize;
    private final Logger logger;
    private final PreviewView previewView;
    private final CameraManager cameraManager;
    private boolean autoFocusOnTouch;
    private Paint touchFocusPaint;
    private Rect touchRect;
    private Size resolution;
    private PreviewViewMeteringPointFactory meteringPointFactory;
    private int displayId;
    private int lensFacing;
    private ImageCapture imageCapture;
    private ImageAnalysis imageAnalyzer;
    private final CompoundAnalyzer compoundImageAnalyzer;
    private Camera camera;
    private final Set<CameraStateCallback> stateCallbacks;
    private final Set<PictureCallback> pictureCallbacks;
    private final Set<CameraTakePictureCallback> takePictureCallbacks;
    private CameraOpenCallback cameraOpenCallback;
    private CameraPreviewMode previewMode;
    private boolean isOrientationLocked;
    private boolean isOrientationHardLocked;
    private int finderInnerThresholdPx;
    private int finderOuterThresholdPx;
    private long delayAfterFocusCompleteMs;
    private final Lazy displayManager$delegate;
    private SnapFlashView snapAnimationView;
    private final ExecutorService cameraExecutor;
    private final ExecutorService analyzerExecutor;
    private final displayListener.1 displayListener;
    private final OnOrientationChange onOrientationChangeListener;
    private static final String TAG = "ScanbotCameraXView";
    private static final int DELAY_HIDE_TOUCH_FOCUS_MS = 1000;
    private static final int DEFAULT_FOCUS_AREA_SIZE = 75;
    private static final long DEFAULT_FOCUS_DURATION = 5L;
    private static final int[] ROTATION_DEGREES;
    public static final Companion Companion;

    @NotNull
    public final Size[] getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    public final void setSupportedPreviewSizes(@NotNull Size[] sizeArray) {
        Intrinsics.checkNotNullParameter((Object)sizeArray, (String)"<set-?>");
        this.supportedPreviewSizes = sizeArray;
    }

    @NotNull
    public final Size[] getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public final void setSupportedPictureSizes(@NotNull Size[] sizeArray) {
        Intrinsics.checkNotNullParameter((Object)sizeArray, (String)"<set-?>");
        this.supportedPictureSizes = sizeArray;
    }

    @Override
    public long getDelayAfterFocusCompleteMs() {
        return this.delayAfterFocusCompleteMs;
    }

    @Override
    public void setDelayAfterFocusCompleteMs(long l) {
        this.delayAfterFocusCompleteMs = l;
    }

    private final DisplayManager getDisplayManager() {
        Lazy lazy = this.displayManager$delegate;
        ScanbotCameraXView scanbotCameraXView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DisplayManager)lazy.getValue();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onOrientationChangeListener.resetOrientation();
        this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this.displayListener, null);
        this.post(new Runnable(this){
            final /* synthetic */ ScanbotCameraXView this$0;

            public final void run() {
                if (ScanbotCameraXView.access$getPreviewView$p(this.this$0).getDisplay() != null) {
                    PreviewView.ScaleType scaleType;
                    Display display = ScanbotCameraXView.access$getPreviewView$p(this.this$0).getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"previewView.display");
                    ScanbotCameraXView.access$setDisplayId$p(this.this$0, display.getDisplayId());
                    PreviewView previewView = ScanbotCameraXView.access$getPreviewView$p(this.this$0);
                    switch (ScanbotCameraXView$WhenMappings.$EnumSwitchMapping$0[ScanbotCameraXView.access$getPreviewMode$p(this.this$0).ordinal()]) {
                        case 1: {
                            scaleType = PreviewView.ScaleType.FIT_CENTER;
                            break;
                        }
                        case 2: {
                            scaleType = PreviewView.ScaleType.FILL_CENTER;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    previewView.setScaleType(scaleType);
                    ScanbotCameraXView.access$bindCameraUseCases(this.this$0);
                }
            }
            {
                this.this$0 = scanbotCameraXView;
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SnapFlashView snapFlashView = this.snapAnimationView;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        snapFlashView.cancel();
        this.cameraExecutor.shutdown();
        this.analyzerExecutor.shutdown();
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this.displayListener);
        this.onOrientationChangeListener.disable();
    }

    @Override
    @Nullable
    public <T extends FrameHandler> T getAttachedFrameHandler(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.logger.logMethod();
        return this.compoundImageAnalyzer.getAttachedFrameHandler(clazz);
    }

    @Override
    public void addFrameHandler(@NotNull FrameHandler frameHandler) {
        Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
        this.compoundImageAnalyzer.addFrameHandler(frameHandler);
    }

    @Override
    public void removeFrameHandler(@NotNull FrameHandler frameHandler) {
        Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
        this.compoundImageAnalyzer.removeFrameHandler(frameHandler);
    }

    @Override
    public void setPreviewMode(@NotNull CameraPreviewMode previewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)previewMode), (String)"previewMode");
        this.previewMode = previewMode;
    }

    @Override
    public void takePicture(boolean acquireFocus) {
        this.logger.logMethod();
        if (!SapSingleton.getInstance().checkLicenseStatus(SdkFeature.NoSdkFeature).booleanValue()) {
            this.notifyTakePictureCancelled();
            return;
        }
        if (acquireFocus) {
            this.tryAutoFocus(new AutofocusCallback(this){
                final /* synthetic */ ScanbotCameraXView this$0;

                public void onAutoFocusCompleted() {
                    ScanbotCameraXView.access$getLogger$p(this.this$0).logMethod();
                    this.this$0.postDelayed(new Runnable(this){
                        final /* synthetic */ takePicture.1 this$0;

                        public final void run() {
                            ScanbotCameraXView.access$tryTakePicture(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, this.this$0.getDelayAfterFocusCompleteMs());
                }
                {
                    this.this$0 = this$0;
                }
            });
        } else {
            this.tryTakePicture();
        }
    }

    private final void tryTakePicture() {
        block0: {
            ImageCapture imageCapture = this.imageCapture;
            if (imageCapture == null) break block0;
            ImageCapture imageCapture2 = imageCapture;
            boolean bl = false;
            boolean bl2 = false;
            ImageCapture imageCapture3 = imageCapture2;
            boolean bl3 = false;
            imageCapture3.takePicture((Executor)this.cameraExecutor, new ImageCapture.OnImageCapturedCallback(this){
                final /* synthetic */ ScanbotCameraXView this$0;
                {
                    this.this$0 = scanbotCameraXView;
                }

                public void onCaptureSuccess(@NotNull ImageProxy image) {
                    Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                    ExecutorService executorService = ScanbotCameraXView.access$getCameraExecutor$p(this.this$0);
                    ExecutorService executorService2 = ScanbotCameraXView.access$getCameraExecutor$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"cameraExecutor");
                    executorService.execute(new JPEGImageSaver(image, executorService2, new JPEGImageSaver.OnImageProcessedCallback(this){
                        final /* synthetic */ tryTakePicture$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void onImageSaved(@NotNull byte[] outputImage, int rotationDegrees) {
                            Intrinsics.checkNotNullParameter((Object)outputImage, (String)"outputImage");
                            ScanbotCameraXView.access$getSnapAnimationView$p(this.this$0.this$0).playSelf();
                            Iterable $this$forEach$iv = ScanbotCameraXView.access$getPictureCallbacks$p(this.this$0.this$0);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                PictureCallback it = (PictureCallback)element$iv;
                                boolean bl = false;
                                it.onPictureTaken(outputImage, rotationDegrees);
                            }
                        }

                        public void onError(@Nullable JPEGImageSaver.SaveError saveError, @Nullable String message, @Nullable Throwable cause) {
                            ScanbotCameraXView.access$getLogger$p(this.this$0.this$0).e("ScanbotCameraXView", "Photo capture failed: " + message);
                            ScanbotCameraXView.access$getLogger$p(this.this$0.this$0).logException(cause);
                            ScanbotCameraXView.access$notifyTakePictureCancelled(this.this$0.this$0);
                        }
                    }));
                }

                public void onError(@NotNull ImageCaptureException exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    ScanbotCameraXView.access$getLogger$p(this.this$0).e("ScanbotCameraXView", "Photo capture failed: " + exception.getMessage());
                    ScanbotCameraXView.access$getLogger$p(this.this$0).logException((Throwable)exception);
                    ScanbotCameraXView.access$notifyTakePictureCancelled(this.this$0);
                }
            });
        }
    }

    @Override
    public void addPictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        this.pictureCallbacks.add(pictureCallback);
    }

    @Override
    public void removePictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        this.pictureCallbacks.remove(pictureCallback);
    }

    @Override
    public void setCameraOpenCallback(@NotNull CameraOpenCallback cameraOpenCallback) {
        Intrinsics.checkNotNullParameter((Object)cameraOpenCallback, (String)"cameraOpenCallback");
        this.cameraOpenCallback = cameraOpenCallback;
    }

    @Override
    public void addCameraStateCallback(@NotNull CameraStateCallback cameraStateCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraStateCallback2, (String)"cameraStateCallback");
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback2);
    }

    @Override
    public void removeCameraStateCallback(@NotNull CameraStateCallback cameraStateCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraStateCallback2, (String)"cameraStateCallback");
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback2);
    }

    @Override
    public void addTakePictureCallback(@NotNull CameraTakePictureCallback cameraTakePictureCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraTakePictureCallback2, (String)"cameraTakePictureCallback");
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback2);
    }

    @Override
    public void removeTakePictureCallback(@NotNull CameraTakePictureCallback cameraTakePictureCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraTakePictureCallback2, (String)"cameraTakePictureCallback");
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback2);
    }

    @Override
    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        this.autoFocusOnTouch = autoFocusOnTouch;
    }

    @Override
    public void autoFocus() {
        this.tryAutoFocus(null);
    }

    private final void tryAutoFocus(AutofocusCallback autofocusCallback) {
        block1: {
            ListenableFuture future;
            MeteringPoint point;
            PreviewViewMeteringPointFactory previewViewMeteringPointFactory = this.meteringPointFactory;
            MeteringPoint meteringPoint = point = previewViewMeteringPointFactory != null ? previewViewMeteringPointFactory.createPoint(this.previewView.getMeasuredWidth() / 2, this.previewView.getMeasuredHeight() / 2) : null;
            if (meteringPoint == null) break block1;
            MeteringPoint meteringPoint2 = meteringPoint;
            boolean bl = false;
            boolean bl2 = false;
            MeteringPoint it = meteringPoint2;
            boolean bl3 = false;
            FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, 1).addPoint(point, 2).setAutoCancelDuration(5L, TimeUnit.SECONDS).build();
            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"FocusMeteringAction.Buil\u2026                 .build()");
            FocusMeteringAction action = focusMeteringAction;
            Camera camera = this.camera;
            ListenableFuture listenableFuture = future = camera != null && (camera = camera.getCameraControl()) != null ? camera.startFocusAndMetering(action) : null;
            if (listenableFuture != null) {
                listenableFuture.addListener(new Runnable(future, this, point, autofocusCallback){
                    final /* synthetic */ ListenableFuture $future;
                    final /* synthetic */ ScanbotCameraXView this$0;
                    final /* synthetic */ MeteringPoint $point$inlined;
                    final /* synthetic */ AutofocusCallback $autofocusCallback$inlined;
                    {
                        this.$future = listenableFuture;
                        this.this$0 = scanbotCameraXView;
                        this.$point$inlined = meteringPoint;
                        this.$autofocusCallback$inlined = autofocusCallback;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        try {
                            FocusMeteringResult focusMeteringResult = (FocusMeteringResult)this.$future.get();
                        }
                        catch (Exception e) {
                            ScanbotCameraXView.access$getLogger$p(this.this$0).logException(e);
                        }
                        finally {
                            AutofocusCallback autofocusCallback = this.$autofocusCallback$inlined;
                            if (autofocusCallback != null) {
                                autofocusCallback.onAutoFocusCompleted();
                            }
                        }
                    }
                }, (Executor)this.cameraExecutor);
            }
        }
    }

    @Override
    public void continuousFocus() {
        block0: {
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.cancelFocusAndMetering();
        }
    }

    @Override
    public void useFlash(boolean useFlash) {
        block0: {
            Camera camera = this.camera;
            if (camera == null || (camera = camera.getCameraControl()) == null) break block0;
            camera.enableTorch(useFlash);
        }
    }

    @Override
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void lockToPortrait(boolean lockPicture) {
        if (this.getContext() instanceof Activity) {
            Context context = this.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
            }
            ((Activity)context).setRequestedOrientation(7);
        }
        this.isOrientationLocked = true;
        this.isOrientationHardLocked = lockPicture;
    }

    @Override
    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void lockToLandscape(boolean lockPicture) {
        if (this.getContext() instanceof Activity) {
            Context context = this.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
            }
            ((Activity)context).setRequestedOrientation(6);
        }
        this.isOrientationLocked = true;
        this.isOrientationHardLocked = lockPicture;
    }

    @Override
    public void unlockOrientation() {
        this.isOrientationLocked = false;
        this.isOrientationHardLocked = false;
        if (this.getContext() instanceof Activity) {
            Context context = this.getContext();
            if (context == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
            }
            ((Activity)context).setRequestedOrientation(-1);
        }
        this.onOrientationChangeListener.disable();
    }

    public final void setPictureSize(@NotNull Size pictureSize) {
        Intrinsics.checkNotNullParameter((Object)pictureSize, (String)"pictureSize");
        this.customPictureSize = pictureSize;
    }

    public final void setPreviewSize(@NotNull Size previewSize) {
        Intrinsics.checkNotNullParameter((Object)previewSize, (String)"previewSize");
        this.customPreviewSize = previewSize;
    }

    private final void initSupportedPreviewPictureSizes() {
        block4: {
            Size[] streamConfigurationMap;
            String string;
            boolean bl;
            String[] stringArray;
            block3: {
                String[] stringArray2 = this.cameraManager.getCameraIdList();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"cameraManager.cameraIdList");
                stringArray = stringArray2;
                bl = false;
                String[] stringArray3 = stringArray;
                boolean bl2 = false;
                String[] stringArray4 = stringArray3;
                int n = stringArray4.length;
                for (int i = 0; i < n; ++i) {
                    Integer lensFacing;
                    String string2;
                    String it = string2 = stringArray4[i];
                    boolean bl3 = false;
                    CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(it);
                    Integer n2 = lensFacing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                    int n3 = 1;
                    boolean bl4 = n2 != null && n2 == n3;
                    if (!bl4) continue;
                    string = string2;
                    break block3;
                }
                string = null;
            }
            if (string == null) break block4;
            stringArray = string;
            bl = false;
            boolean bl5 = false;
            String[] it = stringArray;
            boolean bl6 = false;
            CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics((String)it);
            Size[] sizeArray = streamConfigurationMap = (Size[])characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap == null || (sizeArray = sizeArray.getOutputSizes(SurfaceHolder.class)) == null) {
                sizeArray = new Size[]{};
            }
            this.supportedPreviewSizes = sizeArray;
            Size[] sizeArray2 = streamConfigurationMap;
            if (streamConfigurationMap == null || (sizeArray2 = sizeArray2.getOutputSizes(ImageReader.class)) == null) {
                sizeArray2 = new Size[]{};
            }
            this.supportedPictureSizes = sizeArray2;
        }
    }

    private final void notifyTakePictureCancelled() {
        Iterable $this$forEach$iv = this.takePictureCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraTakePictureCallback it = (CameraTakePictureCallback)element$iv;
            boolean bl = false;
            it.onTakePictureCancelled();
        }
    }

    private final void updateTouchRect(boolean success) {
        if (this.touchRect != null) {
            if (this.touchFocusPaint.getColor() != -1) {
                this.touchFocusPaint.setAlpha(0);
                this.invalidate();
                return;
            }
            this.touchFocusPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)(success ? 17170452 : 0x1060016)));
            this.invalidate();
            this.postDelayed(new Runnable(this){
                final /* synthetic */ ScanbotCameraXView this$0;

                public final void run() {
                    if (ScanbotCameraXView.access$getTouchFocusPaint$p(this.this$0).getColor() != -1) {
                        ScanbotCameraXView.access$getTouchFocusPaint$p(this.this$0).setAlpha(0);
                        this.this$0.invalidate();
                    }
                }
                {
                    this.this$0 = scanbotCameraXView;
                }
            }, 1000);
        }
    }

    private final void updateAutoFocusTouchRect(MotionEvent event) {
        this.touchFocusPaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        float x = event.getX();
        float y = event.getY();
        this.touchRect = new Rect((int)(x - (float)75), (int)(y - (float)75), (int)(x + (float)75), (int)(y + (float)75));
        this.invalidate();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            super.dispatchDraw(canvas);
            Rect rect = this.touchRect;
            if (rect == null) break block0;
            Rect rect2 = rect;
            boolean bl = false;
            boolean bl2 = false;
            Rect it = rect2;
            boolean bl3 = false;
            canvas.drawRect(it, this.touchFocusPaint);
        }
    }

    @SuppressLint(value={"RestrictedApi", "UnsafeExperimentalUsageError"})
    private final void bindCameraUseCases() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        boolean bl = false;
        boolean bl2 = false;
        DisplayMetrics it = displayMetrics;
        boolean bl3 = false;
        this.previewView.getDisplay().getRealMetrics(it);
        DisplayMetrics metrics = displayMetrics;
        Log.d((String)TAG, (String)("Screen metrics: " + metrics.widthPixels + " x " + metrics.heightPixels));
        Display display = this.previewView.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"previewView.display");
        int rotation = display.getRotation();
        CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraSelector, (String)"CameraSelector.Builder()\u2026acing(lensFacing).build()");
        CameraSelector cameraSelector2 = cameraSelector;
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"ProcessCameraProvider.getInstance(context)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(new Runnable(this, cameraProviderFuture, rotation, cameraSelector2){
            final /* synthetic */ ScanbotCameraXView this$0;
            final /* synthetic */ ListenableFuture $cameraProviderFuture;
            final /* synthetic */ int $rotation;
            final /* synthetic */ CameraSelector $cameraSelector;

            public final void run() {
                boolean bl;
                Object object = this.$cameraProviderFuture.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cameraProviderFuture.get()");
                ProcessCameraProvider cameraProvider = (ProcessCameraProvider)object;
                Preview.Builder builder = new Preview.Builder();
                Size size = ScanbotCameraXView.access$getCustomPreviewSize$p(this.this$0);
                if (size == null) {
                    size = new Size(this.this$0.getMeasuredWidth(), this.this$0.getMeasuredHeight());
                }
                Preview preview = builder.setTargetResolution(size).setTargetRotation(this.$rotation).build();
                Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"Preview.Builder()\n      \u2026                 .build()");
                Preview preview2 = preview;
                ImageCapture.Builder builder2 = new ImageCapture.Builder().setCaptureMode(1).setTargetRotation(this.$rotation).setIoExecutor((Executor)ScanbotCameraXView.access$getCameraExecutor$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"ImageCapture.Builder()\n \u2026oExecutor(cameraExecutor)");
                ImageCapture.Builder imageCaptureBuilder = builder2;
                Size size2 = ScanbotCameraXView.access$getCustomPictureSize$p(this.this$0);
                if (size2 != null) {
                    Size size3 = size2;
                    boolean bl2 = false;
                    bl = false;
                    Size it = size3;
                    boolean bl3 = false;
                    imageCaptureBuilder.setTargetResolution(it);
                }
                ScanbotCameraXView.access$setImageCapture$p(this.this$0, imageCaptureBuilder.build());
                ImageAnalysis.Builder builder3 = new ImageAnalysis.Builder().setTargetRotation(this.$rotation).setBackpressureStrategy(0).setImageQueueDepth(2);
                Size size4 = ScanbotCameraXView.access$getCustomPreviewSize$p(this.this$0);
                if (size4 == null) {
                    size4 = new Size(this.this$0.getMeasuredWidth(), this.this$0.getMeasuredHeight());
                }
                ImageAnalysis imageAnalysis = builder3.setTargetResolution(size4).build();
                bl = false;
                boolean bl4 = false;
                ImageAnalysis it = imageAnalysis;
                boolean bl5 = false;
                it.setAnalyzer((Executor)ScanbotCameraXView.access$getAnalyzerExecutor$p(this.this$0), (ImageAnalysis.Analyzer)ScanbotCameraXView.access$getCompoundImageAnalyzer$p(this.this$0));
                ImageAnalysis imageAnalysis2 = imageAnalysis;
                Intrinsics.checkNotNullExpressionValue((Object)imageAnalysis2, (String)"ImageAnalysis.Builder()\n\u2026er)\n                    }");
                ImageAnalysis imageAnalyzer = imageAnalysis2;
                cameraProvider.unbindAll();
                try {
                    if (this.this$0.getContext() instanceof LifecycleOwner) {
                        Context context = this.this$0.getContext();
                        if (context == null) {
                            throw new NullPointerException("null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
                        }
                        LifecycleOwner lifecycleOwner = (LifecycleOwner)context;
                        ScanbotCameraXView.access$setCamera$p(this.this$0, cameraProvider.bindToLifecycle(lifecycleOwner, this.$cameraSelector, new UseCase[]{(UseCase)preview2, (UseCase)ScanbotCameraXView.access$getImageCapture$p(this.this$0), (UseCase)imageAnalyzer}));
                        preview2.setSurfaceProvider(ScanbotCameraXView.access$getPreviewView$p(this.this$0).createSurfaceProvider());
                        ScanbotCameraXView.access$setResolution$p(this.this$0, preview2.getAttachedSurfaceResolution());
                        ScanbotCameraXView.access$adjustFinderView(this.this$0, ScanbotCameraXView.access$getResolution$p(this.this$0));
                        ScanbotCameraXView.access$adjustPolygonView(this.this$0, ScanbotCameraXView.access$getResolution$p(this.this$0));
                        ScanbotCameraXView.access$setMeteringPointFactory$p(this.this$0, new PreviewViewMeteringPointFactory(this.this$0.getDisplay(), this.$cameraSelector, ScanbotCameraXView.access$getResolution$p(this.this$0), ScanbotCameraXView.access$getScaleType(this.this$0, ScanbotCameraXView.access$getPreviewMode$p(this.this$0)), this.this$0.getWidth(), this.this$0.getHeight()));
                        if (ScanbotCameraXView.access$isOrientationLocked$p(this.this$0) && !ScanbotCameraXView.access$isOrientationHardLocked$p(this.this$0)) {
                            ScanbotCameraXView.access$getOnOrientationChangeListener$p(this.this$0).enable();
                        }
                        LifecycleObserver cameraStateObserver2 = new LifecycleObserver(this){
                            final /* synthetic */ bindCameraUseCases.1 this$0;

                            @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
                            public final void onStart(@NotNull LifecycleOwner lifecycleOwner) {
                                Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
                                Iterable $this$forEach$iv = ScanbotCameraXView.access$getStateCallbacks$p(this.this$0.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    CameraStateCallback it = (CameraStateCallback)element$iv;
                                    boolean bl = false;
                                    it.onResume();
                                }
                            }

                            @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
                            public final void onStop(@NotNull LifecycleOwner lifecycleOwner) {
                                Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
                                Iterable $this$forEach$iv = ScanbotCameraXView.access$getStateCallbacks$p(this.this$0.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    CameraStateCallback it = (CameraStateCallback)element$iv;
                                    boolean bl = false;
                                    it.onPause();
                                }
                            }

                            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                            public final void onDestroy(@NotNull LifecycleOwner lifecycleOwner) {
                                Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
                                lifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this);
                            }
                            {
                                this.this$0 = this$0;
                            }
                        };
                        lifecycleOwner.getLifecycle().addObserver(cameraStateObserver2);
                        ScanbotCameraXView.access$getPreviewView$p(this.this$0).setOnTouchListener(new View.OnTouchListener(this){
                            final /* synthetic */ bindCameraUseCases.1 this$0;

                            public final boolean onTouch(View $noName_0, MotionEvent event) {
                                block2: {
                                    ListenableFuture future;
                                    MeteringPoint point;
                                    MotionEvent motionEvent = event;
                                    Intrinsics.checkNotNullExpressionValue((Object)motionEvent, (String)"event");
                                    if (motionEvent.getAction() != 0 || !ScanbotCameraXView.access$getAutoFocusOnTouch$p(this.this$0.this$0)) {
                                        return true;
                                    }
                                    ScanbotCameraXView.access$updateAutoFocusTouchRect(this.this$0.this$0, event);
                                    PreviewViewMeteringPointFactory previewViewMeteringPointFactory = ScanbotCameraXView.access$getMeteringPointFactory$p(this.this$0.this$0);
                                    MeteringPoint meteringPoint = point = previewViewMeteringPointFactory != null ? previewViewMeteringPointFactory.createPoint(event.getX(), event.getY()) : null;
                                    if (meteringPoint == null) break block2;
                                    MeteringPoint meteringPoint2 = meteringPoint;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    MeteringPoint it = meteringPoint2;
                                    boolean bl3 = false;
                                    FocusMeteringAction focusMeteringAction = new FocusMeteringAction.Builder(point, 1).addPoint(point, 2).setAutoCancelDuration(5L, TimeUnit.SECONDS).build();
                                    Intrinsics.checkNotNullExpressionValue((Object)focusMeteringAction, (String)"FocusMeteringAction.Buil\u2026                 .build()");
                                    FocusMeteringAction action = focusMeteringAction;
                                    Camera camera = ScanbotCameraXView.access$getCamera$p(this.this$0.this$0);
                                    ListenableFuture listenableFuture = future = camera != null && (camera = camera.getCameraControl()) != null ? camera.startFocusAndMetering(action) : null;
                                    if (listenableFuture != null) {
                                        listenableFuture.addListener(new Runnable(future, this, point){
                                            final /* synthetic */ ListenableFuture $future;
                                            final /* synthetic */ bindCameraUseCases.2 this$0;
                                            final /* synthetic */ MeteringPoint $point$inlined;
                                            {
                                                this.$future = listenableFuture;
                                                this.this$0 = var2_2;
                                                this.$point$inlined = meteringPoint;
                                            }

                                            public final void run() {
                                                ScanbotCameraXView.access$getPreviewView$p(this.this$0.this$0.this$0).post(new Runnable(this){
                                                    final /* synthetic */ bindCameraUseCases$1$2$$special$$inlined$let$lambda$1 this$0;
                                                    {
                                                        this.this$0 = var1_1;
                                                    }

                                                    public final void run() {
                                                        try {
                                                            FocusMeteringResult result = (FocusMeteringResult)this.this$0.$future.get();
                                                            ScanbotCameraXView scanbotCameraXView = this.this$0.this$0.this$0.this$0;
                                                            FocusMeteringResult focusMeteringResult = result;
                                                            Intrinsics.checkNotNullExpressionValue((Object)focusMeteringResult, (String)"result");
                                                            ScanbotCameraXView.access$updateTouchRect(scanbotCameraXView, focusMeteringResult.isFocusSuccessful());
                                                        }
                                                        catch (Exception e) {
                                                            ScanbotCameraXView.access$getLogger$p(this.this$0.this$0.this$0.this$0).logException(e);
                                                            ScanbotCameraXView.access$updateTouchRect(this.this$0.this$0.this$0.this$0, false);
                                                        }
                                                    }
                                                });
                                            }
                                        }, (Executor)ScanbotCameraXView.access$getCameraExecutor$p(this.this$0.this$0));
                                    }
                                }
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        ScanbotCameraXView.access$getCameraOpenCallback$p(this.this$0).onCameraOpened();
                    }
                }
                catch (Exception e) {
                    ScanbotCameraXView.access$getLogger$p(this.this$0).logException(e);
                }
            }
            {
                this.this$0 = scanbotCameraXView;
                this.$cameraProviderFuture = listenableFuture;
                this.$rotation = n;
                this.$cameraSelector = cameraSelector;
            }
        }, ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    private final PreviewView.ScaleType getScaleType(CameraPreviewMode previewMode) {
        PreviewView.ScaleType scaleType;
        switch (ScanbotCameraXView$WhenMappings.$EnumSwitchMapping$1[previewMode.ordinal()]) {
            case 1: {
                scaleType = PreviewView.ScaleType.FIT_CENTER;
                break;
            }
            case 2: {
                scaleType = PreviewView.ScaleType.FILL_CENTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return scaleType;
    }

    private final void adjustPolygonView(Size previewSize) {
        if (previewSize != null) {
            Object v1;
            block4: {
                ScanbotCameraXView scanbotCameraXView = this;
                if (scanbotCameraXView == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                Sequence sequence = ViewGroupKt.getChildren((ViewGroup)((ViewGroup)scanbotCameraXView));
                boolean bl = false;
                Sequence sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    View it = (View)e;
                    boolean bl3 = false;
                    if (!(it instanceof BasePolygonView)) continue;
                    v1 = e;
                    break block4;
                }
                v1 = null;
            }
            View view = v1;
            if (view == null) {
                return;
            }
            View polygonView = view;
            this.correctPolygonViewForPreviewMode((View)this, polygonView, previewSize);
        }
    }

    private final void correctPolygonViewForPreviewMode(View container, View polygonView, Size previewSize) {
        Pair<Float, Float> pair;
        switch (ScanbotCameraXView$WhenMappings.$EnumSwitchMapping$2[this.previewMode.ordinal()]) {
            case 1: {
                pair = ScaleTypeTransform.getFitScaleWithBufferAspectRatio(container, polygonView, previewSize);
                break;
            }
            case 2: {
                pair = ScaleTypeTransform.getFillScaleWithBufferAspectRatio(container, polygonView, previewSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair<Float, Float> scale = pair;
        int measuredWidth = polygonView.getMeasuredWidth();
        int measuredHeight = polygonView.getMeasuredHeight();
        Display display = this.getDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)display, (String)"display");
        int displayOrientation = display.getRotation();
        float newWidth = 0.0f;
        float newHeight = 0.0f;
        boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(this.getContext(), displayOrientation);
        if (isNaturalPortrait) {
            float f = measuredWidth;
            Object object = scale.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scale.first");
            newWidth = f * ((Number)object).floatValue();
            float f2 = measuredHeight;
            Object object2 = scale.second;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"scale.second");
            newHeight = f2 * ((Number)object2).floatValue();
        } else {
            float f = measuredWidth;
            Object object = scale.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"scale.first");
            newHeight = f * ((Number)object).floatValue();
            float f3 = measuredHeight;
            Object object3 = scale.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"scale.second");
            newWidth = f3 * ((Number)object3).floatValue();
        }
        ViewGroup.LayoutParams layoutParams = polygonView.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams newLayoutParams = (ConstraintLayout.LayoutParams)layoutParams;
        newLayoutParams.leftMargin = (int)(((float)measuredWidth - newWidth) / (float)2);
        newLayoutParams.rightMargin = (int)(((float)measuredWidth - newWidth) / (float)2);
        newLayoutParams.topMargin = (int)(((float)measuredHeight - newHeight) / (float)2);
        newLayoutParams.bottomMargin = (int)(((float)measuredHeight - newHeight) / (float)2);
        polygonView.setLayoutParams((ViewGroup.LayoutParams)newLayoutParams);
    }

    private final void adjustFinderView(Size previewSize) {
        if (this.getParent() != null && previewSize != null) {
            ViewParent parent;
            ViewParent viewParent = this.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup == null) {
                return;
            }
            ViewParent viewParent2 = parent = (ViewParent)viewGroup;
            if (viewParent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            View view = ((ViewGroup)viewParent2).findViewById(R.id.finder_overlay);
            if (view == null) {
                return;
            }
            View finderOverlay = view;
            Display display = this.getDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"display");
            int displayOrientation = display.getRotation();
            int previewWidth = 0;
            int previewHeight = 0;
            boolean isNaturalPortrait = ScaleTypeTransform.isNaturalPortrait(this.getContext(), displayOrientation);
            if (isNaturalPortrait) {
                previewWidth = previewSize.getHeight();
                previewHeight = previewSize.getWidth();
            } else {
                previewWidth = previewSize.getWidth();
                previewHeight = previewSize.getHeight();
            }
            if (finderOverlay instanceof IFinderView) {
                ((IFinderView)finderOverlay).setCameraParameters(previewWidth, previewHeight, this.previewMode);
            }
        }
    }

    private final RectF calculateVisibleRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null) {
            RectF rectF;
            ViewParent parent;
            ViewParent viewParent = this.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup == null) {
                return null;
            }
            ViewParent viewParent2 = parent = (ViewParent)viewGroup;
            if (viewParent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.View");
            }
            int parentWidth = ((View)viewParent2).getMeasuredWidth();
            int parentHeight = ((View)parent).getMeasuredHeight();
            double heightScale = (double)parentHeight / (double)previewHeight;
            double widthScale = (double)parentWidth / (double)previewWidth;
            int scaledPreviewWidth = 0;
            int scaledPreviewHeight = 0;
            if (previewMode == CameraPreviewMode.FILL_IN) {
                if (heightScale > widthScale) {
                    scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                    scaledPreviewHeight = parentHeight;
                } else {
                    scaledPreviewWidth = parentWidth;
                    scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                }
                int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
                int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
                float overlayTop = this.normalizeF((float)previewOffsetHeight / (float)scaledPreviewHeight);
                float overlayLeft = this.normalizeF((float)previewOffsetWidth / (float)scaledPreviewWidth);
                float overlayBottom = this.normalizeF((float)(scaledPreviewHeight - previewOffsetHeight) / (float)scaledPreviewHeight);
                float overlayRight = this.normalizeF((float)(scaledPreviewWidth - previewOffsetWidth) / (float)scaledPreviewWidth);
                rectF = new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
            } else {
                rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            return rectF;
        }
        return null;
    }

    private final RectF calculateFinderRectF(int previewWidth, int previewHeight, CameraPreviewMode previewMode) {
        if (this.getParent() != null) {
            ViewParent parent;
            ViewParent viewParent = this.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup == null) {
                return null;
            }
            ViewParent viewParent2 = parent = (ViewParent)viewGroup;
            if (viewParent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            View finderOverlay = ((ViewGroup)viewParent2).findViewById(R.id.finder_overlay);
            if (finderOverlay == null || finderOverlay.getVisibility() != 0) {
                return null;
            }
            int parentWidth = ((View)parent).getMeasuredWidth();
            int parentHeight = ((View)parent).getMeasuredHeight();
            Rect overlayRect = new Rect();
            finderOverlay.getDrawingRect(overlayRect);
            ((ViewGroup)parent).offsetDescendantRectToMyCoords(finderOverlay, overlayRect);
            overlayRect = new Rect(overlayRect.left + finderOverlay.getPaddingLeft(), overlayRect.top + finderOverlay.getPaddingTop(), overlayRect.right - finderOverlay.getPaddingRight(), overlayRect.bottom - finderOverlay.getPaddingBottom());
            double heightScale = (double)parentHeight / (double)previewHeight;
            double widthScale = (double)parentWidth / (double)previewWidth;
            int scaledPreviewWidth = 0;
            int scaledPreviewHeight = 0;
            if (previewMode == CameraPreviewMode.FILL_IN) {
                if (heightScale > widthScale) {
                    scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                    scaledPreviewHeight = parentHeight;
                } else {
                    scaledPreviewWidth = parentWidth;
                    scaledPreviewHeight = (int)((double)previewHeight * widthScale);
                }
            } else if (heightScale > widthScale) {
                scaledPreviewWidth = parentWidth;
                scaledPreviewHeight = (int)((double)previewHeight * widthScale);
            } else {
                scaledPreviewWidth = (int)((double)previewWidth * heightScale);
                scaledPreviewHeight = parentHeight;
            }
            int previewOffsetWidth = (scaledPreviewWidth - parentWidth) / 2;
            int previewOffsetHeight = (scaledPreviewHeight - parentHeight) / 2;
            float overlayTop = this.normalizeF((float)(previewOffsetHeight + overlayRect.top) / (float)scaledPreviewHeight);
            float overlayLeft = this.normalizeF((float)(previewOffsetWidth + overlayRect.left) / (float)scaledPreviewWidth);
            float overlayBottom = this.normalizeF((float)(previewOffsetHeight + overlayRect.bottom) / (float)scaledPreviewHeight);
            float overlayRight = this.normalizeF((float)(previewOffsetWidth + overlayRect.right) / (float)scaledPreviewWidth);
            return new RectF(overlayLeft, overlayTop, overlayRight, overlayBottom);
        }
        return null;
    }

    private final float normalizeF(float rectCoordinates) {
        return rectCoordinates < 0.0f ? 0.0f : (rectCoordinates > 1.0f ? 1.0f : rectCoordinates);
    }

    @Override
    public void setUiZoomLevel(float zoomLevel) {
        this.setScaleX(zoomLevel);
        this.setScaleY(zoomLevel);
    }

    public ScanbotCameraXView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.supportedPreviewSizes = new Size[0];
        this.supportedPictureSizes = new Size[0];
        this.logger = LoggerProvider.getLogger();
        this.autoFocusOnTouch = true;
        this.displayId = -1;
        this.lensFacing = 1;
        this.compoundImageAnalyzer = new CompoundAnalyzer();
        this.stateCallbacks = new LinkedHashSet();
        this.pictureCallbacks = new LinkedHashSet();
        this.takePictureCallbacks = new LinkedHashSet();
        this.cameraOpenCallback = CameraOpenCallback.NULL;
        this.previewMode = CameraPreviewMode.FILL_IN;
        this.delayAfterFocusCompleteMs = 20L;
        this.displayManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DisplayManager>(context){
            final /* synthetic */ Context $context;

            @NotNull
            public final DisplayManager invoke() {
                Object object = this.$context.getSystemService("display");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
                }
                return (DisplayManager)object;
            }
            {
                this.$context = context;
                super(0);
            }
        }));
        this.cameraExecutor = Executors.newSingleThreadExecutor();
        this.analyzerExecutor = Executors.newSingleThreadExecutor();
        this.displayListener = new DisplayManager.DisplayListener(this){
            final /* synthetic */ ScanbotCameraXView this$0;

            public void onDisplayAdded(int displayId) {
            }

            public void onDisplayRemoved(int displayId) {
            }

            public void onDisplayChanged(int displayId) {
                block2: {
                    ScanbotCameraXView scanbotCameraXView = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    ScanbotCameraXView view = scanbotCameraXView;
                    boolean bl3 = false;
                    Display display = view.getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display, (String)"view.display");
                    if (displayId != display.getDisplayId()) break block2;
                    Logger logger = ScanbotCameraXView.access$getLogger$p(this.this$0);
                    StringBuilder stringBuilder = new StringBuilder().append("Rotation changed: ");
                    Display display2 = view.getDisplay();
                    Intrinsics.checkNotNullExpressionValue((Object)display2, (String)"view.display");
                    logger.d("ScanbotCameraXView", stringBuilder.append(display2.getRotation()).toString());
                    ImageCapture imageCapture = ScanbotCameraXView.access$getImageCapture$p(this.this$0);
                    if (imageCapture != null) {
                        Display display3 = view.getDisplay();
                        Intrinsics.checkNotNullExpressionValue((Object)display3, (String)"view.display");
                        imageCapture.setTargetRotation(display3.getRotation());
                    }
                    ImageAnalysis imageAnalysis = ScanbotCameraXView.access$getImageAnalyzer$p(this.this$0);
                    if (imageAnalysis != null) {
                        Display display4 = view.getDisplay();
                        Intrinsics.checkNotNullExpressionValue((Object)display4, (String)"view.display");
                        imageAnalysis.setTargetRotation(display4.getRotation());
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        ConstraintLayout.inflate((Context)context, (int)R.layout.scanbot_camerax_view, (ViewGroup)((ViewGroup)this));
        this.touchFocusPaint = new Paint();
        this.touchFocusPaint.setColor(ContextCompat.getColor((Context)context, (int)17170443));
        this.touchFocusPaint.setStyle(Paint.Style.STROKE);
        this.touchFocusPaint.setStrokeWidth(this.getResources().getDimension(R.dimen.touch_focus_polygon_width));
        this.touchFocusPaint.setAntiAlias(true);
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
        this.onOrientationChangeListener = new OnOrientationChange(context);
        View view = this.findViewById(R.id.camera_preview_view);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.camera_preview_view)");
        this.previewView = (PreviewView)view;
        this.previewView.setPreferredImplementationMode(PreviewView.ImplementationMode.TEXTURE_VIEW);
        Object object = context.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        this.cameraManager = (CameraManager)object;
        this.initSupportedPreviewPictureSizes();
        View view2 = this.findViewById(R.id.flashView);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.flashView)");
        SnapFlashView snapFlashView = this.snapAnimationView = (SnapFlashView)view2;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        boolean bl = false;
        View $this$isVisible$iv = (View)snapFlashView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    static {
        Companion = new Companion(null);
        ROTATION_DEGREES = new int[]{0, 90, 180, 270};
    }

    public static final /* synthetic */ void access$setPreviewMode$p(ScanbotCameraXView $this, CameraPreviewMode cameraPreviewMode) {
        $this.previewMode = cameraPreviewMode;
    }

    public static final /* synthetic */ void access$setFinderInnerThresholdPx$p(ScanbotCameraXView $this, int n) {
        $this.finderInnerThresholdPx = n;
    }

    public static final /* synthetic */ void access$setFinderOuterThresholdPx$p(ScanbotCameraXView $this, int n) {
        $this.finderOuterThresholdPx = n;
    }

    public static final /* synthetic */ void access$setCamera$p(ScanbotCameraXView $this, Camera camera) {
        $this.camera = camera;
    }

    public static final /* synthetic */ void access$setImageCapture$p(ScanbotCameraXView $this, ImageCapture imageCapture) {
        $this.imageCapture = imageCapture;
    }

    public static final /* synthetic */ void access$setImageAnalyzer$p(ScanbotCameraXView $this, ImageAnalysis imageAnalysis) {
        $this.imageAnalyzer = imageAnalysis;
    }

    public static final /* synthetic */ PreviewView access$getPreviewView$p(ScanbotCameraXView $this) {
        return $this.previewView;
    }

    public static final /* synthetic */ int access$getDisplayId$p(ScanbotCameraXView $this) {
        return $this.displayId;
    }

    public static final /* synthetic */ void access$setDisplayId$p(ScanbotCameraXView $this, int n) {
        $this.displayId = n;
    }

    public static final /* synthetic */ void access$bindCameraUseCases(ScanbotCameraXView $this) {
        $this.bindCameraUseCases();
    }

    public static final /* synthetic */ void access$tryTakePicture(ScanbotCameraXView $this) {
        $this.tryTakePicture();
    }

    public static final /* synthetic */ ExecutorService access$getCameraExecutor$p(ScanbotCameraXView $this) {
        return $this.cameraExecutor;
    }

    public static final /* synthetic */ SnapFlashView access$getSnapAnimationView$p(ScanbotCameraXView $this) {
        SnapFlashView snapFlashView = $this.snapAnimationView;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        return snapFlashView;
    }

    public static final /* synthetic */ void access$setSnapAnimationView$p(ScanbotCameraXView $this, SnapFlashView snapFlashView) {
        $this.snapAnimationView = snapFlashView;
    }

    public static final /* synthetic */ Set access$getPictureCallbacks$p(ScanbotCameraXView $this) {
        return $this.pictureCallbacks;
    }

    public static final /* synthetic */ void access$notifyTakePictureCancelled(ScanbotCameraXView $this) {
        $this.notifyTakePictureCancelled();
    }

    public static final /* synthetic */ Paint access$getTouchFocusPaint$p(ScanbotCameraXView $this) {
        return $this.touchFocusPaint;
    }

    public static final /* synthetic */ void access$setTouchFocusPaint$p(ScanbotCameraXView $this, Paint paint) {
        $this.touchFocusPaint = paint;
    }

    public static final /* synthetic */ Size access$getCustomPreviewSize$p(ScanbotCameraXView $this) {
        return $this.customPreviewSize;
    }

    public static final /* synthetic */ void access$setCustomPreviewSize$p(ScanbotCameraXView $this, Size size) {
        $this.customPreviewSize = size;
    }

    public static final /* synthetic */ Size access$getCustomPictureSize$p(ScanbotCameraXView $this) {
        return $this.customPictureSize;
    }

    public static final /* synthetic */ void access$setCustomPictureSize$p(ScanbotCameraXView $this, Size size) {
        $this.customPictureSize = size;
    }

    public static final /* synthetic */ ExecutorService access$getAnalyzerExecutor$p(ScanbotCameraXView $this) {
        return $this.analyzerExecutor;
    }

    public static final /* synthetic */ CompoundAnalyzer access$getCompoundImageAnalyzer$p(ScanbotCameraXView $this) {
        return $this.compoundImageAnalyzer;
    }

    public static final /* synthetic */ Size access$getResolution$p(ScanbotCameraXView $this) {
        return $this.resolution;
    }

    public static final /* synthetic */ void access$setResolution$p(ScanbotCameraXView $this, Size size) {
        $this.resolution = size;
    }

    public static final /* synthetic */ void access$adjustFinderView(ScanbotCameraXView $this, Size previewSize) {
        $this.adjustFinderView(previewSize);
    }

    public static final /* synthetic */ void access$adjustPolygonView(ScanbotCameraXView $this, Size previewSize) {
        $this.adjustPolygonView(previewSize);
    }

    public static final /* synthetic */ PreviewViewMeteringPointFactory access$getMeteringPointFactory$p(ScanbotCameraXView $this) {
        return $this.meteringPointFactory;
    }

    public static final /* synthetic */ void access$setMeteringPointFactory$p(ScanbotCameraXView $this, PreviewViewMeteringPointFactory previewViewMeteringPointFactory) {
        $this.meteringPointFactory = previewViewMeteringPointFactory;
    }

    public static final /* synthetic */ PreviewView.ScaleType access$getScaleType(ScanbotCameraXView $this, CameraPreviewMode previewMode) {
        return $this.getScaleType(previewMode);
    }

    public static final /* synthetic */ boolean access$isOrientationLocked$p(ScanbotCameraXView $this) {
        return $this.isOrientationLocked;
    }

    public static final /* synthetic */ void access$setOrientationLocked$p(ScanbotCameraXView $this, boolean bl) {
        $this.isOrientationLocked = bl;
    }

    public static final /* synthetic */ boolean access$isOrientationHardLocked$p(ScanbotCameraXView $this) {
        return $this.isOrientationHardLocked;
    }

    public static final /* synthetic */ void access$setOrientationHardLocked$p(ScanbotCameraXView $this, boolean bl) {
        $this.isOrientationHardLocked = bl;
    }

    public static final /* synthetic */ OnOrientationChange access$getOnOrientationChangeListener$p(ScanbotCameraXView $this) {
        return $this.onOrientationChangeListener;
    }

    public static final /* synthetic */ Set access$getStateCallbacks$p(ScanbotCameraXView $this) {
        return $this.stateCallbacks;
    }

    public static final /* synthetic */ boolean access$getAutoFocusOnTouch$p(ScanbotCameraXView $this) {
        return $this.autoFocusOnTouch;
    }

    public static final /* synthetic */ void access$setAutoFocusOnTouch$p(ScanbotCameraXView $this, boolean bl) {
        $this.autoFocusOnTouch = bl;
    }

    public static final /* synthetic */ void access$updateAutoFocusTouchRect(ScanbotCameraXView $this, MotionEvent event) {
        $this.updateAutoFocusTouchRect(event);
    }

    public static final /* synthetic */ void access$updateTouchRect(ScanbotCameraXView $this, boolean success) {
        $this.updateTouchRect(success);
    }

    public static final /* synthetic */ CameraOpenCallback access$getCameraOpenCallback$p(ScanbotCameraXView $this) {
        return $this.cameraOpenCallback;
    }

    public static final /* synthetic */ void access$setCameraOpenCallback$p(ScanbotCameraXView $this, CameraOpenCallback cameraOpenCallback) {
        $this.cameraOpenCallback = cameraOpenCallback;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J%\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$CompoundAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "(Lio/scanbot/sdk/ui/camera/ScanbotCameraXView;)V", "frameHandlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/camera/FrameHandler;", "Lkotlin/collections/LinkedHashSet;", "addFrameHandler", "", "frameHandler", "analyze", "image", "Landroidx/camera/core/ImageProxy;", "getAttachedFrameHandler", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lio/scanbot/sdk/camera/FrameHandler;", "removeFrameHandler", "sdk-base_release"})
    private final class CompoundAnalyzer
    implements ImageAnalysis.Analyzer {
        private final LinkedHashSet<FrameHandler> frameHandlers = new LinkedHashSet();

        @Nullable
        public final <T extends FrameHandler> T getAttachedFrameHandler(@NotNull Class<T> clazz) {
            Object v1;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Iterable $this$firstOrNull$iv = this.frameHandlers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FrameHandler it = (FrameHandler)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getClass(), clazz)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof FrameHandler)) {
                v1 = null;
            }
            return (T)((FrameHandler)v1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addFrameHandler(@NotNull FrameHandler frameHandler) {
            Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
            LinkedHashSet<FrameHandler> linkedHashSet = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (linkedHashSet) {
                boolean bl3 = false;
                bl2 = this.frameHandlers.add(frameHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeFrameHandler(@NotNull FrameHandler frameHandler) {
            Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
            LinkedHashSet<FrameHandler> linkedHashSet = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (linkedHashSet) {
                boolean bl3 = false;
                bl2 = this.frameHandlers.remove(frameHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @SuppressLint(value={"RestrictedApi"})
        public void analyze(@NotNull ImageProxy image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            LinkedHashSet<FrameHandler> linkedHashSet = this.frameHandlers;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (linkedHashSet) {
                void finderRect;
                boolean bl3 = false;
                if (this.frameHandlers.isEmpty()) {
                    image.close();
                    return;
                }
                ImageInfo imageInfo = image.getImageInfo();
                Intrinsics.checkNotNullExpressionValue((Object)imageInfo, (String)"image.imageInfo");
                int imageOrientation = imageInfo.getRotationDegrees();
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
                objectRef2.element = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
                int previewWidth = 0;
                int previewHeight = 0;
                if (imageOrientation == 0 || imageOrientation == 180) {
                    previewWidth = image.getWidth() < image.getHeight() ? image.getHeight() : image.getWidth();
                    previewHeight = image.getWidth() < image.getHeight() ? image.getWidth() : image.getHeight();
                } else {
                    previewWidth = image.getWidth() > image.getHeight() ? image.getHeight() : image.getWidth();
                    previewHeight = image.getWidth() > image.getHeight() ? image.getWidth() : image.getHeight();
                }
                RectF overlayRectF = ScanbotCameraXView.this.calculateFinderRectF(previewWidth, previewHeight, ScanbotCameraXView.this.previewMode);
                visibleRectF.element = ScanbotCameraXView.this.calculateVisibleRectF(previewWidth, previewHeight, ScanbotCameraXView.this.previewMode);
                if (overlayRectF != null) {
                    finderRect.element = new Rect((int)((float)previewWidth * overlayRectF.left), (int)((float)previewHeight * overlayRectF.top), (int)((float)previewWidth * overlayRectF.right), (int)((float)previewHeight * overlayRectF.bottom));
                    if (((Rect)finderRect.element).left < 0 || ((Rect)finderRect.element).left > previewWidth || ((Rect)finderRect.element).top < 0 || ((Rect)finderRect.element).top > previewHeight || ((Rect)finderRect.element).right < 0 || ((Rect)finderRect.element).right > previewWidth || ((Rect)finderRect.element).bottom < 0 || ((Rect)finderRect.element).bottom > previewHeight || ((Rect)finderRect.element).width() <= 0 || ((Rect)finderRect.element).height() <= 0) {
                        ScanbotCameraXView.this.logger.e("Camera", "Finder overlay layout does not fit to the Camera preview frame.");
                        image.close();
                        return;
                    }
                }
                byte[] data = PreviewImageUtil.convertYUV420toNV21(image);
                Iterable $this$forEach$iv = this.frameHandlers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void visibleRectF;
                    FrameHandler it = (FrameHandler)element$iv;
                    boolean bl4 = false;
                    int n = image.getWidth();
                    int n2 = image.getHeight();
                    ImageInfo imageInfo2 = image.getImageInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)imageInfo2, (String)"image.imageInfo");
                    it.handleFrame(new FrameHandler.Frame(data, n, n2, imageInfo2.getRotationDegrees(), (Rect)finderRect.element, (RectF)visibleRectF.element, ScanbotCameraXView.this.finderInnerThresholdPx, ScanbotCameraXView.this.finderOuterThresholdPx));
                }
                Unit unit = Unit.INSTANCE;
            }
            image.close();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$OnOrientationChange;", "Landroid/view/OrientationEventListener;", "context", "Landroid/content/Context;", "(Lio/scanbot/sdk/ui/camera/ScanbotCameraXView;Landroid/content/Context;)V", "currentOrientation", "", "isEnabled", "", "disable", "", "enable", "getClosestRotationDegree", "rotation", "onOrientationChanged", "orientation", "resetOrientation", "sdk-base_release"})
    public final class OnOrientationChange
    extends OrientationEventListener {
        private int currentOrientation;
        private boolean isEnabled;

        public void onOrientationChanged(int orientation) {
            int orientation2 = orientation;
            if (ScanbotCameraXView.this.camera == null || !this.canDetectOrientation() || orientation2 == -1) {
                return;
            }
            if ((orientation2 = this.getClosestRotationDegree(orientation2)) != this.currentOrientation) {
                int n;
                switch (orientation2) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    case 90: {
                        n = 3;
                        break;
                    }
                    case 180: {
                        n = 2;
                        break;
                    }
                    case 270: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int rotation = n;
                ScanbotCameraXView.this.logger.d(ScanbotCameraXView.TAG, "Rotation changed: " + rotation);
                ImageCapture imageCapture = ScanbotCameraXView.this.imageCapture;
                if (imageCapture != null) {
                    imageCapture.setTargetRotation(rotation);
                }
                ImageAnalysis imageAnalysis = ScanbotCameraXView.this.imageAnalyzer;
                if (imageAnalysis != null) {
                    imageAnalysis.setTargetRotation(rotation);
                }
                this.currentOrientation = orientation2;
            }
        }

        private final int getClosestRotationDegree(int rotation) {
            for (int value : ROTATION_DEGREES) {
                int n = rotation - value;
                boolean bl = false;
                int diff = Math.abs(n);
                if (diff >= 45) continue;
                return value;
            }
            return 0;
        }

        public void enable() {
            this.isEnabled = true;
            super.enable();
        }

        public void disable() {
            this.isEnabled = false;
            super.disable();
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final void resetOrientation() {
            this.currentOrientation = -1;
        }

        public OnOrientationChange(Context context) {
            super(context, 0);
            this.currentOrientation = -1;
            this.disable();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$AutofocusCallback;", "", "onAutoFocusCompleted", "", "sdk-base_release"})
    private static interface AutofocusCallback {
        public void onAutoFocusCompleted();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/ui/camera/ScanbotCameraXView$Companion;", "", "()V", "DEFAULT_FOCUS_AREA_SIZE", "", "DEFAULT_FOCUS_DURATION", "", "DELAY_HIDE_TOUCH_FOCUS_MS", "ROTATION_DEGREES", "", "TAG", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

