/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0016\u001a\u00020\u0014H\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0014H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "maxZoomLevel", "", "requiredZoomLevel", "zoomDelegates", "", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "value", "zoomLevel", "getZoomLevel", "()F", "setZoomLevel", "(F)V", "addCameraZoomDelegate", "", "delegate", "onAttachedToWindow", "onDetachedFromWindow", "removeCameraZoomDelegate", "setInitialFinderViewSize", "Companion", "sdk-base_release"})
public final class ZoomFinderOverlayView
extends FinderOverlayView {
    private final Set<UiZoomDelegate> zoomDelegates;
    private float maxZoomLevel;
    private float requiredZoomLevel;
    private float zoomLevel;
    private static final float MAX_ZOOM = 10.0f;
    private static final int DEFAULT_HEIGHT = 100;
    private static final double DEFAULT_ASPECT_RATIO = 6.0;
    public static final Companion Companion = new Companion(null);

    public final float getZoomLevel() {
        return this.zoomLevel;
    }

    public final void setZoomLevel(float value) {
        this.requiredZoomLevel = value;
        float newZoomLevel = RangesKt.coerceIn((float)value, (float)1.0f, (float)this.maxZoomLevel);
        this.setScaleX(newZoomLevel);
        this.setScaleY(newZoomLevel);
        Iterable $this$forEach$iv = this.zoomDelegates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UiZoomDelegate it = (UiZoomDelegate)element$iv;
            boolean bl = false;
            it.setUiZoomLevel(newZoomLevel);
        }
        this.zoomLevel = newZoomLevel;
    }

    public final void addCameraZoomDelegate(@NotNull UiZoomDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.zoomDelegates.add(delegate);
        delegate.setUiZoomLevel(this.zoomLevel);
    }

    public final void removeCameraZoomDelegate(@NotNull UiZoomDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.zoomDelegates.remove(delegate);
    }

    /*
     * WARNING - void declaration
     */
    protected void onAttachedToWindow() {
        ViewGroup parentView;
        super.onAttachedToWindow();
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup $this$forEach$iv = parentView = (ViewGroup)viewParent;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.getChildCount();
        while (n < n2) {
            View it;
            void index$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getChildAt((int)index$iv), (String)"getChildAt(index)");
            boolean bl = false;
            if (it instanceof UiZoomDelegate) {
                this.addCameraZoomDelegate((UiZoomDelegate)it);
            }
            ++index$iv;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.zoomDelegates.clear();
    }

    @Override
    protected void setInitialFinderViewSize() {
        double d;
        int scaledFrameWidth = 0;
        int scaledFrameHeight = 0;
        if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
            double frameAspectRatio = this.getInitialPreviewWidth() == 0 || this.getInitialPreviewHeight() == 0 ? (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() : (double)this.getInitialPreviewWidth() / (double)this.getInitialPreviewHeight();
            double cameraViewAspectRatio = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
            scaledFrameWidth = cameraViewAspectRatio < frameAspectRatio ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * frameAspectRatio);
            scaledFrameHeight = cameraViewAspectRatio < frameAspectRatio ? (int)((double)this.getMeasuredWidth() / frameAspectRatio) : this.getMeasuredHeight();
        } else {
            scaledFrameWidth = this.getMeasuredWidth();
            scaledFrameHeight = this.getMeasuredHeight();
        }
        int maxFinderWidth = scaledFrameWidth - 2 * this.getMinFinderPadding();
        int maxFinderHeight = scaledFrameHeight - 2 * this.getMinFinderPadding();
        List<FinderAspectRatio> list = this.getRequiredAspectRatiosInternal();
        if (list != null && (list = (FinderAspectRatio)CollectionsKt.firstOrNull(list)) != null) {
            List<FinderAspectRatio> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<FinderAspectRatio> it = list2;
            boolean bl3 = false;
            d = ((FinderAspectRatio)((Object)it)).getWidth() / ((FinderAspectRatio)((Object)it)).getHeight();
        } else {
            d = 6.0;
        }
        double targetAspectRatio = d;
        int initialHeight = this.getFixedFinderHeightInPx() < 0 ? 100 : this.getFixedFinderHeightInPx();
        double targetWidth = (double)initialHeight * targetAspectRatio;
        float maxWidthZoom = RangesKt.coerceIn((float)((float)maxFinderWidth / (float)targetWidth), (float)1.0f, (float)10.0f);
        float maxHeightZoom = maxFinderHeight / initialHeight;
        this.maxZoomLevel = RangesKt.coerceIn((float)maxHeightZoom, (float)1.0f, (float)maxWidthZoom);
        this.setZoomLevel(RangesKt.coerceIn((float)this.requiredZoomLevel, (float)1.0f, (float)this.maxZoomLevel));
        int paddingTopBottom = (this.getMeasuredHeight() - initialHeight) / 2;
        int paddingLeftRight = (this.getMeasuredWidth() - (int)targetWidth) / 2;
        this.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        this.adjustDescriptionPosition(paddingTopBottom);
        this.invalidate();
    }

    public ZoomFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr);
        boolean bl = false;
        this.zoomDelegates = new LinkedHashSet();
        this.maxZoomLevel = 1.0f;
        this.requiredZoomLevel = 1.0f;
        this.zoomLevel = 1.0f;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView$Companion;", "", "()V", "DEFAULT_ASPECT_RATIO", "", "DEFAULT_HEIGHT", "", "MAX_ZOOM", "", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

