/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ3\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/ui/camera/util/ScaleTypeTransform;", "", "Landroid/view/View;", "container", "view", "Landroid/util/Size;", "bufferSize", "Landroid/util/Pair;", "", "getFillScaleWithBufferAspectRatio", "(Landroid/view/View;Landroid/view/View;Landroid/util/Size;)Landroid/util/Pair;", "getFitScaleWithBufferAspectRatio", "Landroid/graphics/Point;", "getOriginOfCenteredView", "(Landroid/view/View;Landroid/view/View;)Landroid/graphics/Point;", "", "getRotationDegrees", "(Landroid/view/View;)I", "Landroid/content/Context;", "context", "rotationDegrees", "", "isNaturalPortrait", "(Landroid/content/Context;I)Z", "rotationConstant", "rotationDegreesFromSurfaceRotation", "(I)I", "<init>", "()V", "sdk-base_release"})
public final class ScaleTypeTransform {
    public static final ScaleTypeTransform a = new ScaleTypeTransform();

    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NotNull View view, @NotNull View view2, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Intrinsics.checkNotNullParameter((Object)size, (String)"bufferSize");
        if (view.getWidth() != 0 && view.getHeight() != 0 && view2.getWidth() != 0 && view2.getHeight() != 0 && size.getWidth() != 0 && size.getHeight() != 0) {
            int n;
            int n2;
            View view3 = view2;
            int n3 = ScaleTypeTransform.getRotationDegrees(view3);
            Context context = view3.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            if (ScaleTypeTransform.isNaturalPortrait(context, n3)) {
                Size size2 = size;
                n2 = size2.getHeight();
                n = size2.getWidth();
            } else {
                Size size3 = size;
                n2 = size3.getWidth();
                n = size3.getHeight();
            }
            float f2 = (float)n2 / (float)view2.getWidth();
            float f3 = (float)n / (float)view2.getHeight();
            if (n3 == 0 || n3 == 180) {
                int n4 = n2;
                n2 = n;
                n = n4;
            }
            float f4 = f3;
            float f5 = Math.max((float)view.getWidth() / (float)n, (float)view.getHeight() / (float)n2);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NotNull View view, @NotNull View view2, @NotNull Size size) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Intrinsics.checkNotNullParameter((Object)size, (String)"bufferSize");
        if (view.getWidth() != 0 && view.getHeight() != 0 && view2.getWidth() != 0 && view2.getHeight() != 0 && size.getWidth() != 0 && size.getHeight() != 0) {
            int n;
            int n2;
            View view3 = view2;
            int n3 = ScaleTypeTransform.getRotationDegrees(view3);
            Context context = view3.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            if (ScaleTypeTransform.isNaturalPortrait(context, n3)) {
                Size size2 = size;
                n2 = size2.getHeight();
                n = size2.getWidth();
            } else {
                Size size3 = size;
                n2 = size3.getWidth();
                n = size3.getHeight();
            }
            float f2 = (float)n2 / (float)view2.getWidth();
            float f3 = (float)n / (float)view2.getHeight();
            if (n3 == 0 || n3 == 180) {
                int n4 = n2;
                n2 = n;
                n = n4;
            }
            float f4 = f3;
            float f5 = Math.min((float)view.getWidth() / (float)n, (float)view.getHeight() / (float)n2);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @JvmStatic
    @NotNull
    public static final Point getOriginOfCenteredView(@NotNull View view, @NotNull View view2) {
        int n;
        View view3 = view2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
        int n2 = (view3.getWidth() - view.getWidth()) / 2;
        int n3 = n = (view3.getHeight() - view.getHeight()) / 2;
        n = -n2;
        return new Point(n, -n3);
    }

    @JvmStatic
    public static final int getRotationDegrees(@NotNull View object) {
        View view = object;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        object = view.getContext().getSystemService("window");
        if (object != null) {
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"windowManager.defaultDisplay");
            return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(display.getRotation());
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    @JvmStatic
    public static final boolean isNaturalPortrait(@NotNull Context object, int n) {
        Context context = object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        object = context.getSystemService("window");
        if (object != null) {
            object = ((WindowManager)object).getDefaultDisplay();
            Point point = new Point();
            object.getRealSize(point);
            int n2 = point.x;
            int n3 = point.y;
            return (n == 0 || n == 180) && n2 < n3 || (n == 90 || n == 270) && n2 >= n3;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    @JvmStatic
    public static final int rotationDegreesFromSurfaceRotation(int n) {
        int n2;
        switch (n) {
            default: {
                throw new UnsupportedOperationException("Unsupported surface rotation constant: " + n);
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        return n2;
    }

    private ScaleTypeTransform() {
    }
}

