/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001$B\u0019\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\b\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u000b\u0010\tR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR*\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0013R\u0016\u0010\u001c\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0013\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "delegate", "", "addCameraZoomDelegate", "(Lio/scanbot/sdk/ui/camera/UiZoomDelegate;)V", "removeCameraZoomDelegate", "onAttachedToWindow", "()V", "onDetachedFromWindow", "setInitialFinderViewSize", "", "r", "Ljava/util/Set;", "zoomDelegates", "", "value", "u", "F", "getZoomLevel", "()F", "setZoomLevel", "(F)V", "zoomLevel", "s", "maxZoomLevel", "t", "requiredZoomLevel", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "v", "Companion", "sdk-base_release"})
public final class ZoomFinderOverlayView
extends FinderOverlayView {
    public static final float MAX_ZOOM = 10.0f;
    public static final int DEFAULT_HEIGHT = 100;
    public static final double DEFAULT_ASPECT_RATIO = 6.0;
    private static final Companion v = new Companion(null);
    private final Set<UiZoomDelegate> r;
    private float s;
    private float t;
    private float u;

    public ZoomFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        LinkedHashSet linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        v1.r = linkedHashSet2;
        v1.s = 1.0f;
        v1.t = 1.0f;
        v1.u = 1.0f;
    }

    public final float getZoomLevel() {
        return this.u;
    }

    public final void setZoomLevel(float f2) {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        this.t = f2;
        f2 = RangesKt.coerceIn((float)f2, (float)1.0f, (float)this.s);
        zoomFinderOverlayView.setScaleX(f2);
        zoomFinderOverlayView.setScaleY(f2);
        Iterator iterator = zoomFinderOverlayView.r.iterator();
        while (iterator.hasNext()) {
            ((UiZoomDelegate)iterator.next()).setUiZoomLevel(f2);
        }
        this.u = f2;
    }

    public final void addCameraZoomDelegate(@NotNull UiZoomDelegate uiZoomDelegate) {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        Intrinsics.checkNotNullParameter((Object)uiZoomDelegate, (String)"delegate");
        zoomFinderOverlayView.r.add(uiZoomDelegate);
        uiZoomDelegate.setUiZoomLevel(zoomFinderOverlayView.u);
    }

    public final void removeCameraZoomDelegate(@NotNull UiZoomDelegate uiZoomDelegate) {
        Intrinsics.checkNotNullParameter((Object)uiZoomDelegate, (String)"delegate");
        this.r.remove(uiZoomDelegate);
    }

    public void onAttachedToWindow() {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        super.onAttachedToWindow();
        ViewParent viewParent = zoomFinderOverlayView.getParent();
        if (viewParent != null) {
            viewParent = (ViewGroup)viewParent;
            int n = viewParent.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = viewParent.getChildAt(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(index)");
                if (!(view instanceof UiZoomDelegate)) continue;
                this.addCameraZoomDelegate((UiZoomDelegate)view);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
    }

    public void onDetachedFromWindow() {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        super.onDetachedFromWindow();
        zoomFinderOverlayView.r.clear();
    }

    @Override
    public void setInitialFinderViewSize() {
        int n;
        int n2;
        if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
            double d2 = this.getInitialPreviewWidth() != 0 && this.getInitialPreviewHeight() != 0 ? (double)this.getInitialPreviewWidth() / (double)this.getInitialPreviewHeight() : (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
            double d3 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() - d2;
            double d4 = d3 == 0.0 ? 0 : (d3 < 0.0 ? -1 : 1);
            n2 = d4 < 0 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d2);
            n = d4 < 0 ? (int)((double)this.getMeasuredWidth() / d2) : this.getMeasuredHeight();
        } else {
            ZoomFinderOverlayView zoomFinderOverlayView = this;
            n2 = zoomFinderOverlayView.getMeasuredWidth();
            n = zoomFinderOverlayView.getMeasuredHeight();
        }
        int n3 = n;
        n = n2 - this.getMinFinderPadding() * 2;
        int n4 = n3 - this.getMinFinderPadding() * 2;
        Object object = this.getRequiredAspectRatiosInternal();
        double d5 = object != null && (object = (FinderAspectRatio)CollectionsKt.firstOrNull(object)) != null ? ((FinderAspectRatio)object).getWidth() / ((FinderAspectRatio)object).getHeight() : 6.0;
        int n5 = this.getFixedFinderHeightInPx() < 0 ? 100 : this.getFixedFinderHeightInPx();
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        double d6 = (double)n5 * d5;
        float f2 = RangesKt.coerceIn((float)((float)n / (float)d6), (float)1.0f, (float)10.0f);
        zoomFinderOverlayView.s = f2 = RangesKt.coerceIn((float)(n4 / n5), (float)1.0f, (float)f2);
        zoomFinderOverlayView.setZoomLevel(RangesKt.coerceIn((float)zoomFinderOverlayView.t, (float)1.0f, (float)f2));
        int n6 = (zoomFinderOverlayView.getMeasuredHeight() - n5) / 2;
        int n7 = (zoomFinderOverlayView.getMeasuredWidth() - (int)d6) / 2;
        zoomFinderOverlayView.setPadding(n7, n6, n7, n6);
        zoomFinderOverlayView.adjustDescriptionPosition(n6);
        zoomFinderOverlayView.invalidate();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView$Companion;", "", "", "DEFAULT_ASPECT_RATIO", "D", "", "DEFAULT_HEIGHT", "I", "", "MAX_ZOOM", "F", "<init>", "()V", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

