/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010&\u001a\u00020#\u0012\u0006\u00107\u001a\u000204\u0012\u0006\u0010;\u001a\u000208\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0017\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0005\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0013\u0010\u001a\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001c\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0013\u0010\u001e\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0013\u0010 \u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0013\u0010\"\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0016\u0010&\u001a\u00020#8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0013\u0010(\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0013\u0010*\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0019R\u0013\u0010,\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019R\u0019\u00101\u001a\b\u0012\u0004\u0012\u00020.0-8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0013\u00103\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0019R\u0016\u00107\u001a\u0002048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u0010;\u001a\u0002088\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010>\u001a\u00020<8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010=R\u0013\u0010@\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0019R\u0013\u0010B\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0019R\u0013\u0010D\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0019R\u0013\u0010F\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0019\u00a8\u0006I"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "Ljava/io/File;", "a", "(Lio/scanbot/sdk/blob/BlobType;)Ljava/io/File;", "Lio/scanbot/sdk/entity/Blob;", "blob", "Landroid/net/Uri;", "blobUri", "", "(Lio/scanbot/sdk/entity/Blob;Landroid/net/Uri;)V", "(Lio/scanbot/sdk/entity/Blob;)V", "", "blobs", "", "allBlobsAvailable", "(Ljava/util/Collection;)Z", "isBlobAvailable", "(Lio/scanbot/sdk/entity/Blob;)Z", "fetch", "forceFetch", "(Lio/scanbot/sdk/blob/BlobType;)V", "getBlurEstimatorModelFile", "()Ljava/io/File;", "blurEstimatorModelFile", "getMrzCascadeFile", "mrzCascadeFile", "getIdCardScannerModelsFolderFile", "idCardScannerModelsFolderFile", "getBarcodeDetectionModelFile", "barcodeDetectionModelFile", "getFilterPredictionModelFile", "filterPredictionModelFile", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "b", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "getDcModelsFolderFile", "dcModelsFolderFile", "getGenericTextRecognizerModelsFolderFile", "genericTextRecognizerModelsFolderFile", "getImageProcessorModelsFolderFile", "imageProcessorModelsFolderFile", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "allLanguagesWithAvailableOcrBlobs", "getOcrBlobsDirectory", "ocrBlobsDirectory", "Landroid/content/res/AssetManager;", "c", "Landroid/content/res/AssetManager;", "assetManager", "Lio/scanbot/sdk/blob/BlobFactory;", "d", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "getChequeDigitPredictionModelFile", "chequeDigitPredictionModelFile", "getDocumentDetectorModelFile", "documentDetectorModelFile", "getBanksDataFile", "banksDataFile", "getBarcodeBinarizationModelFile", "barcodeBinarizationModelFile", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "sdk-base_release"})
public final class BlobManager {
    private final Logger a;
    private final BlobStoreStrategy b;
    private final AssetManager c;
    private final BlobFactory d;

    private final File a(BlobType blobType) throws IOException {
        File file = ((BlobManager)((Object)file)).b.getLocalFileFor(blobType);
        if (file.exists()) {
            return file;
        }
        throw new IOException("Can't get file for blob type: " + (Object)((Object)blobType));
    }

    private final void a(Blob blob, Uri uri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.c.open(uri.getPath()), (File)new File(blob.getLocalPath()));
    }

    private final void a(Blob blob) throws IOException {
        File file = new File(blob.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }

    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        BlobManager blobManager = this;
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)blobFactory, (String)"blobFactory");
        this.b = blobStoreStrategy;
        this.c = assetManager;
        blobManager.d = blobFactory;
        blobManager.a = LoggerProvider.getLogger();
    }

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> object) throws IOException {
        Collection<Blob> collection = object;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        object = collection.iterator();
        while (object.hasNext()) {
            if (this.isBlobAvailable((Blob)object.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        boolean bl;
        block5: {
            block4: {
                File file;
                Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                File file2 = file;
                file2(blob.getLocalPath());
                InputStream inputStream = ((BlobManager)((Object)inputStream)).c.open(blob.getRemotePath());
                try {
                    if (!file.exists()) break block4;
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                long l = inputStream.available();
                if (l != file2.length()) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        inputStream.close();
        return bl;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        BlobManager blobManager = enumSet;
        EnumSet<Language> enumSet = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.noneOf(Language::class.java)");
        File[] fileArray = blobManager.b.getOcrDataDirectory().listFiles();
        if (fileArray != null) {
            for (Object object : fileArray) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file");
                if (object.isDirectory()) continue;
                String string = FilenameUtils.removeExtension((String)object.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tessBlobName");
                object = Language.Companion.languageByTessTag(string);
                if (object == null) continue;
                enumSet.add((Language)((Object)object));
            }
            return enumSet;
        }
        return enumSet;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File file = ((BlobManager)((Object)file)).b.getOcrDataDirectory();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't get OCR blobs directory");
        }
        return file;
    }

    @NotNull
    public final File getBanksDataFile() throws IOException {
        return this.a(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeDetectionModelFile() throws IOException {
        return this.a(BlobType.BARCODE_DETECTION_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() throws IOException {
        return this.a(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.a(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() throws IOException {
        return this.a(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.a(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getChequeDigitPredictionModelFile() throws IOException {
        return this.a(BlobType.CHEQUE_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() throws IOException {
        return this.a(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() throws IOException {
        return this.b.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getGenericTextRecognizerModelsFolderFile() throws IOException {
        return this.b.getLocalFileFor(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() throws IOException {
        return this.b.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() throws IOException {
        return this.b.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    public final void fetch(@NotNull Blob blob) throws IOException {
        Blob blob2 = blob;
        Intrinsics.checkNotNullParameter((Object)blob2, (String)"blob");
        if (blobManager2.isBlobAvailable(blob2)) {
            return;
        }
        BlobManager blobManager = blobManager2;
        Blob blob3 = blob;
        blobManager2.a(blob);
        BlobManager blobManager2 = Uri.parse((String)blob3.getRemotePath());
        Intrinsics.checkNotNullExpressionValue((Object)blobManager2, (String)"blobUri");
        blobManager.a(blob3, (Uri)blobManager2);
    }

    public final void forceFetch(@NotNull BlobType object) throws IOException {
        Intrinsics.checkNotNullParameter((Object)object, (String)"blobType");
        object = this.d.getBlobsForType((BlobType)((Object)object)).iterator();
        while (object.hasNext()) {
            this.fetch((Blob)object.next());
        }
    }
}

