/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0019\u0010\r\u001a\u00020\b8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0011\u001a\u00020\u000e8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "", "Ljava/io/File;", "getBarcodeImagesDirectory", "()Ljava/io/File;", "", "cleanupBarcodeImagesDirectory", "()V", "Landroid/app/Application;", "b", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "application", "", "a", "Ljava/lang/String;", "sdkBarcodeImagesFolderName", "<init>", "(Landroid/app/Application;)V", "sdk-base_release"})
public final class BarcodeFileStorage {
    private final String a;
    @NotNull
    private final Application b;

    public BarcodeFileStorage(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.b = application;
        this.a = "barcode_images";
    }

    @NotNull
    public final File getBarcodeImagesDirectory() throws IOException {
        String string = PreferenceManager.getDefaultSharedPreferences((Context)this.b).getString("CUSTOM_SDK_FILES_PATH", "");
        return FileUtils.ensureDirExists(string) ? FileUtils.getFilesDirOrShowError(string, this.a) : FileUtils.getFilesDirOrShowError(FileUtils.getAppFilesDirOrShowError((Context)this.b, "scanbot-sdk").getPath(), this.a);
    }

    public final void cleanupBarcodeImagesDirectory() {
        File[] fileArray = fileArray.getBarcodeImagesDirectory().listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"getBarcodeImagesDirectory().listFiles()");
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                org.apache.commons.io.FileUtils.deleteQuietly((File)fileArray[i]);
            }
            catch (Exception exception) {
                LoggerProvider.getLogger().logException(exception);
                break;
            }
            continue;
        }
    }

    @NotNull
    public final Application getApplication() {
        return this.b;
    }
}

