/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0006J\u001f\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001eJ\u0017\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001fJ\u0017\u0010 \u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010\u0006J\u0017\u0010#\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010#\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b#\u0010\u001eR\u0016\u0010'\u001a\u00020%8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010&\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils;", "", "Landroidx/camera/core/ImageProxy;", "image", "", "imageToJpegByteArray", "(Landroidx/camera/core/ImageProxy;)[B", "data", "Landroid/graphics/Rect;", "cropRect", "cropByteArray", "([BLandroid/graphics/Rect;)[B", "Landroid/util/Size;", "sourceSize", "Landroid/util/Rational;", "aspectRatio", "computeCropRectFromAspectRatio", "(Landroid/util/Size;Landroid/util/Rational;)Landroid/graphics/Rect;", "rational", "", "rotation", "rotate", "(Landroid/util/Rational;I)Landroid/util/Rational;", "nv21", "width", "height", "a", "([BIILandroid/graphics/Rect;)[B", "c", "", "(Landroid/util/Size;Landroid/util/Rational;)Z", "(Landroid/util/Rational;)Landroid/util/Rational;", "b", "(Landroidx/camera/core/ImageProxy;)Z", "d", "isAspectRatioValid", "(Landroid/util/Rational;)Z", "", "Ljava/lang/String;", "TAG", "<init>", "()V", "CodecFailedException", "sdk-base_release"})
public final class CameraXImageUtils {
    private static final String a = "ImageUtil";
    public static final CameraXImageUtils b = new CameraXImageUtils();

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy imageProxy) throws CodecFailedException {
        ImageProxy imageProxy2 = imageProxy;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        byte[] byArray = null;
        int n = imageProxy2.getFormat();
        if (n != 35) {
            if (n != 256) {
                Log.w((String)a, (String)("Unrecognized image format: " + imageProxy.getFormat()));
            } else {
                byArray = b.a(imageProxy);
            }
        } else {
            byArray = b.d(imageProxy);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] byArray, @Nullable Rect rect) throws CodecFailedException {
        block7: {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
            if (rect == null) {
                return byArray;
            }
            int n = 0;
            Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n, (int)byArray.length, (boolean)false);
            rect = object.decodeRegion(rect, new BitmapFactory.Options());
            try {
                object.recycle();
                if (rect == null) break block7;
            }
            catch (IOException iOException) {
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException, CodecFailedException.FailureType.DECODE_FAILED);
            }
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (rect.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                rect.recycle();
                byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
                return byArray2;
            }
            throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
    }

    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size size, @NotNull Rational rational) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)rational, (String)"aspectRatio");
        if (!b.isAspectRatioValid(rational)) {
            Log.w((String)a, (String)"Invalid view ratio.");
            return null;
        }
        Rational rational2 = rational;
        int n = size.getWidth();
        int n2 = size.getHeight();
        float f2 = n;
        float f3 = n2;
        float f4 = f2 / f3;
        int n3 = 0;
        int n4 = 0;
        int n5 = rational2.getNumerator();
        int n6 = rational2.getDenominator();
        if (rational2.floatValue() > f4) {
            int n7 = n2;
            n2 = Math.round(f2 / (float)n5 * (float)n6);
            n4 = (n7 - n2) / 2;
        } else {
            int n8 = n;
            n = Math.round(f3 / (float)n6 * (float)n5);
            n3 = (n8 - n) / 2;
        }
        n = n3 + n;
        n2 = n4 + n2;
        return new Rect(n3, n4, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int n) {
        Intrinsics.checkNotNullParameter((Object)rational, (String)"rational");
        if (n == 90 || n == 270) {
            rational = b.a(rational);
        }
        return rational;
    }

    private final byte[] a(byte[] byArray, int n, int n2, Rect rect) throws CodecFailedException {
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(byArray, 17, n, n2, null);
        if (rect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, n, n2);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
            return byArray2;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    private final byte[] c(ImageProxy imageProxy) {
        ImageProxy imageProxy2 = imageProxy;
        CameraXImageUtils cameraXImageUtils = imageProxy2.getPlanes()[0];
        ImageProxy imageProxy3 = imageProxy;
        ImageProxy.PlaneProxy planeProxy = imageProxy3.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy2 = imageProxy3.getPlanes()[2];
        Intrinsics.checkNotNullExpressionValue((Object)cameraXImageUtils, (String)"yPlane");
        ByteBuffer byteBuffer = cameraXImageUtils.getBuffer();
        ImageProxy.PlaneProxy planeProxy3 = planeProxy2;
        ImageProxy.PlaneProxy planeProxy4 = planeProxy;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"yPlane.buffer");
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy4, (String)"uPlane");
        ByteBuffer byteBuffer2 = planeProxy4.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"uPlane.buffer");
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"vPlane");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"vPlane.buffer");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n = byteBuffer.remaining();
        int n2 = 0;
        byte[] byArray = new byte[n + imageProxy.getWidth() * imageProxy.getHeight() / 2];
        int n3 = imageProxy2.getHeight();
        for (int j = 0; j < n3; ++j) {
            byteBuffer.get(byArray, n2, imageProxy.getWidth());
            n2 += imageProxy.getWidth();
            byteBuffer.position(Math.min(n, byteBuffer.position() - imageProxy.getWidth() + cameraXImageUtils.getRowStride()));
        }
        ImageProxy imageProxy4 = imageProxy;
        int n4 = imageProxy4.getHeight() / 2;
        int n5 = imageProxy4.getWidth() / 2;
        int n6 = planeProxy2.getRowStride();
        n = planeProxy.getRowStride();
        int n7 = planeProxy2.getPixelStride();
        int n8 = planeProxy.getPixelStride();
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n];
        for (int j = 0; j < n4; ++j) {
            byteBuffer3.get(byArray2, 0, Math.min(n6, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n, byteBuffer2.remaining()));
            int n9 = 0;
            int n10 = 0;
            for (int k = 0; k < n5; ++k) {
                int n11 = n2 + 1;
                byArray[n2] = byArray2[n9];
                n2 = n11 + 1;
                byArray[n11] = byArray3[n10];
                n9 += n7;
                n10 += n8;
            }
        }
        return byArray;
    }

    private final boolean a(Size size, Rational rational) {
        int n;
        float f2;
        Size size2 = size;
        int n2 = size2.getWidth();
        int n3 = size2.getHeight();
        Rational rational2 = rational;
        int n4 = rational2.getNumerator();
        float f3 = n4;
        return n3 != Math.round((float)n2 / f3 * (f2 = (float)(n = rational2.getDenominator()))) || n2 != Math.round((float)n3 / f2 * f3);
    }

    private final Rational a(Rational rational) {
        CameraXImageUtils cameraXImageUtils;
        if (rational == null) {
            cameraXImageUtils = rational;
        } else {
            Rational rational2;
            cameraXImageUtils = rational2;
            Rational rational3 = rational;
            int n = rational3.getDenominator();
            rational2 = new Rational(n, rational3.getNumerator());
        }
        return cameraXImageUtils;
    }

    private final boolean b(ImageProxy imageProxy) {
        Size size;
        CameraXImageUtils cameraXImageUtils = size;
        ImageProxy imageProxy2 = imageProxy;
        int n = imageProxy2.getWidth();
        size = new Size(n, imageProxy2.getHeight());
        return Intrinsics.areEqual((Object)new Size(imageProxy.getCropRect().width(), imageProxy.getCropRect().height()), (Object)cameraXImageUtils) ^ true;
    }

    private final byte[] a(ImageProxy imageProxy) throws CodecFailedException {
        CameraXImageUtils cameraXImageUtils = object;
        ImageProxy imageProxy2 = imageProxy;
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        ImageProxy.PlaneProxy planeProxy = planeProxyArray[0];
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[0]");
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.capacity()];
        Object object = byArray;
        byteBuffer.get(byArray);
        if (cameraXImageUtils.b(imageProxy2)) {
            object = CameraXImageUtils.cropByteArray((byte[])object, imageProxy.getCropRect());
        }
        return object;
    }

    private final byte[] d(ImageProxy object) throws CodecFailedException {
        ImageProxy imageProxy = object;
        byte[] byArray = this.c((ImageProxy)object);
        int n = imageProxy.getWidth();
        int n2 = imageProxy.getHeight();
        object = this.b(imageProxy) ? object.getCropRect() : null;
        return this.a(byArray, n, n2, (Rect)object);
    }

    private CameraXImageUtils() {
    }

    public final boolean isAspectRatioValid(@Nullable Rational rational) {
        return rational != null && rational.floatValue() > 0.0f && !rational.isNaN();
    }

    public final boolean isAspectRatioValid(@NotNull Size size, @Nullable Rational rational) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        return rational != null && rational.floatValue() > 0.0f && this.a(size, rational) && !rational.isNaN();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\u000fB\u0013\b\u0010\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rB\u001b\b\u0010\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\u000eR$\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "<set-?>", "a", "Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "getFailureType", "()Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "failureType", "", "message", "<init>", "(Ljava/lang/String;)V", "(Ljava/lang/String;Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;)V", "FailureType", "sdk-base_release"})
    public static final class CodecFailedException
    extends Exception {
        @NotNull
        private FailureType a;

        public CodecFailedException(@Nullable String string) {
            super(string);
            this.a = FailureType.UNKNOWN;
        }

        public CodecFailedException(@Nullable String string, @NotNull FailureType failureType) {
            Intrinsics.checkNotNullParameter((Object)((Object)failureType), (String)"failureType");
            super(string);
            this.a = failureType;
        }

        @NotNull
        public final FailureType getFailureType() {
            return this.a;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraXImageUtils$CodecFailedException$FailureType;", "", "<init>", "(Ljava/lang/String;I)V", "ENCODE_FAILED", "DECODE_FAILED", "UNKNOWN", "sdk-base_release"})
        public static final class FailureType
        extends Enum<FailureType> {
            public static final /* enum */ FailureType ENCODE_FAILED;
            public static final /* enum */ FailureType DECODE_FAILED;
            public static final /* enum */ FailureType UNKNOWN;
            private static final /* synthetic */ FailureType[] a;

            static {
                FailureType failureType;
                FailureType failureType2;
                FailureType failureType3;
                FailureType[] failureTypeArray = new FailureType[3];
                FailureType failureType4 = failureType3;
                ENCODE_FAILED = new FailureType();
                failureTypeArray[0] = failureType4;
                failureType4 = failureType2;
                DECODE_FAILED = new FailureType();
                failureTypeArray[1] = failureType4;
                failureType4 = failureType;
                UNKNOWN = new FailureType();
                failureTypeArray[2] = failureType4;
                a = failureTypeArray;
            }

            public static FailureType[] values() {
                return (FailureType[])a.clone();
            }

            public static FailureType valueOf(String string) {
                return Enum.valueOf(FailureType.class, string);
            }
        }
    }
}

