/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.graphics.PointF;
import android.hardware.Camera;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010X\u001a\u00020W\u00a2\u0006\u0004\bY\u0010ZJ7\u0010\n\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00060\u0006R\u00020\u00072\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u000e\u001a\u00060\tR\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0018\u001a\u00060\tR\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\b\u001a\u00060\u0006R\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010'\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010+\u001a\u00020\u00112\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010-\u001a\u00020\u00112\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b-\u0010,J\u001b\u0010/\u001a\u00020\u00112\f\u0010.\u001a\b\u0018\u00010\tR\u00020\u0007\u00a2\u0006\u0004\b/\u00100J\u001b\u00102\u001a\u00020\u00112\f\u00101\u001a\b\u0018\u00010\tR\u00020\u0007\u00a2\u0006\u0004\b2\u00100J\u0015\u00104\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u001a\u00a2\u0006\u0004\b4\u00105J\u0015\u00107\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u001a\u00a2\u0006\u0004\b7\u00105J\u001b\u0010;\u001a\u00020\u00112\f\u0010:\u001a\b\u0012\u0004\u0012\u00020908\u00a2\u0006\u0004\b;\u0010<R\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020)0=8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010>R\u0016\u0010B\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u001c\u0010.\u001a\b\u0018\u00010\tR\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0016\u00106\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001c\u00101\u001a\b\u0018\u00010\tR\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010DR\u0016\u00103\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010FR\"\u0010P\u001a\u00020I8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0016\u0010T\u001a\u00020Q8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u001c\u0010:\u001a\b\u0012\u0004\u0012\u000209088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010V\u00a8\u0006["}, d2={"Lio/scanbot/sdk/camera/CameraHost;", "Lcom/commonsware/cwac/camera/SimpleCameraHost;", "", "displayOrientation", "width", "height", "Landroid/hardware/Camera$Parameters;", "Landroid/hardware/Camera;", "parameters", "Landroid/hardware/Camera$Size;", "a", "(IIILandroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "adjustPreviewParameters", "(Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Parameters;", "getPreviewSize", "Landroid/hardware/Camera$ShutterCallback;", "shutterCallback", "", "setShutterCallback", "(Landroid/hardware/Camera$ShutterCallback;)V", "getShutterCallback", "()Landroid/hardware/Camera$ShutterCallback;", "Lcom/commonsware/cwac/camera/PictureTransaction;", "xact", "getPictureSize", "(Lcom/commonsware/cwac/camera/PictureTransaction;Landroid/hardware/Camera$Parameters;)Landroid/hardware/Camera$Size;", "", "useFullBleedPreview", "()Z", "Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "getRecordingHint", "()Lcom/commonsware/cwac/camera/CameraHost$RecordingHint;", "", "image", "imageOrientation", "saveImage", "(Lcom/commonsware/cwac/camera/PictureTransaction;[BI)V", "success", "camera", "onAutoFocus", "(ZLandroid/hardware/Camera;)V", "Lio/scanbot/sdk/camera/BasePictureCallback;", "pictureCallback", "addPictureCallback", "(Lio/scanbot/sdk/camera/BasePictureCallback;)V", "removePictureCallback", "defaultPictureSize", "setDefaultPictureSize", "(Landroid/hardware/Camera$Size;)V", "defaultPreviewSize", "setDefaultPreviewSize", "autoFocusSoundEnabled", "setAutoFocusSound", "(Z)V", "shutterSoundEnabled", "setShutterSound", "", "Landroid/graphics/PointF;", "currentFinderRectF", "setCurrentFinderRectF", "(Ljava/util/List;)V", "", "Ljava/util/Set;", "pictureCallbacks", "g", "Landroid/hardware/Camera$ShutterCallback;", "shutterListener", "c", "Landroid/hardware/Camera$Size;", "f", "Z", "d", "e", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "i", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "getPreviewMode", "()Lio/scanbot/sdk/camera/CameraPreviewMode;", "setPreviewMode", "(Lio/scanbot/sdk/camera/CameraPreviewMode;)V", "previewMode", "Lio/scanbot/sdk/util/log/Logger;", "b", "Lio/scanbot/sdk/util/log/Logger;", "logger", "h", "Ljava/util/List;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "sdk-base_release"})
public final class CameraHost
extends SimpleCameraHost {
    private final Set<BasePictureCallback> a;
    private final Logger b;
    private Camera.Size c;
    private Camera.Size d;
    private boolean e;
    private boolean f;
    private Camera.ShutterCallback g;
    private List<? extends PointF> h;
    @NotNull
    private CameraPreviewMode i;

    private final Camera.Size a(int n, int n2, int n3, Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        cameraHost.b.logMethod();
        CameraHost cameraHost = Utils.getLargestPictureSize(parameters2);
        List list = parameters2.getSupportedPreviewSizes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameters.supportedPreviewSizes");
        return Utils.getLargestSizeWithAspectRatioMatch(list, (double)((Camera.Size)cameraHost).width / (double)((Camera.Size)cameraHost).height);
    }

    public CameraHost(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.a = new LinkedHashSet<BasePictureCallback>();
        this.b = LoggerProvider.getLogger();
        this.e = true;
        this.f = true;
        this.g = io.scanbot.sdk.camera.CameraHost$a.a;
        this.h = CollectionsKt.emptyList();
        this.i = CameraPreviewMode.FILL_IN;
    }

    @NotNull
    public final CameraPreviewMode getPreviewMode() {
        return this.i;
    }

    public final void setPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraPreviewMode), (String)"<set-?>");
        this.i = cameraPreviewMode;
    }

    @NotNull
    public Camera.Parameters adjustPreviewParameters(@NotNull Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.b.logMethod();
        super.adjustPreviewParameters(parameters);
        parameters2.setPreviewFormat(17);
        return parameters2;
    }

    @NotNull
    public Camera.Size getPreviewSize(int n, int n2, int n3, @NotNull Camera.Parameters parameters) {
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        cameraHost.b.logMethod();
        Camera.Size size = cameraHost.d;
        if (size == null) {
            size = this.a(n, n2, n3, parameters);
        }
        return size;
    }

    public final void setShutterCallback(@NotNull Camera.ShutterCallback shutterCallback) {
        Intrinsics.checkNotNullParameter((Object)shutterCallback, (String)"shutterCallback");
        this.g = shutterCallback;
    }

    @Nullable
    public Camera.ShutterCallback getShutterCallback() {
        return this.f ? this.g : null;
    }

    @NotNull
    public Camera.Size getPictureSize(@Nullable PictureTransaction pictureTransaction, @NotNull Camera.Parameters parameters) {
        CameraHost cameraHost = cameraHost2;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        cameraHost.b.logMethod();
        CameraHost cameraHost2 = cameraHost.c;
        if (cameraHost2 == null) {
            cameraHost2 = Utils.getLargestPictureSize(parameters);
        }
        return cameraHost2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useFullBleedPreview() {
        int n = this.i.ordinal();
        if (n == 0) return false;
        if (n != 1) throw new NoWhenBranchMatchedException();
        return true;
    }

    @NotNull
    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveImage(@NotNull PictureTransaction object, @NotNull byte[] byArray, int n) {
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)object, (String)"xact");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"image");
        cameraHost.b.logMethod();
        object = cameraHost.a;
        synchronized (object) {
            Iterator<BasePictureCallback> iterator = cameraHost.a.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                iterator.next().onPictureTakenInternal(byArray, n, this.h);
            }
        }
    }

    public void onAutoFocus(boolean bl, @NotNull Camera camera) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (this.e) {
            super.onAutoFocus(bl, camera);
        }
    }

    public final void addPictureCallback(@NotNull BasePictureCallback basePictureCallback) {
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)basePictureCallback, (String)"pictureCallback");
        cameraHost.b.logMethod();
        Set<BasePictureCallback> set = cameraHost.a;
        synchronized (set) {
            this.a.add(basePictureCallback);
            return;
        }
    }

    public final void removePictureCallback(@NotNull BasePictureCallback basePictureCallback) {
        CameraHost cameraHost = this;
        Intrinsics.checkNotNullParameter((Object)basePictureCallback, (String)"pictureCallback");
        cameraHost.b.logMethod();
        Set<BasePictureCallback> set = cameraHost.a;
        synchronized (set) {
            this.a.remove(basePictureCallback);
            return;
        }
    }

    public final void setDefaultPictureSize(@Nullable Camera.Size size) {
        this.c = size;
    }

    public final void setDefaultPreviewSize(@Nullable Camera.Size size) {
        this.d = size;
    }

    public final void setAutoFocusSound(boolean bl) {
        this.e = bl;
    }

    public final void setShutterSound(boolean bl) {
        this.f = bl;
    }

    public final void setCurrentFinderRectF(@NotNull List<? extends PointF> list) {
        Intrinsics.checkNotNullParameter(list, (String)"currentFinderRectF");
        this.h = list;
    }
}

