/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsDirectoryException;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsException;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010F\u001a\u00020C\u0012\u0006\u0010J\u001a\u00020G\u0012\u0006\u00101\u001a\u00020.\u00a2\u0006\u0004\bN\u0010OJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0017\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0005\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0015\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u00020\u00188\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\"\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010$\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0013\u0010&\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u001c\u0010*\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010)\u001a\u0004\b'\u0010!R\u001c\u0010-\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010)\u001a\u0004\b+\u0010!R\u0016\u00101\u001a\u00020.8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0013\u00103\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b2\u0010!R\u001c\u00106\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b5\u0010)\u001a\u0004\b4\u0010!R\u0013\u00108\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b7\u0010!R\u0013\u0010:\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\b9\u0010!R\u001c\u0010=\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b<\u0010)\u001a\u0004\b;\u0010!R\u001c\u0010@\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010)\u001a\u0004\b>\u0010!R\u0013\u0010B\u001a\u00020\u00048F@\u0006\u00a2\u0006\u0006\u001a\u0004\bA\u0010!R\u0016\u0010F\u001a\u00020C8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010J\u001a\u00020G8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u001c\u0010M\u001a\u00020\u00048F@\u0007X\u0087\u0004\u00a2\u0006\f\u0012\u0004\bL\u0010)\u001a\u0004\bK\u0010!\u00a8\u0006P"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "Ljava/io/File;", "a", "(Lio/scanbot/sdk/blob/BlobType;)Ljava/io/File;", "Lio/scanbot/sdk/entity/Blob;", "blob", "Landroid/net/Uri;", "blobUri", "", "(Lio/scanbot/sdk/entity/Blob;Landroid/net/Uri;)V", "(Lio/scanbot/sdk/entity/Blob;)V", "", "blobs", "", "allBlobsAvailable", "(Ljava/util/Collection;)Z", "isBlobAvailable", "(Lio/scanbot/sdk/entity/Blob;)Z", "fetch", "forceFetch", "(Lio/scanbot/sdk/blob/BlobType;)V", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "allLanguagesWithAvailableOcrBlobs", "getOcrBlobsDirectory", "()Ljava/io/File;", "ocrBlobsDirectory", "getMrzCascadeFile", "mrzCascadeFile", "getImageProcessorModelsFolderFile", "imageProcessorModelsFolderFile", "getBarcodeBinarizationModelFile", "getBarcodeBinarizationModelFile$annotations", "()V", "barcodeBinarizationModelFile", "getIdCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile$annotations", "idCardScannerModelsFolderFile", "Lio/scanbot/sdk/blob/BlobFactory;", "d", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "getBlurEstimatorModelFile", "blurEstimatorModelFile", "getDcModelsFolderFile", "getDcModelsFolderFile$annotations", "dcModelsFolderFile", "getChequeDigitPredictionModelFile", "chequeDigitPredictionModelFile", "getFilterPredictionModelFile", "filterPredictionModelFile", "getDocumentDetectorModelFile", "getDocumentDetectorModelFile$annotations", "documentDetectorModelFile", "getGenericTextRecognizerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile$annotations", "genericTextRecognizerModelsFolderFile", "getBanksDataFile", "banksDataFile", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "b", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Landroid/content/res/AssetManager;", "c", "Landroid/content/res/AssetManager;", "assetManager", "getBarcodeDetectionModelFile", "getBarcodeDetectionModelFile$annotations", "barcodeDetectionModelFile", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "sdk-base_release"})
public final class BlobManager {
    private final Logger a;
    private final BlobStoreStrategy b;
    private final AssetManager c;
    private final BlobFactory d;

    @Deprecated(level=DeprecationLevel.WARNING, message="barcodeDetectionModel is outdated and removed from the library assets.")
    public static /* synthetic */ void getBarcodeDetectionModelFile$annotations() {
    }

    @Deprecated(level=DeprecationLevel.WARNING, message="barcodeBinarizationModel is outdated and removed from the library assets.")
    public static /* synthetic */ void getBarcodeBinarizationModelFile$annotations() {
    }

    @Deprecated(level=DeprecationLevel.WARNING, message="dc_forms_models files are outdated and removed from the library assets.")
    public static /* synthetic */ void getDcModelsFolderFile$annotations() {
    }

    @Deprecated(level=DeprecationLevel.WARNING, message="idCardScannerModelsFolderFile is outdated and removed from the library assets.")
    public static /* synthetic */ void getIdCardScannerModelsFolderFile$annotations() {
    }

    @Deprecated(level=DeprecationLevel.WARNING, message="genericTextRecognizerModelsFolderFile is outdated and removed from the library assets.")
    public static /* synthetic */ void getGenericTextRecognizerModelsFolderFile$annotations() {
    }

    @Deprecated(level=DeprecationLevel.WARNING, message="documentDetectorModelFile is outdated and removed from the library assets.")
    public static /* synthetic */ void getDocumentDetectorModelFile$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final File a(BlobType blobType) throws IOException {
        void var1_1;
        File this_ = ((BlobManager)((Object)this_)).b.getLocalFileFor((BlobType)var1_1);
        if (this_.exists()) {
            return this_;
        }
        throw new BlobsException("Can't get file for blob type: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Blob blob, Uri blobUri) throws IOException {
        String string = blobUri.getPath();
        if (string != null) {
            void var1_1;
            FileUtils.copyInputStreamToFile((InputStream)this.c.open(string), (File)new File(var1_1.getLocalPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Blob blob) throws IOException {
        void var1_1;
        File file = new File(var1_1.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new BlobsDirectoryException("Can't create destination directory");
        }
    }

    /*
     * WARNING - void declaration
     */
    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        BlobManager blobManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobFactory");
        this.b = var1_1;
        this.c = var2_2;
        blobManager.d = var3_3;
        blobManager.a = LoggerProvider.getLogger();
    }

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) throws IOException {
        Collection<Blob> collection = blobs;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        Iterator<Blob> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isBlobAvailable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        boolean bl;
        block5: {
            block4: {
                void var1_1;
                File file;
                Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                File file2 = file;
                file2(var1_1.getLocalPath());
                InputStream inputStream = ((BlobManager)((Object)inputStream)).c.open(var1_1.getRemotePath());
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(blob.remotePath)");
                try {
                    if (!file.exists()) break block4;
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                long l = inputStream.available();
                if (l != file2.length()) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        inputStream.close();
        return bl;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        BlobManager blobManager = this_;
        EnumSet<Language> this_ = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(this_, (String)"EnumSet.noneOf(Language::class.java)");
        File[] fileArray = blobManager.b.getOcrDataDirectory().listFiles();
        if (fileArray != null) {
            for (Object object : fileArray) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file");
                if (object.isDirectory()) continue;
                String string = FilenameUtils.removeExtension((String)object.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tessBlobName");
                object = Language.Companion.languageByTessTag(string);
                if (object == null) continue;
                this_.add((Language)((Object)object));
            }
            return this_;
        }
        return this_;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File this_ = ((BlobManager)((Object)this_)).b.getOcrDataDirectory();
        if (!this_.exists() && !this_.mkdirs()) {
            throw new BlobsDirectoryException("Can't get OCR blobs directory");
        }
        return this_;
    }

    @NotNull
    public final File getBanksDataFile() throws IOException {
        return this.a(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeDetectionModelFile() {
        return this.b.getLocalFileFor(BlobType.BARCODE_DETECTION_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() {
        return this.b.getLocalFileFor(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.a(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() throws IOException {
        return this.a(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.a(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getChequeDigitPredictionModelFile() throws IOException {
        return this.a(BlobType.CHEQUE_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() {
        return this.b.getLocalFileFor(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() {
        return this.b.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getGenericTextRecognizerModelsFolderFile() {
        return this.b.getLocalFileFor(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() {
        return this.b.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() throws IOException {
        return this.b.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch(@NotNull Blob blob) throws IOException {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"blob");
        if (this_.isBlobAvailable((Blob)v0)) {
            return;
        }
        BlobManager blobManager = this_;
        void v2 = var1_1;
        this_.a((Blob)var1_1);
        BlobManager this_ = Uri.parse((String)v2.getRemotePath());
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"blobUri");
        blobManager.a((Blob)v2, (Uri)this_);
    }

    public final void forceFetch(@NotNull BlobType blobType) throws IOException {
        Iterator<Blob> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"blobType");
        iterator = this.d.getBlobsForType((BlobType)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            this.fetch(iterator.next());
        }
    }
}

