/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b/\u00100J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0006J\u001f\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001eJ\u0017\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001fJ\u0017\u0010 \u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010\u0006J'\u0010%\u001a\u00020\u00042\u0006\u0010$\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b%\u0010&J'\u0010\u001a\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010)J\u0017\u0010*\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010*\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b*\u0010\u001eR\u0016\u0010.\u001a\u00020,8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010-\u00a8\u00061"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraImageUtils;", "", "Landroidx/camera/core/ImageProxy;", "image", "", "imageToJpegByteArray", "(Landroidx/camera/core/ImageProxy;)[B", "data", "Landroid/graphics/Rect;", "cropRect", "cropByteArray", "([BLandroid/graphics/Rect;)[B", "Landroid/util/Size;", "sourceSize", "Landroid/util/Rational;", "aspectRatio", "computeCropRectFromAspectRatio", "(Landroid/util/Size;Landroid/util/Rational;)Landroid/graphics/Rect;", "rational", "", "rotation", "rotate", "(Landroid/util/Rational;I)Landroid/util/Rational;", "nv21", "width", "height", "a", "([BIILandroid/graphics/Rect;)[B", "c", "", "(Landroid/util/Size;Landroid/util/Rational;)Z", "(Landroid/util/Rational;)Landroid/util/Rational;", "b", "(Landroidx/camera/core/ImageProxy;)Z", "d", "Landroid/graphics/Bitmap;", "src", "bitmapToNv21", "(Landroid/graphics/Bitmap;II)[B", "", "argb", "([III)[B", "isAspectRatioValid", "(Landroid/util/Rational;)Z", "", "Ljava/lang/String;", "TAG", "<init>", "()V", "sdk-base_release"})
public final class CameraImageUtils {
    private static final String a = "ImageUtil";
    @NotNull
    public static final CameraImageUtils INSTANCE = new CameraImageUtils();

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) throws CodecFailedException {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        byte[] byArray = null;
        int n = imageProxy2.getFormat();
        if (n != 35) {
            if (n != 256) {
                Log.w((String)a, (String)("Unrecognized image format: " + imageProxy.getFormat()));
            } else {
                byArray = INSTANCE.a(imageProxy);
            }
        } else {
            byArray = INSTANCE.d(imageProxy);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) throws CodecFailedException {
        block7: {
            ByteArrayOutputStream byteArrayOutputStream;
            Bitmap bitmap;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
            if (cropRect == null) {
                return byArray;
            }
            int n = 0;
            Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n, (int)byArray.length, (boolean)false);
            bitmap = object.decodeRegion((Rect)bitmap, new BitmapFactory.Options());
            try {
                object.recycle();
                if (bitmap == null) break block7;
            }
            catch (IOException iOException) {
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException, CodecFailedException.FailureType.DECODE_FAILED);
            }
            object = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                bitmap.recycle();
                byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
                return byArray2;
            }
            throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        void var1_2;
        Size size;
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid((Rational)var1_2)) {
            Log.w((String)a, (String)"Invalid view ratio.");
            return null;
        }
        void v0 = var1_2;
        int n = size.getWidth();
        int n2 = size.getHeight();
        float f2 = n;
        float f3 = n2;
        float f4 = f2 / f3;
        int n3 = 0;
        int n4 = 0;
        int n5 = v0.getNumerator();
        int n6 = v0.getDenominator();
        if (v0.floatValue() > f4) {
            int n7 = n2;
            n2 = Math.round(f2 / (float)n5 * (float)n6);
            n4 = (n7 - n2) / 2;
        } else {
            int n8 = n;
            n = Math.round(f3 / (float)n6 * (float)n5);
            n3 = (n8 - n) / 2;
        }
        n = n3 + n;
        n2 = n4 + n2;
        return new Rect(n3, n4, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        void var1_1;
        Rational rational2;
        Intrinsics.checkNotNullParameter((Object)rational2, (String)"rational");
        if (rotation == 90 || var1_1 == 270) {
            rational2 = INSTANCE.a(rational2);
        }
        return rational2;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(byte[] nv21, int width, int height, Rect cropRect) throws CodecFailedException {
        Rect rect;
        void var3_3;
        void var2_2;
        void var1_1;
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage((byte[])var1_1, 17, (int)var2_2, (int)var3_3, null);
        if (cropRect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, (int)var2_2, (int)var3_3);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
            return byArray;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] c(ImageProxy image) {
        void var1_2;
        ImageProxy imageProxy = image;
        CameraImageUtils cameraImageUtils = imageProxy.getPlanes()[0];
        void v1 = var1_2;
        ImageProxy.PlaneProxy planeProxy = v1.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy2 = v1.getPlanes()[2];
        Intrinsics.checkNotNullExpressionValue((Object)cameraImageUtils, (String)"yPlane");
        ByteBuffer byteBuffer = cameraImageUtils.getBuffer();
        ImageProxy.PlaneProxy planeProxy3 = planeProxy2;
        ImageProxy.PlaneProxy planeProxy4 = planeProxy;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"yPlane.buffer");
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy4, (String)"uPlane");
        ByteBuffer byteBuffer2 = planeProxy4.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"uPlane.buffer");
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"vPlane");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"vPlane.buffer");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n = byteBuffer.remaining();
        int n2 = 0;
        byte[] byArray = new byte[n + var1_2.getWidth() * var1_2.getHeight() / 2];
        int n3 = imageProxy.getHeight();
        for (int k = 0; k < n3; ++k) {
            byteBuffer.get(byArray, n2, var1_2.getWidth());
            n2 += var1_2.getWidth();
            byteBuffer.position(Math.min(n, byteBuffer.position() - var1_2.getWidth() + cameraImageUtils.getRowStride()));
        }
        void v4 = var1_2;
        int n4 = v4.getHeight() / 2;
        int n5 = v4.getWidth() / 2;
        int n6 = planeProxy2.getRowStride();
        n = planeProxy.getRowStride();
        int n7 = planeProxy2.getPixelStride();
        int n8 = planeProxy.getPixelStride();
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n];
        for (int k = 0; k < n4; ++k) {
            byteBuffer3.get(byArray2, 0, Math.min(n6, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n, byteBuffer2.remaining()));
            int n9 = 0;
            int n10 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n11 = n2 + 1;
                byArray[n2] = byArray2[n9];
                n2 = n11 + 1;
                byArray[n11] = byArray3[n10];
                n9 += n7;
                n10 += n8;
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean a(Size sourceSize, Rational aspectRatio) {
        int n;
        float f2;
        void var2_4;
        Size size = sourceSize;
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        void v1 = var2_4;
        int n4 = v1.getNumerator();
        float f3 = n4;
        return n3 != Math.round((float)n2 / f3 * (f2 = (float)(n = v1.getDenominator()))) || n2 != Math.round((float)n3 / f2 * f3);
    }

    /*
     * WARNING - void declaration
     */
    private final Rational a(Rational rational) {
        CameraImageUtils cameraImageUtils;
        void var1_1;
        if (rational == null) {
            cameraImageUtils = var1_1;
        } else {
            Rational rational2;
            cameraImageUtils = rational2;
            void v1 = var1_1;
            int n = v1.getDenominator();
            rational2 = new Rational(n, v1.getNumerator());
        }
        return cameraImageUtils;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean b(ImageProxy image) {
        void var1_1;
        Size size;
        CameraImageUtils cameraImageUtils = size;
        void v1 = var1_1;
        int n = v1.getWidth();
        size = new Size(n, v1.getHeight());
        return Intrinsics.areEqual((Object)new Size(var1_1.getCropRect().width(), var1_1.getCropRect().height()), (Object)cameraImageUtils) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(ImageProxy image) throws CodecFailedException {
        void var1_1;
        CameraImageUtils cameraImageUtils = this_;
        void v1 = var1_1;
        ImageProxy.PlaneProxy[] planeProxyArray = v1.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        ImageProxy.PlaneProxy planeProxy = planeProxyArray[0];
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[0]");
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[0].buffer");
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.capacity()];
        Object this_ = byArray;
        byteBuffer.get(byArray);
        if (cameraImageUtils.b((ImageProxy)v1)) {
            this_ = CameraImageUtils.cropByteArray((byte[])this_, var1_1.getCropRect());
        }
        return this_;
    }

    private final byte[] d(ImageProxy image) throws CodecFailedException {
        Rect rect;
        void v0 = rect;
        byte[] byArray = this.c((ImageProxy)rect);
        int n = v0.getWidth();
        int n2 = v0.getHeight();
        rect = this.b((ImageProxy)v0) ? rect.getCropRect() : null;
        return this.a(byArray, n, n2, rect);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] bitmapToNv21(@NotNull Bitmap src, int width, int height) throws CodecFailedException {
        void var2_2;
        Object object;
        void var1_1;
        Bitmap bitmap = src;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"src");
        if (bitmap.getWidth() >= var1_1 && object.getHeight() >= var2_2) {
            Bitmap bitmap2 = object;
            int[] nArray = new int[var1_1 * var2_2];
            object = nArray;
            bitmap2.getPixels(nArray, 0, (int)var1_1, 0, 0, (int)var1_1, (int)var2_2);
            return INSTANCE.a((int[])object, (int)var1_1, (int)var2_2);
        }
        throw new CodecFailedException("Invalid source Bitmap image!");
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] a(int[] argb, int width, int height) {
        int n;
        int n2 = width * n;
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 * 3 / 2;
        byte[] byArray = new byte[n5];
        for (int k = 0; k < n; ++k) {
            int n6;
            for (int i2 = 0; i2 < n6; ++i2) {
                void var1_2;
                int n7 = (var1_2[n4] & 0xFF0000) >> 16;
                int n8 = (var1_2[n4] & 0xFF00) >> 8;
                int n9 = var1_2[n4] & 0xFF;
                int n10 = (n7 * 66 + n8 * 129 + n9 * 25 + 128 >> 8) + 16;
                int n11 = n7;
                n7 = (n11 * 112 - n8 * 94 - n9 * 18 + 128 >> 8) + 128;
                n8 = (n11 * -38 - n8 * 74 + n9 * 112 + 128 >> 8) + 128;
                n9 = n3 + 1;
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > 255) {
                    n10 = 255;
                }
                byArray[n3] = (byte)n10;
                if (k % 2 == 0 && n4 % 2 == 0 && n2 < n5 - 2) {
                    n3 = n2 + 1;
                    if (n8 < 0) {
                        n8 = 0;
                    } else if (n8 > 255) {
                        n8 = 255;
                    }
                    byArray[n2] = (byte)n8;
                    n2 = n3 + 1;
                    if (n7 < 0) {
                        n7 = 0;
                    } else if (n7 > 255) {
                        n7 = 255;
                    }
                    byArray[n3] = (byte)n7;
                }
                ++n4;
                n3 = n9;
            }
        }
        return byArray;
    }

    private CameraImageUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        void var1_1;
        return aspectRatio != null && var1_1.floatValue() > 0.0f && !var1_1.isNaN();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceSize");
        return aspectRatio != null && var2_2.floatValue() > 0.0f && this.a((Size)var1_1, (Rational)var2_2) && !var2_2.isNaN();
    }
}

