/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.content.Context;
import android.graphics.Point;
import android.util.Pair;
import android.util.Size;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import io.scanbot.sdk.exceptions.camera.CameraTransformationException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J,\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0002H\u0007J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0007\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/ui/camera/util/ScaleTypeTransform;", "", "Landroid/view/View;", "container", "view", "Landroid/util/Size;", "bufferSize", "Landroid/util/Pair;", "", "getFillScaleWithBufferAspectRatio", "getFitScaleWithBufferAspectRatio", "Landroid/graphics/Point;", "getOriginOfCenteredView", "", "getRotationDegrees", "Landroid/content/Context;", "context", "rotationDegrees", "", "isNaturalPortrait", "rotationConstant", "rotationDegreesFromSurfaceRotation", "<init>", "()V", "sdk-base_release"})
public final class ScaleTypeTransform {
    @NotNull
    public static final ScaleTypeTransform INSTANCE = new ScaleTypeTransform();

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFillScaleWithBufferAspectRatio(@NotNull View container, @NotNull View view, @NotNull Size bufferSize) {
        void var2_5;
        void var1_3;
        View view2;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"view");
        Intrinsics.checkNotNullParameter((Object)var2_5, (String)"bufferSize");
        if (container.getWidth() != 0 && view2.getHeight() != 0 && var1_3.getWidth() != 0 && var1_3.getHeight() != 0 && var2_5.getWidth() != 0 && var2_5.getHeight() != 0) {
            int n;
            int n2;
            void v0 = var1_3;
            int n3 = ScaleTypeTransform.getRotationDegrees((View)v0);
            Context context = v0.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            if (ScaleTypeTransform.isNaturalPortrait(context, n3)) {
                void v2 = var2_5;
                n2 = v2.getHeight();
                n = v2.getWidth();
            } else {
                void v3 = var2_5;
                n2 = v3.getWidth();
                n = v3.getHeight();
            }
            float f2 = (float)n2 / (float)var1_3.getWidth();
            float f3 = (float)n / (float)var1_3.getHeight();
            if (n3 != 0 && n3 != 180) {
                n3 = n2;
                n2 = n;
            } else {
                n3 = n;
            }
            float f4 = f3;
            float f5 = Math.max((float)view2.getWidth() / (float)n2, (float)view2.getHeight() / (float)n3);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<Float, Float> getFitScaleWithBufferAspectRatio(@NotNull View container, @NotNull View view, @NotNull Size bufferSize) {
        void var2_5;
        void var1_3;
        View view2;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)var1_3, (String)"view");
        Intrinsics.checkNotNullParameter((Object)var2_5, (String)"bufferSize");
        if (container.getWidth() != 0 && view2.getHeight() != 0 && var1_3.getWidth() != 0 && var1_3.getHeight() != 0 && var2_5.getWidth() != 0 && var2_5.getHeight() != 0) {
            int n;
            int n2;
            void v0 = var1_3;
            int n3 = ScaleTypeTransform.getRotationDegrees((View)v0);
            Context context = v0.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            if (ScaleTypeTransform.isNaturalPortrait(context, n3)) {
                void v2 = var2_5;
                n2 = v2.getHeight();
                n = v2.getWidth();
            } else {
                void v3 = var2_5;
                n2 = v3.getWidth();
                n = v3.getHeight();
            }
            float f2 = (float)n2 / (float)var1_3.getWidth();
            float f3 = (float)n / (float)var1_3.getHeight();
            if (n3 != 0 && n3 != 180) {
                n3 = n2;
                n2 = n;
            } else {
                n3 = n;
            }
            float f4 = f3;
            float f5 = Math.min((float)view2.getWidth() / (float)n2, (float)view2.getHeight() / (float)n3);
            f3 = f2 * f5;
            f5 = f4 * f5;
            Float f6 = Float.valueOf(f3);
            return new Pair((Object)f6, (Object)Float.valueOf(f5));
        }
        return new Pair((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @JvmStatic
    @NotNull
    public static final Point getOriginOfCenteredView(@NotNull View container, @NotNull View view) {
        int n;
        View view2;
        View view3 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)view3, (String)"view");
        int n2 = (view3.getWidth() - view2.getWidth()) / 2;
        int n3 = n = (view3.getHeight() - view2.getHeight()) / 2;
        n = -n2;
        return new Point(n, -n3);
    }

    @JvmStatic
    public static final int getRotationDegrees(@NotNull View view) {
        View view2 = view;
        Intrinsics.checkNotNullParameter((Object)view2, (String)"view");
        Object object = view2.getContext().getSystemService("window");
        if (object != null) {
            Display display = ((WindowManager)object).getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"windowManager.defaultDisplay");
            return ScaleTypeTransform.rotationDegreesFromSurfaceRotation(display.getRotation());
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isNaturalPortrait(@NotNull Context context, int rotationDegrees) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = context2.getSystemService("window");
        if (object != null) {
            void var1_2;
            object = ((WindowManager)object).getDefaultDisplay();
            Point point = new Point();
            object.getRealSize(point);
            int n = point.x;
            int n2 = point.y;
            return (var1_2 == false || var1_2 == 180) && n < n2 || (var1_2 == 90 || var1_2 == 270) && n >= n2;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
    }

    @JvmStatic
    public static final int rotationDegreesFromSurfaceRotation(int rotationConstant) {
        int n;
        switch (rotationConstant) {
            default: {
                int n2;
                throw new CameraTransformationException("Unsupported surface rotation constant: " + n2);
            }
            case 3: {
                n = 270;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        return n;
    }

    private ScaleTypeTransform() {
    }
}

