/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "", "nv21Image", "", "imageWidth", "imageHeight", "imageOrientation", "Landroid/graphics/Bitmap;", "convertNV21ToBitmap", "([BIII)Landroid/graphics/Bitmap;", "Landroidx/camera/core/ImageProxy;", "image", "convertYUV420toNV21", "(Landroidx/camera/core/ImageProxy;)[B", "<init>", "()V", "sdk-base_release"})
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Bitmap bitmap;
        Throwable throwable;
        ByteArrayOutputStream byteArrayOutputStream;
        block12: {
            void var3_6;
            Matrix matrix;
            Rect rect;
            YuvImage yuvImage;
            void var2_5;
            void var1_4;
            ByteArrayOutputStream byteArrayOutputStream2;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21Image");
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            throwable = null;
            try {
                yuvImage = new YuvImage(byArray, 17, (int)var1_4, (int)var2_5, null);
                rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
            }
            catch (Throwable throwable2) {
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable2);
                    throw throwable3;
                }
            }
            yuvImage.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            int n = 0;
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n, (int)byArray2.length);
            if (imageOrientation == 0) break block12;
            Bitmap bitmap2 = bitmap;
            bitmap = matrix;
            bitmap();
            float f2 = (float)var3_6;
            matrix.postRotate(f2);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"resultBitmap");
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable);
        return bitmap;
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"image.cropRect");
        int n = imageProxy.getFormat();
        int n2 = rect.width();
        int n3 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4 * ImageFormat.getBitsPerPixel((int)n) / 8];
        ImageProxy.PlaneProxy planeProxy = planeProxyArray[0];
        Intrinsics.checkNotNullExpressionValue((Object)planeProxy, (String)"planes[0]");
        byte[] byArray2 = new byte[planeProxy.getRowStride()];
        int n5 = 0;
        int n6 = 1;
        int n7 = planeProxyArray.length;
        for (int i2 = 0; i2 < n7; ++i2) {
            if (i2 != 0) {
                if (i2 != 1) {
                    if (i2 == 2) {
                        n6 = 2;
                        n5 = n4;
                    }
                } else {
                    n5 = n4 + 1;
                    n6 = 2;
                }
            } else {
                n5 = 0;
                n6 = 1;
            }
            ImageProxy.PlaneProxy planeProxy2 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy2, (String)"planes[i]");
            ByteBuffer byteBuffer = planeProxy2.getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[i].buffer");
            ImageProxy.PlaneProxy planeProxy3 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy3, (String)"planes[i]");
            int n8 = planeProxy3.getRowStride();
            ImageProxy.PlaneProxy planeProxy4 = planeProxyArray[i2];
            Intrinsics.checkNotNullExpressionValue((Object)planeProxy4, (String)"planes[i]");
            int n9 = planeProxy4.getPixelStride();
            int n10 = i2 == 0 ? 0 : 1;
            int n11 = n2 >> n10;
            int n12 = n3 >> n10;
            byteBuffer.position(n8 * (rect.top >> n10) + n9 * (rect.left >> n10));
            for (n10 = 0; n10 < n12; ++n10) {
                int n13;
                if (n9 == 1 && n6 == 1) {
                    byteBuffer.get(byArray, n5, n11);
                    n5 += n11;
                    n13 = n11;
                } else {
                    n13 = (n11 - 1) * n9 + 1;
                    byteBuffer.get(byArray2, 0, n13);
                    for (int i3 = 0; i3 < n11; ++i3) {
                        byArray[n5] = byArray2[i3 * n9];
                        n5 += n6;
                    }
                }
                if (n10 >= n12 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n8 - n13);
            }
        }
        return byArray;
    }

    private PreviewImageUtil() {
    }
}

