/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J1\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "", "nv21Image", "", "imageWidth", "imageHeight", "imageOrientation", "Landroid/graphics/Bitmap;", "convertNV21ToBitmap", "([BIII)Landroid/graphics/Bitmap;", "Landroidx/camera/core/ImageProxy;", "image", "convertYUV420toNV21", "(Landroidx/camera/core/ImageProxy;)[B", "<init>", "()V", "sdk-base_release"})
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    private PreviewImageUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Bitmap bitmap;
        Throwable throwable;
        ByteArrayOutputStream byteArrayOutputStream;
        block12: {
            void var3_6;
            Matrix matrix;
            Rect rect;
            YuvImage yuvImage;
            void var2_5;
            void var1_4;
            ByteArrayOutputStream byteArrayOutputStream2;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21Image");
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            throwable = null;
            try {
                yuvImage = new YuvImage(byArray, 17, (int)var1_4, (int)var2_5, null);
                rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
            }
            catch (Throwable throwable2) {
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable2);
                    throw throwable3;
                }
            }
            yuvImage.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            int n = 0;
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n, (int)byArray2.length);
            if (imageOrientation == 0) break block12;
            Bitmap bitmap2 = bitmap;
            bitmap = matrix;
            bitmap();
            float f = (float)var3_6;
            matrix.postRotate(f);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"resultBitmap");
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable);
        return bitmap;
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"image.cropRect");
        int n = imageProxy.getFormat();
        int n2 = rect.width();
        int n3 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4 * ImageFormat.getBitsPerPixel((int)n) / 8];
        byte[] byArray2 = new byte[planeProxyArray[0].getRowStride()];
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        int n8 = planeProxyArray.length + -1;
        if (n8 >= 0) {
            while (true) {
                int n9 = n7;
                int n10 = n9 + 1;
                if (n9 != 0) {
                    if (n7 != 1) {
                        if (n7 == 2) {
                            n6 = 2;
                            n5 = n4;
                        }
                    } else {
                        n5 = n4 + 1;
                        n6 = 2;
                    }
                } else {
                    n5 = 0;
                    n6 = 1;
                }
                ByteBuffer byteBuffer = planeProxyArray[n7].getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[i].buffer");
                int n11 = planeProxyArray[n7].getRowStride();
                int n12 = planeProxyArray[n7].getPixelStride();
                int n13 = n7 == 0 ? 0 : 1;
                int n14 = n2 >> n13;
                int n15 = n3 >> n13;
                byteBuffer.position(n11 * (rect.top >> n13) + n12 * (rect.left >> n13));
                n13 = 0;
                if (n15 > 0) {
                    while (true) {
                        int n16;
                        int n17 = n13 + 1;
                        if (n12 == 1 && n6 == 1) {
                            byteBuffer.get(byArray, n5, n14);
                            n5 += n14;
                            n16 = n14;
                        } else {
                            n16 = (n14 - 1) * n12 + 1;
                            byteBuffer.get(byArray2, 0, n16);
                            int n18 = 0;
                            if (n14 > 0) {
                                while (true) {
                                    int n19 = n18 + 1;
                                    byArray[n5] = byArray2[n18 * n12];
                                    n5 += n6;
                                    if (n19 >= n14) break;
                                    n18 = n19;
                                }
                            }
                        }
                        if (n13 < n15 - 1) {
                            ByteBuffer byteBuffer2 = byteBuffer;
                            byteBuffer2.position(byteBuffer2.position() + n11 - n16);
                        }
                        if (n17 >= n15) break;
                        n13 = n17;
                    }
                }
                if (n10 > n8) break;
                n7 = n10;
            }
        }
        return byArray;
    }
}

