/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import io.scanbot.sdk.util.CursorUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J=\u0010\u000b\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007R\u0014\u0010\u0013\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0012\u00a8\u0006 "}, d2={"Lio/scanbot/sdk/util/FileChooserUtils;", "", "Landroid/content/Context;", "context", "Landroid/net/Uri;", "uri", "", "getPath", "selection", "", "selectionArgs", "getDataColumn", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "", "isExternalStorageDocument", "isDownloadsDocument", "isMediaDocument", "a", "Ljava/lang/String;", "CONTENT_SCHEME", "b", "FILE_SCHEME", "c", "EXTERNALSTORAGE_AUTHORITY", "d", "DOWNLOADS_AUTHORITY", "e", "MEDIA_AUTHORITY", "f", "PUBLIC_DOWNLOADS_LINK", "<init>", "()V", "sdk-base_release"})
public final class FileChooserUtils {
    @NotNull
    public static final FileChooserUtils INSTANCE = new FileChooserUtils();
    @NotNull
    public static final String a = "content";
    @NotNull
    public static final String b = "file";
    @NotNull
    public static final String c = "com.android.externalstorage.documents";
    @NotNull
    public static final String d = "com.android.providers.downloads.documents";
    @NotNull
    public static final String e = "com.android.providers.media.documents";
    @NotNull
    public static final String f = "content://downloads/public_downloads";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final String getPath(@Nullable Context context, @NotNull Uri uri) {
        String[] stringArray;
        String[] stringArray2;
        void v0 = stringArray2;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"uri");
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)v0)) {
            if (FileChooserUtils.isExternalStorageDocument((Uri)stringArray2)) {
                String string = DocumentsContract.getDocumentId((Uri)stringArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
                stringArray = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
                if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                if (!StringsKt.equals((String)"primary", (String)stringArray[0], (boolean)true)) return null;
                return Environment.getExternalStorageDirectory().toString() + '/' + stringArray[1];
            }
            if (FileChooserUtils.isDownloadsDocument((Uri)stringArray2)) {
                Long l = Long.valueOf(DocumentsContract.getDocumentId((Uri)stringArray2));
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(id)");
                Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)f), (long)l);
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"withAppendedId(\n        \u2026va.lang.Long.valueOf(id))");
                return FileChooserUtils.getDataColumn((Context)stringArray, uri2, null, null);
            }
            if (!FileChooserUtils.isMediaDocument((Uri)stringArray2)) return null;
            String string = DocumentsContract.getDocumentId((Uri)stringArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"docId");
            stringArray2 = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).toArray(new String[0]);
            if (stringArray2 == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            Uri uri3 = null;
            if (Intrinsics.areEqual((Object)"image", (Object)stringArray2[0])) {
                uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            }
            String[] stringArray3 = stringArray;
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = stringArray2[1];
            return FileChooserUtils.getDataColumn((Context)stringArray3, uri3, "_id=?", stringArray);
        }
        if (StringsKt.equals((String)a, (String)stringArray2.getScheme(), (boolean)true)) {
            return FileChooserUtils.getDataColumn((Context)stringArray, (Uri)stringArray2, null, null);
        }
        if (!StringsKt.equals((String)b, (String)stringArray2.getScheme(), (boolean)true)) return null;
        return stringArray2.getPath();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final String getDataColumn(@Nullable Context context, @Nullable Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        void var0_14;
        void var1_15;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_data";
        if (context == null) {
            void var0_4;
            if (var1_15 != null) {
                String string = var1_15.getPath();
                if (string != null) return var0_4;
            }
            String string = "";
            return var0_4;
        }
        if (var1_15 != null) {
            void var3_18;
            void var2_17;
            Context context2;
            ContentResolver contentResolver = context2.getContentResolver();
            if (contentResolver == null) {
                void var0_8;
                String string = var1_15.getPath();
                if (string != null) return var0_8;
                return var0_8;
            }
            Cursor cursor = contentResolver.query((Uri)var1_15, stringArray2, (String)var2_17, (String[])var3_18, null);
            if (cursor != null) {
                Cursor cursor2 = cursor;
                int n = cursor2.getColumnIndexOrThrow("_data");
                cursor2.moveToFirst();
                String string = cursor2.getString(n);
                CursorUtil.closeQuietly(cursor);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                return string;
            }
        }
        if (var1_15 != null) {
            String string = var1_15.getPath();
            if (string != null) return var0_14;
        }
        String string = "";
        return var0_14;
    }

    @JvmStatic
    public static final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)c, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isDownloadsDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)d, (Object)uri2.getAuthority());
    }

    @JvmStatic
    public static final boolean isMediaDocument(@NotNull Uri uri) {
        Uri uri2 = uri;
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        return Intrinsics.areEqual((Object)e, (Object)uri2.getAuthority());
    }
}

